/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.RefreshDiguisedModel;
import net.geforcemods.securitycraft.util.BlockEntityRenderDelegate;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class DisguisableBlockEntity
extends CustomizableBlockEntity {
    @Override
    public void onModuleInserted(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleInserted(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onInsertDisguiseModule(this, stack, toggled);
        }
    }

    public static void onInsertDisguiseModule(TileEntity te, ItemStack stack, boolean toggled) {
        if (te.func_145830_o()) {
            World world = te.func_145831_w();
            BlockPos pos = te.func_174877_v();
            if (!world.field_72995_K) {
                SecurityCraft.network.sendToAllTracking((IMessage)new RefreshDiguisedModel(pos, true, stack, toggled), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0));
            } else {
                IBlockState state = world.func_180495_p(pos);
                BlockEntityRenderDelegate.putDisguisedTeRenderer(te, stack);
                if (state.getLightValue((IBlockAccess)world, pos) > 0) {
                    world.func_175664_x(pos);
                }
            }
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module, boolean toggled) {
        super.onModuleRemoved(stack, module, toggled);
        if (module == ModuleType.DISGUISE) {
            DisguisableBlockEntity.onRemoveDisguiseModule(this, stack, toggled);
        }
    }

    public static void onRemoveDisguiseModule(TileEntity te, ItemStack stack, boolean toggled) {
        if (te.func_145830_o()) {
            World world = te.func_145831_w();
            BlockPos pos = te.func_174877_v();
            if (!world.field_72995_K) {
                SecurityCraft.network.sendToAllTracking((IMessage)new RefreshDiguisedModel(pos, false, stack, toggled), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0));
            } else {
                IBlockState disguisedState = ((IDisguisable)te.func_145838_q()).getDisguisedBlockStateFromStack(null, null, stack);
                BlockEntityRenderDelegate.DISGUISED_BLOCK.removeDelegateOf(te);
                if (disguisedState != null && disguisedState.getLightValue((IBlockAccess)world, pos) > 0) {
                    world.func_175664_x(pos);
                }
            }
        }
    }

    public void onLoad() {
        super.onLoad();
        DisguisableBlockEntity.onLoad(this);
    }

    public static <T extends TileEntity> void onLoad(T te) {
        if (te.func_145830_o() && te.func_145831_w().field_72995_K) {
            BlockEntityRenderDelegate.putDisguisedTeRenderer(te, ((IModuleInventory)te).getModule(ModuleType.DISGUISE));
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        DisguisableBlockEntity.onInvalidate(this);
    }

    public static void onInvalidate(TileEntity te) {
        if (te.func_145830_o() && te.func_145831_w().field_72995_K) {
            BlockEntityRenderDelegate.DISGUISED_BLOCK.removeDelegateOf(te);
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[0];
    }
}

