/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import com.google.common.base.Predicate;
import java.util.List;
import java.util.Random;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.ProjectorBlockEntity;
import net.geforcemods.securitycraft.blocks.DisguisableBlock;
import net.geforcemods.securitycraft.screen.ScreenHandler;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProjectorBlock
extends DisguisableBlock {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool HANGING = PropertyBool.func_177716_a((String)"hanging");
    private static final AxisAlignedBB FLOOR_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 0.9375);
    private static final AxisAlignedBB FLOOR_EAST = new AxisAlignedBB(0.0625, 0.0, 0.0, 1.0, 0.625, 1.0);
    private static final AxisAlignedBB FLOOR_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.0625, 1.0, 0.625, 1.0);
    private static final AxisAlignedBB FLOOR_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.9375, 0.625, 1.0);
    private static final AxisAlignedBB CEILING = new AxisAlignedBB(0.0625, 0.375, 0.0625, 0.9375, 0.6875, 0.9375);

    public ProjectorBlock() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf(false)));
        this.func_149672_a(SoundType.field_185852_e);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (!((Boolean)state.func_177229_b((IProperty)HANGING)).booleanValue()) {
            switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
                case NORTH: {
                    return FLOOR_NORTH;
                }
                case EAST: {
                    return FLOOR_EAST;
                }
                case SOUTH: {
                    return FLOOR_SOUTH;
                }
                case WEST: {
                    return FLOOR_WEST;
                }
            }
            return super.func_185496_a(state, world, pos);
        }
        return CEILING;
    }

    @Override
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = this.getDisguisedBlockState(world, pos);
        if (actualState != null && actualState.func_177230_c() != this) {
            return actualState.func_185890_d(world, pos);
        }
        return this.func_185496_a(state, world, pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof ProjectorBlockEntity)) {
            return false;
        }
        boolean isOwner = ((ProjectorBlockEntity)te).isOwnedBy((Entity)player);
        if (!world.field_72995_K && isOwner) {
            player.openGui((Object)SecurityCraft.instance, ScreenHandler.Screens.PROJECTOR.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return isOwner;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side != null && side.func_176740_k() == EnumFacing.Axis.Y;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ProjectorBlockEntity) {
            EntityItem item = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ((ProjectorBlockEntity)te).func_70301_a(36));
            Utils.addScheduledTask(world, () -> world.func_72838_d((Entity)item));
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        ProjectorBlockEntity te;
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) instanceof ProjectorBlockEntity && (te = (ProjectorBlockEntity)tile).isActivatedByRedstone()) {
            te.setActive(world.func_175640_z(pos));
            te.sync();
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        ProjectorBlockEntity te;
        TileEntity tile;
        if (!world.func_175640_z(pos) && (tile = world.func_175625_s(pos)) instanceof ProjectorBlockEntity && (te = (ProjectorBlockEntity)tile).isActivatedByRedstone()) {
            te.setActive(false);
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing clickedFace, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf(clickedFace == EnumFacing.DOWN));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() + ((Boolean)state.func_177229_b((IProperty)HANGING) != false ? 4 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta)).func_177226_a((IProperty)HANGING, (Comparable)Boolean.valueOf(meta > 3));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, HANGING});
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new ProjectorBlockEntity();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(new TextComponentTranslation("tooltip.securitycraft:projector", new Object[0]).func_150254_d());
    }
}

