/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.misc.TargetingMode;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class ExplosiveBlock
extends OwnableBlock
implements IExplosive {
    protected ExplosiveBlock(Material material) {
        super(material);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        Item heldItem = player.func_184586_b(hand).func_77973_b();
        if (heldItem == SCContent.mineRemoteAccessTool || heldItem == SCContent.universalOwnerChanger) {
            return false;
        }
        if (this.isActive(world, pos) && this.isDefusable() && heldItem == SCContent.wireCutters) {
            if (this.defuseMine(world, pos)) {
                if (!player.func_184812_l_()) {
                    player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
                }
                world.func_184133_a(null, pos, SoundEvents.field_187763_eJ, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return true;
        }
        if (!this.isActive(world, pos) && heldItem == Items.field_151033_d) {
            if (this.activateMine(world, pos)) {
                if (!player.func_184812_l_()) {
                    player.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)player);
                }
                world.func_184133_a(null, pos, SoundEvents.field_187907_gg, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (this.explodesWhenInteractedWith() && this.isActive(world, pos)) {
            if (te instanceof IOwnable && ((IOwnable)te).isOwnedBy((Entity)player)) {
                return false;
            }
            if (te instanceof ICustomizable) {
                ICustomizable mine = (ICustomizable)te;
                for (Option<?> option : mine.customOptions()) {
                    if (!(option instanceof Option.TargetingModeOption)) continue;
                    if (((TargetingMode)((Object)((Option.TargetingModeOption)option).get())).allowsPlayers()) break;
                    return false;
                }
            }
            this.explode(world, pos);
            return true;
        }
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.NORMAL;
    }

    public boolean explodesWhenInteractedWith() {
        return true;
    }

    @Override
    public boolean isDefusable() {
        return true;
    }
}

