/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.Map;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IReinforcedBlock;
import net.geforcemods.securitycraft.screen.ScreenHandler;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class UniversalBlockReinforcerItem
extends Item {
    public UniversalBlockReinforcerItem(int damage) {
        this.func_77656_e(damage);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            UniversalBlockReinforcerItem.maybeRemoveMending(heldItem);
            player.openGui((Object)"securitycraft", ScreenHandler.Screens.BLOCK_REINFORCER.ordinal(), world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public static boolean convertBlock(ItemStack stack, BlockPos pos, EntityPlayer player) {
        World world = player.func_130014_f_();
        if (!player.field_71075_bZ.field_75098_d) {
            boolean isReinforcing = UniversalBlockReinforcerItem.isReinforcing(stack);
            IBlockState state = world.func_180495_p(pos);
            Block blockToConvert = state.func_177230_c();
            IBlockState convertedState = null;
            if (isReinforcing) {
                Block convertedBlock = IReinforcedBlock.VANILLA_TO_SECURITYCRAFT.get(blockToConvert);
                if (convertedBlock instanceof IReinforcedBlock) {
                    convertedState = ((IReinforcedBlock)convertedBlock).convertToReinforcedState(state);
                }
            } else if (blockToConvert instanceof IReinforcedBlock) {
                try {
                    convertedState = ((IReinforcedBlock)blockToConvert).convertToVanillaState(state);
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
            }
            if (convertedState != null) {
                TileEntity te = world.func_175625_s(pos);
                NBTTagCompound tag = null;
                if (!isReinforcing && te instanceof IOwnable && !((IOwnable)te).isOwnedBy((Entity)player) || !world.func_175660_a(player, pos)) {
                    return false;
                }
                if (!world.field_72995_K) {
                    if (te != null) {
                        tag = te.func_189515_b(new NBTTagCompound());
                        if (te instanceof IModuleInventory) {
                            ((IModuleInventory)te).dropAllModules();
                        }
                        if (te instanceof IInventory) {
                            ((IInventory)te).func_174888_l();
                        }
                    }
                    world.func_175656_a(pos, convertedState);
                    te = world.func_175625_s(pos);
                    if (te != null) {
                        if (tag != null) {
                            te.func_145839_a(tag);
                        }
                        if (isReinforcing) {
                            ((IOwnable)te).setOwner(player.func_146103_bH().getId().toString(), player.func_70005_c_());
                        }
                    }
                    stack.func_77972_a(1, (EntityLivingBase)player);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isReinforcing(ItemStack stack) {
        if (stack.func_77973_b() == SCContent.universalBlockReinforcerLvL1) {
            return true;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return !stack.func_77978_p().func_74767_n("is_unreinforcing");
    }

    public static void maybeRemoveMending(ItemStack stack) {
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (enchantments.containsKey(Enchantments.field_185296_A)) {
            enchantments.remove(Enchantments.field_185296_A);
            EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)stack);
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return !EnchantmentHelper.func_82781_a((ItemStack)book).containsKey(Enchantments.field_185296_A);
    }
}

