/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.function.Predicate;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IOwnable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public enum TargetingMode {
    PLAYERS("gui.securitycraft:srat.targets3"),
    PLAYERS_AND_MOBS("gui.securitycraft:srat.targets1"),
    MOBS("gui.securitycraft:srat.targets2");

    private final String translationKey;

    private TargetingMode(String translationKey) {
        this.translationKey = translationKey;
    }

    public ITextComponent translate() {
        return new TextComponentTranslation(this.translationKey, new Object[0]);
    }

    public boolean allowsPlayers() {
        return this == PLAYERS || this == PLAYERS_AND_MOBS;
    }

    public boolean allowsMobs() {
        return this == MOBS || this == PLAYERS_AND_MOBS;
    }

    public <T extends IOwnable> boolean canAttackEntity(EntityLivingBase entity, T be, Predicate<EntityLivingBase> isInvisible) {
        if (entity == null || be instanceof IModuleInventory && ((IModuleInventory)((Object)be)).isAllowed((Entity)entity)) {
            return false;
        }
        boolean isPlayer = entity instanceof EntityPlayer;
        if (isPlayer && this.allowsPlayers() || !isPlayer && this.allowsMobs()) {
            return (!isPlayer || (!be.isOwnedBy((Entity)entity) || !be.ignoresOwner()) && !((EntityPlayer)entity).func_184812_l_() && !((EntityPlayer)entity).func_175149_v()) && !isInvisible.test(entity) && !be.allowsOwnableEntity((Entity)entity);
        }
        return false;
    }
}

