/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SetDefaultCameraViewingDirection
implements IMessage {
    private int id;
    private float initialXRotation;
    private float initialYRotation;
    private float initialZoom;

    public SetDefaultCameraViewingDirection() {
    }

    public SetDefaultCameraViewingDirection(SecurityCamera cam) {
        this.id = cam.func_145782_y();
        this.initialXRotation = cam.field_70125_A;
        this.initialYRotation = cam.field_70177_z;
        this.initialZoom = cam.getZoomAmount();
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.initialXRotation = buf.readFloat();
        this.initialYRotation = buf.readFloat();
        this.initialZoom = buf.readFloat();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeFloat(this.initialXRotation);
        buf.writeFloat(this.initialYRotation);
        buf.writeFloat(this.initialZoom);
    }

    public static class Handler
    implements IMessageHandler<SetDefaultCameraViewingDirection, IMessage> {
        public IMessage onMessage(SetDefaultCameraViewingDirection message, MessageContext ctx) {
            Utils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                TileEntity te;
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                Entity playerCamera = player.func_175398_C();
                if (playerCamera.func_145782_y() == message.id && playerCamera instanceof SecurityCamera && (te = playerCamera.field_70170_p.func_175625_s(new BlockPos(playerCamera.field_70165_t, playerCamera.field_70163_u, playerCamera.field_70161_v))) instanceof SecurityCameraBlockEntity) {
                    SecurityCameraBlockEntity be = (SecurityCameraBlockEntity)te;
                    if (!be.isOwnedBy((Entity)player)) {
                        player.func_146105_b((ITextComponent)Utils.localize("messages.securitycraft:security_camera.no_permission", new Object[0]), true);
                        return;
                    }
                    if (be.isModuleEnabled(ModuleType.SMART)) {
                        be.setDefaultViewingDirection(message.initialXRotation, message.initialYRotation, message.initialZoom);
                        player.func_146105_b((ITextComponent)Utils.localize("messages.securitycraft:security_camera.direction_set", new Object[0]), true);
                    } else {
                        player.func_146105_b((ITextComponent)Utils.localize("messages.securitycraft:security_camera.smart_module_needed", new Object[0]), true);
                    }
                }
            });
            return null;
        }
    }
}

