/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SyncBlockChangeDetector
implements IMessage {
    private BlockPos pos;
    private BlockChangeDetectorBlockEntity.EnumDetectionMode mode;
    private boolean showHighlights;
    private int color;

    public SyncBlockChangeDetector() {
    }

    public SyncBlockChangeDetector(BlockPos pos, BlockChangeDetectorBlockEntity.EnumDetectionMode mode, boolean showHighlights, int color) {
        this.pos = pos;
        this.mode = mode;
        this.showHighlights = showHighlights;
        this.color = color;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.mode = BlockChangeDetectorBlockEntity.EnumDetectionMode.values()[ByteBufUtils.readVarInt((ByteBuf)buf, (int)5)];
        this.showHighlights = buf.readBoolean();
        this.color = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.mode.ordinal(), (int)5);
        buf.writeBoolean(this.showHighlights);
        buf.writeInt(this.color);
    }

    public static class Handler
    implements IMessageHandler<SyncBlockChangeDetector, IMessage> {
        public IMessage onMessage(SyncBlockChangeDetector message, MessageContext ctx) {
            Utils.addScheduledTask(ctx.getServerHandler().field_147369_b.field_70170_p, () -> {
                BlockChangeDetectorBlockEntity te;
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                World level = player.field_70170_p;
                TileEntity tile = level.func_175625_s(message.pos);
                if (tile instanceof BlockChangeDetectorBlockEntity && (te = (BlockChangeDetectorBlockEntity)tile).isOwnedBy((Entity)player)) {
                    IBlockState state = level.func_180495_p(message.pos);
                    te.setMode(message.mode);
                    te.showHighlights(message.showHighlights);
                    te.setColor(message.color);
                    te.func_70296_d();
                    level.func_184138_a(message.pos, state, state, 2);
                }
            });
            return null;
        }
    }
}

