/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.io.IOException;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IPasscodeProtected;
import net.geforcemods.securitycraft.inventory.GenericMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.CheckPasscode;
import net.geforcemods.securitycraft.screen.components.CallbackCheckbox;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class CheckPasscodeScreen
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/check_passcode.png");
    private final String cooldownText1 = new TextComponentTranslation("gui.securitycraft:passcode.cooldown1", new Object[0]).func_150254_d();
    private int cooldownText1XPos;
    private IPasscodeProtected be;
    private char[] allowedChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\b', '\u001b'};
    private String title;
    private CensoringEditBox keycodeTextbox;
    private boolean wasOnCooldownLastRenderTick = false;

    public CheckPasscodeScreen(TileEntity tileEntity) {
        super((Container)new GenericMenu(tileEntity));
        this.be = (IPasscodeProtected)tileEntity;
        this.title = tileEntity.func_145748_c_().func_150254_d();
        this.field_147000_g = 186;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.cooldownText1XPos = this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.cooldownText1) / 2;
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.add(new CallbackCheckbox(0, this.field_146294_l / 2 - 37, this.field_146295_m / 2 - 55, 12, 12, Utils.localize("gui.securitycraft:passcode.showPasscode", new Object[0]).func_150254_d(), false, newState -> this.keycodeTextbox.setCensoring(newState == false), 0x404040));
        this.field_146292_n.add(new ClickButton(1, this.field_146294_l / 2 - 33, this.field_146295_m / 2 - 35, 20, 20, "1", b -> this.addNumberToString(1)));
        this.field_146292_n.add(new ClickButton(2, this.field_146294_l / 2 - 8, this.field_146295_m / 2 - 35, 20, 20, "2", b -> this.addNumberToString(2)));
        this.field_146292_n.add(new ClickButton(3, this.field_146294_l / 2 + 17, this.field_146295_m / 2 - 35, 20, 20, "3", b -> this.addNumberToString(3)));
        this.field_146292_n.add(new ClickButton(4, this.field_146294_l / 2 - 33, this.field_146295_m / 2 - 10, 20, 20, "4", b -> this.addNumberToString(4)));
        this.field_146292_n.add(new ClickButton(5, this.field_146294_l / 2 - 8, this.field_146295_m / 2 - 10, 20, 20, "5", b -> this.addNumberToString(5)));
        this.field_146292_n.add(new ClickButton(6, this.field_146294_l / 2 + 17, this.field_146295_m / 2 - 10, 20, 20, "6", b -> this.addNumberToString(6)));
        this.field_146292_n.add(new ClickButton(7, this.field_146294_l / 2 - 33, this.field_146295_m / 2 + 15, 20, 20, "7", b -> this.addNumberToString(7)));
        this.field_146292_n.add(new ClickButton(8, this.field_146294_l / 2 - 8, this.field_146295_m / 2 + 15, 20, 20, "8", b -> this.addNumberToString(8)));
        this.field_146292_n.add(new ClickButton(9, this.field_146294_l / 2 + 17, this.field_146295_m / 2 + 15, 20, 20, "9", b -> this.addNumberToString(9)));
        this.field_146292_n.add(new ClickButton(10, this.field_146294_l / 2 - 33, this.field_146295_m / 2 + 40, 20, 20, "\u2190", b -> this.removeLastCharacter()));
        this.field_146292_n.add(new ClickButton(11, this.field_146294_l / 2 - 8, this.field_146295_m / 2 + 40, 20, 20, "0", b -> this.addNumberToString(0)));
        this.field_146292_n.add(new ClickButton(12, this.field_146294_l / 2 + 17, this.field_146295_m / 2 + 40, 20, 20, "\u2714", b -> this.checkCode(this.keycodeTextbox.func_146179_b())));
        this.keycodeTextbox = new CensoringEditBox(13, this.field_146289_q, this.field_146294_l / 2 - 37, this.field_146295_m / 2 - 72, 77, 12);
        this.keycodeTextbox.func_146193_g(-1);
        this.keycodeTextbox.func_146204_h(-1);
        this.keycodeTextbox.func_146185_a(true);
        this.keycodeTextbox.func_146203_f(Integer.MAX_VALUE);
        if (this.be.isOnCooldown()) {
            this.toggleChildrenActive(false);
        } else {
            this.keycodeTextbox.func_146195_b(true);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179140_f();
        this.keycodeTextbox.func_146194_f();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.title, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.title) / 2, 6, 0x404040);
        if (this.be.isOnCooldown()) {
            long cooldownEnd = this.be.getCooldownEnd();
            long secondsLeft = Math.max(cooldownEnd - System.currentTimeMillis(), 0L) / 1000L + 1L;
            String text = new TextComponentTranslation("gui.securitycraft:passcode.cooldown2", new Object[]{secondsLeft}).func_150254_d();
            this.field_146289_q.func_78276_b(this.cooldownText1, this.cooldownText1XPos, this.field_147000_g / 2 + 65, 0x404040);
            this.field_146289_q.func_78276_b(text, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(text) / 2, this.field_147000_g / 2 + 75, 0x404040);
            if (!this.wasOnCooldownLastRenderTick) {
                this.wasOnCooldownLastRenderTick = true;
            }
        } else if (this.wasOnCooldownLastRenderTick) {
            this.wasOnCooldownLastRenderTick = false;
            this.toggleChildrenActive(true);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.be.isOnCooldown()) {
            if (keyCode == 14 && this.keycodeTextbox.func_146179_b().length() > 0) {
                Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundEvents.field_187909_gi, 0.15f, 1.0f);
            }
            if (this.isValidChar(typedChar) && this.keycodeTextbox.func_146201_a(typedChar, keyCode)) {
                Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundEvents.field_187909_gi, 0.15f, 1.0f);
                return;
            }
            if (keyCode == 28 || keyCode == 156) {
                Minecraft.func_71410_x().field_71439_g.func_184185_a(SoundEvents.field_187909_gi, 0.15f, 1.0f);
                this.checkCode(this.keycodeTextbox.func_146179_b());
            }
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.keycodeTextbox.func_146192_a(mouseX, mouseY, mouseButton);
    }

    private boolean isValidChar(char c) {
        for (char allowedChar : this.allowedChars) {
            if (c != allowedChar) continue;
            return true;
        }
        return c == '\u0000';
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof ClickButton) {
            ((ClickButton)button).onClick();
        }
    }

    private void addNumberToString(int number) {
        this.keycodeTextbox.func_146191_b("" + number);
    }

    private void removeLastCharacter() {
        if (this.keycodeTextbox.func_146179_b().length() > 0) {
            this.keycodeTextbox.func_146175_b(-1);
        }
    }

    private void toggleChildrenActive(boolean setActive) {
        this.field_146292_n.forEach(button -> {
            button.field_146124_l = setActive;
        });
        this.keycodeTextbox.field_146226_p = setActive;
        this.keycodeTextbox.func_146195_b(setActive);
    }

    public void checkCode(String code) {
        BlockPos pos = ((TileEntity)this.be).func_174877_v();
        if (this.be instanceof IModuleInventory && ((IModuleInventory)((Object)this.be)).isModuleEnabled(ModuleType.SMART)) {
            this.toggleChildrenActive(false);
        }
        this.keycodeTextbox.func_146180_a("");
        SecurityCraft.network.sendToServer((IMessage)new CheckPasscode(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), code));
    }

    public static class CensoringEditBox
    extends GuiTextField
    implements GuiPageButtonList.GuiResponder {
        private String renderedText = "";
        private boolean shouldCensor = true;

        public CensoringEditBox(int id, FontRenderer font, int x, int y, int width, int height) {
            super(id, font, x, y, width, height);
            this.func_175207_a(this);
        }

        public boolean func_146201_a(char typedChar, int keyCode) {
            boolean success = false;
            if (this.field_146226_p) {
                boolean originalFocused = this.func_146206_l();
                this.func_146195_b(true);
                success = super.func_146201_a(typedChar, keyCode);
                this.func_146195_b(originalFocused);
            }
            return success;
        }

        public boolean func_146192_a(int mouseX, int mouseY, int button) {
            boolean success = false;
            if (this.field_146226_p) {
                String originalValue = this.field_146216_j;
                this.field_146216_j = this.renderedText;
                success = super.func_146192_a(mouseX, mouseY, button);
                this.field_146216_j = originalValue;
            }
            return success;
        }

        public void func_146194_f() {
            String originalText = this.field_146216_j;
            this.field_146216_j = this.renderedText;
            super.func_146194_f();
            this.field_146216_j = originalText;
        }

        public void func_146199_i(int position) {
            String originalText = this.field_146216_j;
            this.updateRenderedText(originalText);
            this.field_146216_j = this.renderedText;
            super.func_146199_i(position);
            this.field_146216_j = originalText;
        }

        public void setCensoring(boolean shouldCensor) {
            this.shouldCensor = shouldCensor;
            this.updateRenderedText(this.field_146216_j);
        }

        private void updateRenderedText(String original) {
            if (this.shouldCensor) {
                String x = "";
                for (int i = 1; i <= original.length(); ++i) {
                    x = x + "*";
                }
                this.renderedText = x;
            } else {
                this.renderedText = original;
            }
        }

        public void func_175319_a(int id, String text) {
            this.updateRenderedText(text);
        }

        public void func_175321_a(int id, boolean value) {
        }

        public void func_175320_a(int id, float value) {
        }
    }
}

