/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.item;

import com.supermartijn642.core.registry.RegistryUtil;
import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public final class CreativeItemGroup
extends CreativeTabs {
    private final String identifier;
    private final String translationKey;
    private final Supplier<ItemStack> icon;
    private Consumer<Consumer<ItemStack>> filler;
    private Comparator<ItemStack> sorter;

    public static CreativeItemGroup create(String modid, String name, Supplier<ItemStack> icon) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Item group name '" + name + "' must only contain characters [a-z0-9_.-]!");
        }
        String identifier = modid + "." + name;
        String translationKey = modid + ".item_group." + name;
        return new CreativeItemGroup(identifier, translationKey, icon);
    }

    public static CreativeItemGroup create(String modid, String name, ItemSupplier icon) {
        return CreativeItemGroup.create(modid, name, () -> icon.asItem().func_190903_i());
    }

    public static CreativeItemGroup create(String modid, String name, BlockSupplier icon) {
        return CreativeItemGroup.create(modid, name, () -> Item.func_150898_a((Block)icon.asBlock()));
    }

    public static CreativeItemGroup create(String modid, Supplier<ItemStack> icon) {
        if (!RegistryUtil.isValidNamespace(modid)) {
            throw new IllegalArgumentException("Modid '" + modid + "' must only contain characters [a-z0-9_.-]!");
        }
        String translationKey = modid + ".item_group";
        return new CreativeItemGroup(modid, translationKey, icon);
    }

    public static CreativeItemGroup create(String modid, ItemSupplier icon) {
        return CreativeItemGroup.create(modid, () -> icon.asItem().func_190903_i());
    }

    public static CreativeItemGroup create(String modid, BlockSupplier icon) {
        return CreativeItemGroup.create(modid, () -> Item.func_150898_a((Block)icon.asBlock()));
    }

    public static CreativeTabs getBuildingBlocks() {
        return CreativeTabs.field_78030_b;
    }

    public static CreativeTabs getDecoration() {
        return CreativeTabs.field_78031_c;
    }

    public static CreativeTabs getRedstone() {
        return CreativeTabs.field_78028_d;
    }

    public static CreativeTabs getTransportation() {
        return CreativeTabs.field_78029_e;
    }

    public static CreativeTabs getMisc() {
        return CreativeTabs.field_78026_f;
    }

    public static CreativeTabs getSearch() {
        return CreativeTabs.field_78027_g;
    }

    public static CreativeTabs getFood() {
        return CreativeTabs.field_78039_h;
    }

    public static CreativeTabs getTools() {
        return CreativeTabs.field_78040_i;
    }

    public static CreativeTabs getCombat() {
        return CreativeTabs.field_78037_j;
    }

    public static CreativeTabs getBrewing() {
        return CreativeTabs.field_78038_k;
    }

    private CreativeItemGroup(String identifier, String translationKey, Supplier<ItemStack> icon) {
        super(identifier);
        this.identifier = identifier;
        this.translationKey = translationKey;
        this.icon = icon;
    }

    public CreativeItemGroup filler(Consumer<Consumer<ItemStack>> filler) {
        this.filler = filler;
        return this;
    }

    public CreativeItemGroup sorter(Comparator<ItemStack> sorter) {
        this.sorter = sorter;
        return this;
    }

    public CreativeItemGroup sortAlphabetically() {
        return this.sorter(Comparator.comparing(ItemStack::func_82833_r));
    }

    public ItemStack func_78016_d() {
        ItemStack stack = this.icon.get();
        if (stack == null || stack.func_190926_b()) {
            throw new RuntimeException("Item group '" + this.identifier + "'s icon stack must not be empty!");
        }
        return stack;
    }

    public String func_78013_b() {
        return this.identifier;
    }

    public String func_78024_c() {
        return this.translationKey;
    }

    public void func_78018_a(NonNullList<ItemStack> items) {
        if (this.filler == null) {
            super.func_78018_a(items);
        } else {
            this.filler.accept(arg_0 -> items.add(arg_0));
        }
        if (this.sorter != null) {
            items.sort(this.sorter);
        }
    }

    @FunctionalInterface
    public static interface BlockSupplier {
        public Block asBlock();
    }

    @FunctionalInterface
    public static interface ItemSupplier {
        public Item asItem();
    }
}

