/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration.railcraft.tile;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.lang.ref.WeakReference;
import java.util.Locale;
import java.util.UUID;
import javax.annotation.Nullable;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Connector;
import mods.railcraft.api.charge.IBatteryCart;
import mods.railcraft.common.carts.EntityLocomotiveElectric;
import mods.railcraft.common.items.ItemTicket;
import mods.railcraft.common.items.ItemTicketGold;
import mods.railcraft.common.plugins.forge.NBTPlugin;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;
import pl.asie.computronics.integration.railcraft.LocomotiveManager;
import pl.asie.computronics.reference.Config;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.tile.TileEntityPeripheralBase;
import pl.asie.computronics.util.OCUtils;

public class TileLocomotiveRelay
extends TileEntityPeripheralBase
implements ITickable {
    private WeakReference<EntityLocomotiveElectric> locomotive;
    private boolean isBound = false;
    private UUID uuid;

    public TileLocomotiveRelay() {
        super("locomotive_relay", 0.0);
    }

    public void setLocomotive(EntityLocomotiveElectric loco) {
        this.locomotive = new WeakReference<EntityLocomotiveElectric>(loco);
        this.isBound = true;
        this.uuid = loco.getPersistentID();
    }

    @Nullable
    public EntityLocomotiveElectric getLocomotive() {
        return this.locomotive != null ? (EntityLocomotiveElectric)this.locomotive.get() : null;
    }

    public boolean isBound() {
        return this.isBound;
    }

    public boolean unbind() {
        if (this.isBound) {
            this.isBound = false;
            this.locomotive = null;
            this.uuid = null;
            return true;
        }
        return false;
    }

    public void func_73660_a() {
        super.update();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.isBound) {
            return;
        }
        if (this.uuid == null) {
            this.isBound = false;
        }
        if (this.uuid != null) {
            this.tryFindLocomotive(this.uuid);
        }
    }

    private void tryFindLocomotive(@Nullable UUID uuid) {
        if (uuid != null) {
            EntityLocomotiveElectric cart = LocomotiveManager.instance().getCartFromUUID(uuid);
            if (cart != null) {
                EntityLocomotiveElectric oldLoco = this.getLocomotive();
                if (oldLoco == null || cart != oldLoco) {
                    this.setLocomotive(cart);
                }
            } else {
                this.locomotive = null;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isBound = nbt.func_74767_n("bound");
        if (this.isBound) {
            this.uuid = NBTPlugin.readUUID((NBTTagCompound)nbt, (String)"locomotive");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        if (this.isBound && this.uuid != null) {
            NBTPlugin.writeUUID((NBTTagCompound)nbt, (String)"locomotive", (UUID)this.uuid);
        }
        nbt.func_74757_a("bound", this.isBound);
        return nbt;
    }

    @Override
    public void removeFromNBTForTransfer(NBTTagCompound data) {
        super.removeFromNBTForTransfer(data);
        data.func_82580_o("locomotive");
        data.func_82580_o("bound");
    }

    @Override
    public NBTTagCompound writeToRemoteNBT(NBTTagCompound nbt) {
        nbt = super.writeToRemoteNBT(nbt);
        nbt.func_74757_a("bound", this.isBound);
        return nbt;
    }

    @Override
    public void readFromRemoteNBT(NBTTagCompound nbt) {
        super.readFromRemoteNBT(nbt);
        if (nbt.func_74764_b("bound")) {
            this.isBound = nbt.func_74767_n("bound");
        }
    }

    @Nullable
    private String cannotAccessLocomotive(double amount, boolean isOC) {
        EntityLocomotiveElectric locomotive = this.getLocomotive();
        if (!this.isBound) {
            return "relay is not bound to a locomotive";
        }
        if (locomotive == null) {
            return "locomotive is currently not detectable";
        }
        if (locomotive.field_71093_bK != this.field_145850_b.field_73011_w.getDimension()) {
            return "relay and locomotive are in different dimensions";
        }
        if (locomotive.func_174818_b(this.func_174877_v()) > Config.LOCOMOTIVE_RELAY_RANGE * Config.LOCOMOTIVE_RELAY_RANGE) {
            return "locomotive is too far away";
        }
        if (locomotive.isSecure()) {
            return "locomotive is locked";
        }
        IBatteryCart cartBattery = LocomotiveManager.getCartBattery((ICapabilityProvider)locomotive);
        if (Config.LOCOMOTIVE_RELAY_CONSUME_CHARGE && cartBattery != null && (cartBattery.getCharge() <= 0.0 || cartBattery.removeCharge(10.0 * amount) < 10.0 * amount)) {
            return "locomotive out of energy";
        }
        if (isOC && Mods.isLoaded("opencomputers")) {
            return this.cannotAccessLocomotive_OC(amount);
        }
        return null;
    }

    @Optional.Method(modid="opencomputers")
    private boolean tryConsumeEnergy(double energy) {
        return !(this.node() instanceof Connector) || ((Connector)this.node()).tryChangeBuffer(-energy);
    }

    @Nullable
    @Optional.Method(modid="opencomputers")
    private String cannotAccessLocomotive_OC(double amount) {
        if (!this.tryConsumeEnergy(Config.LOCOMOTIVE_RELAY_BASE_POWER * amount)) {
            return "not enough energy";
        }
        return null;
    }

    @Override
    @Optional.Method(modid="opencomputers")
    protected OCUtils.Device deviceInfo() {
        return new OCUtils.Device("communication", "Locomotive interface", "Railcraft, Inc.", "Locoremotive (TM)", new String[0]);
    }

    private static Object[] setDestination(EntityLocomotiveElectric locomotive, Object[] arguments) {
        ItemStack ticket = locomotive.func_70301_a(0);
        if (ticket.func_77973_b() instanceof ItemTicketGold) {
            ItemTicket.setTicketData((ItemStack)ticket, (String)((String)arguments[0]), (String)((String)arguments[0]), (GameProfile)ItemTicketGold.getOwner((ItemStack)ticket));
            return new Object[]{locomotive.setDestination(ticket)};
        }
        return new Object[]{false, "there is no golden ticket inside the locomotive"};
    }

    @Callback(doc="function():string; gets the destination the locomotive is currently set to")
    @Optional.Method(modid="opencomputers")
    public Object[] getDestination(Context context, Arguments args) {
        String error = this.cannotAccessLocomotive(1.0, true);
        if (error != null) {
            return new Object[]{null, error};
        }
        return new Object[]{this.getLocomotive().getDestination()};
    }

    @Callback(doc="function(destination:string):boolean; Sets the locomotive's destination; there needs to be a golden ticket inside the locomotive")
    @Optional.Method(modid="opencomputers")
    public Object[] setDestination(Context c, Arguments a) {
        String error = this.cannotAccessLocomotive(3.0, true);
        if (error != null) {
            return new Object[]{null, error};
        }
        a.checkString(0);
        return TileLocomotiveRelay.setDestination(this.getLocomotive(), a.toArray());
    }

    @Callback(doc="function():number; gets the current charge of the locomotive")
    @Optional.Method(modid="opencomputers")
    public Object[] getCharge(Context context, Arguments args) {
        String error = this.cannotAccessLocomotive(1.0, true);
        if (error != null) {
            return new Object[]{null, error};
        }
        IBatteryCart cartBattery = LocomotiveManager.getCartBattery((ICapabilityProvider)this.getLocomotive());
        return new Object[]{cartBattery != null ? cartBattery.getCharge() : 0.0};
    }

    @Callback(doc="function():string; returns the current mode of the locomotive; can be 'running' or 'shutdown'")
    @Optional.Method(modid="opencomputers")
    public Object[] getMode(Context context, Arguments args) {
        String error = this.cannotAccessLocomotive(1.0, true);
        if (error != null) {
            return new Object[]{null, error};
        }
        return new Object[]{this.getLocomotive().getMode().toString().toLowerCase(Locale.ENGLISH)};
    }

    @Callback(doc="function():string; returns the current name of the locomotive")
    @Optional.Method(modid="opencomputers")
    public Object[] getName(Context context, Arguments args) {
        String error = this.cannotAccessLocomotive(1.0, true);
        if (error != null) {
            return new Object[]{null, error};
        }
        return new Object[]{this.getLocomotive().func_70005_c_()};
    }

    @Optional.Method(modid="computercraft")
    public String[] getMethodNames() {
        return new String[]{"getDestination", "setDestination", "getCharge", "getMode", "getName"};
    }

    @Optional.Method(modid="computercraft")
    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (method < this.getMethodNames().length) {
            String error = this.cannotAccessLocomotive(method == 1 ? 3.0 : 1.0, false);
            if (error != null) {
                return new Object[]{null, error};
            }
            switch (method) {
                case 0: {
                    return new Object[]{this.getLocomotive().getDestination()};
                }
                case 1: {
                    if (arguments.length < 1 || !(arguments[0] instanceof String)) {
                        throw new LuaException("first argument needs to be a string");
                    }
                    return TileLocomotiveRelay.setDestination(this.getLocomotive(), arguments);
                }
                case 2: {
                    IBatteryCart cartBattery = LocomotiveManager.getCartBattery((ICapabilityProvider)this.getLocomotive());
                    return new Object[]{cartBattery != null ? cartBattery.getCharge() : 0.0};
                }
                case 3: {
                    return new Object[]{this.getLocomotive().getMode().toString()};
                }
                case 4: {
                    return new Object[]{this.getLocomotive().func_70005_c_()};
                }
            }
        }
        return null;
    }
}

