/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.util;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import pl.asie.lib.util.internal.IColorable;

public class ColorUtils {
    public static final HashMap<String, Color> dyes = new HashMap();
    public static final HashMap<Integer, Color> colorValues = new HashMap();

    @Nullable
    public static Color getColor(ItemStack stack) {
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
        for (Color color : Color.VALUES) {
            int colorID = OreDictionary.getOreID((String)color.dyeName);
            for (int oreID : oreIDs) {
                if (colorID != oreID) continue;
                return color;
            }
        }
        return null;
    }

    public static Color fromName(String name) {
        if (dyes.containsKey(name)) {
            return dyes.get(name);
        }
        return Color.White;
    }

    public static Color fromDyeMeta(int meta) {
        if (meta >= 0 && meta < Color.VALUES.length) {
            return Color.VALUES[meta];
        }
        return Color.White;
    }

    public static Color fromWoolMeta(int meta) {
        if (meta >= 0 && meta < Color.VALUES.length) {
            return ColorUtils.fromDyeMeta(15 - meta);
        }
        return Color.White;
    }

    public static Color fromColor(int color) {
        if (colorValues.containsKey(color)) {
            return colorValues.get(color);
        }
        return Color.White;
    }

    public static Color fromColor(EnumDyeColor color) {
        return ColorUtils.fromDyeMeta(color.func_176767_b());
    }

    public static boolean isSameOrDefault(IColorable one, IColorable two) {
        int oc = one.getColor();
        int tc = two.getColor();
        int ocd = one.getDefaultColor();
        int tcd = two.getDefaultColor();
        return oc == ocd || tc == tcd || oc == tc;
    }

    public static enum Color {
        Black(0x444444, "dyeBlack"),
        Red(11743532, "dyeRed"),
        Green(0x339911, "dyeGreen"),
        Brown(5320730, "dyeBrown"),
        Blue(0x6666FF, "dyeBlue"),
        Purple(8073150, "dyePurple"),
        Cyan(0x66FFFF, "dyeCyan"),
        LightGray(0xABABAB, "dyeLightGray"),
        Gray(0x666666, "dyeGray"),
        Pink(14188952, "dyePink"),
        Lime(0x66FF66, "dyeLime"),
        Yellow(0xFFFF66, "dyeYellow"),
        LightBlue(0xAAAAFF, "dyeLightBlue"),
        Magenta(12801229, "dyeMagenta"),
        Orange(15435844, "dyeOrange"),
        White(0xFFFFFF, "dyeWhite");

        public static final Color[] VALUES;
        public final int color;
        public final String dyeName;

        private Color(int color, String dyeName) {
            this.color = color;
            this.dyeName = dyeName;
            dyes.put(dyeName, this);
            colorValues.put(color, this);
        }

        static {
            VALUES = Color.values();
        }
    }
}

