/*
 * Decompiled with CFR 0.152.
 */
package com.molybdenum.alloyed.data.util;

import com.molybdenum.alloyed.Alloyed;
import com.simibubi.create.foundation.utility.Iterate;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;

public class BlockStateUtils {
    public static <T extends Block> void existingModel(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov) {
        prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)prov.models().getExistingFile(prov.modLoc("block/" + ctx.getName())));
    }

    public static class Unique {
        public static <T extends Block> void steelCatwalkBlockstate(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov) {
            String texture = "alloyed:block/steel_catwalk";
            String lowerParent = "alloyed:block/catwalk_bottom";
            String upperParent = "alloyed:block/catwalk_top";
            String railUpperParent = "alloyed:block/catwalk_rail_upper";
            String railLowerParent = "alloyed:block/catwalk_rail_lower";
            String path = "block/steel_catwalk/";
            BlockModelBuilder lower = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(path + ctx.getName() + "_bottom", lowerParent)).texture("2", texture)).texture("particle", texture);
            BlockModelBuilder upper = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(path + ctx.getName() + "_top", upperParent)).texture("2", texture)).texture("particle", texture);
            BlockModelBuilder railUpper = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(path + ctx.getName() + "_rail_upper", railUpperParent)).texture("3", texture + "_rail")).texture("particle", texture + "_rail");
            BlockModelBuilder railLower = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(path + ctx.getName() + "_rail_lower", railLowerParent)).texture("3", texture + "_rail")).texture("particle", texture + "_rail");
            ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)lower).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)upper).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{false}).end();
            for (boolean isBottom : Iterate.trueAndFalse) {
                BlockModelBuilder currentModel = isBottom ? railLower : railUpper;
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)currentModel).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{isBottom}).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)currentModel).rotationY(-90).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{isBottom}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)currentModel).rotationY(180).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{isBottom}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)currentModel).rotationY(0).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{isBottom}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true}).end();
            }
        }

        public static <T extends Block> void steelVerticalSlabBlockstate(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov) {
            ResourceLocation texture = prov.modLoc("block/steel_sheet_metal");
            BlockModelBuilder half = (BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName(), prov.modLoc("block/vertical_slab"))).texture("side", texture);
            BlockModelBuilder both = (BlockModelBuilder)prov.models().cubeAll(ctx.getName() + "_double", texture);
            int y = 0;
            for (Direction dir : BlockStateProperties.f_61374_.m_6908_()) {
                switch (dir) {
                    case NORTH: {
                        y = 0;
                        break;
                    }
                    case SOUTH: {
                        y = 180;
                        break;
                    }
                    case WEST: {
                        y = -90;
                        break;
                    }
                    case EAST: {
                        y = 90;
                    }
                }
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)half).rotationY(y).addModel()).condition((Property)BlockStateProperties.f_61397_, (Comparable[])new SlabType[]{SlabType.BOTTOM}).condition((Property)BlockStateProperties.f_61374_, (Comparable[])new Direction[]{dir}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)both).rotationY(y).addModel()).condition((Property)BlockStateProperties.f_61397_, (Comparable[])new SlabType[]{SlabType.DOUBLE}).end();
            }
        }

        public static <T extends Block> void steelBarsBlockstate(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov) {
            ResourceLocation barTexture = Alloyed.asResource("block/steel_bars/block");
            ResourceLocation postTexture = Alloyed.asResource("block/steel_bars/post");
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.get());
            BlockModelBuilder sideModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent("block/steel_bars/steel_bars_side", prov.mcLoc("block/iron_bars_side"))).texture("bars", barTexture)).texture("edge", postTexture)).texture("particle", postTexture);
            BlockModelBuilder sideAltModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent("block/steel_bars/steel_bars_side_alt", prov.mcLoc("block/iron_bars_side_alt"))).texture("bars", barTexture)).texture("edge", postTexture)).texture("particle", postTexture);
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent("block/steel_bars/steel_bars_post", prov.mcLoc("block/iron_bars_post"))).texture("bars", postTexture)).texture("particle", postTexture)).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent("block/steel_bars/steel_bars_post_ends", prov.mcLoc("block/iron_bars_post_ends"))).texture("edge", postTexture)).texture("particle", postTexture)).addModel()).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideModel).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideModel).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideAltModel).addModel()).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideAltModel).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true}).end();
        }

        public static <T extends Block> void steelMeshFenceBlockstate(DataGenContext<Block, T> ctx, RegistrateBlockstateProvider prov) {
            ResourceLocation post = prov.modLoc("block/steel_sheet_metal");
            ResourceLocation mesh = prov.modLoc("block/steel_chain_link");
            char[][] states = new char[][]{{'f', 'f', 'f', 'f'}, {'t', 'x', 't', 'x'}, {'t', 'x', 'x', 't'}, {'x', 't', 't', 'x'}, {'x', 't', 'x', 't'}, {'t', 'f', 'f', 'f'}, {'f', 't', 'f', 'f'}, {'f', 'f', 't', 'f'}, {'f', 'f', 'f', 't'}};
            BlockModelBuilder center = (BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_post", prov.mcLoc("block/fence_post"))).texture("texture", post);
            BlockModelBuilder side = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_side", prov.modLoc("block/chainlink_fence_side"))).texture("particle", mesh)).texture("0", mesh);
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.get());
            for (char[] state : states) {
                MultiPartBlockStateBuilder.PartBuilder part = (MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)center).addModel();
                if (state[0] == 't') {
                    part.condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true});
                } else if (state[0] == 'f') {
                    part.condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false});
                }
                if (state[1] == 't') {
                    part.condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true});
                } else if (state[1] == 'f') {
                    part.condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false});
                }
                if (state[2] == 't') {
                    part.condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true});
                } else if (state[2] == 'f') {
                    part.condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false});
                }
                if (state[3] == 't') {
                    part.condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true});
                } else if (state[3] == 'f') {
                    part.condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false});
                }
                part.end();
            }
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).addModel()).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationY(180).addModel()).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)side).rotationY(270).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true}).end();
        }
    }
}

