/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.manual;

import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualUtils;
import blusunrize.lib.manual.PositionedItemStack;
import blusunrize.lib.manual.SpecialManualElements;
import blusunrize.lib.manual.gui.GuiButtonManualNavigation;
import blusunrize.lib.manual.gui.ManualScreen;
import blusunrize.lib.manual.utils.ManualRecipeRef;
import com.google.common.base.Preconditions;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.world.item.ItemStack;

public abstract class ManualElementIECrafting
extends SpecialManualElements {
    protected final ManualRecipeRef[] stacks;
    protected final List<PositionedItemStack[]> recipes = new ArrayList<PositionedItemStack[]>();
    protected final List<ArrowPosition> arrowPositions = new ArrayList<ArrowPosition>();
    protected int recipePage;
    protected int yOff;

    public ManualElementIECrafting(ManualInstance manual, ManualRecipeRef ... stacks) {
        super(manual);
        for (ManualRecipeRef ref : stacks) {
            Preconditions.checkArgument((!ref.isLayout() ? 1 : 0) != 0);
        }
        this.stacks = stacks;
    }

    @Override
    public abstract void recalculateCraftingRecipes();

    @Override
    public void onOpened(ManualScreen gui, int x, int y, List<Button> pageButtons) {
        if (this.recipes.size() > 1) {
            pageButtons.add(new GuiButtonManualNavigation(gui, x - 2, y + this.yOff / 2 - 3, 8, 10, 0, btn -> {
                --this.recipePage;
                if (this.recipePage < 0) {
                    this.recipePage = this.recipes.size() - 1;
                }
            }));
            pageButtons.add(new GuiButtonManualNavigation(gui, x + 122 - 16, y + this.yOff / 2 - 3, 8, 10, 1, btn -> {
                ++this.recipePage;
                if (this.recipePage >= this.recipes.size()) {
                    this.recipePage = 0;
                }
            }));
        }
        super.onOpened(gui, x, y + this.yOff + 2, pageButtons);
    }

    @Override
    public void render(PoseStack transform, ManualScreen gui, int x, int y, int mouseX, int mouseY) {
        this.highlighted = ItemStack.f_41583_;
        if (!this.recipes.isEmpty() && this.recipePage >= 0 && this.recipePage < this.recipes.size()) {
            PositionedItemStack[] pStacks = this.recipes.get(this.recipePage);
            int maxX = 0;
            for (PositionedItemStack pStack : pStacks) {
                if (pStack == null) continue;
                if (pStack.x() > maxX) {
                    maxX = pStack.x();
                }
                GuiComponent.m_93172_((PoseStack)transform, (int)(x + pStack.x()), (int)(y + pStack.y()), (int)(x + pStack.x() + 16), (int)(y + pStack.y() + 16), (int)0x33666666);
                if (pStack.getStackAtCurrentTime().m_41619_()) continue;
                ManualUtils.renderItemStack(transform, pStack.getStackAtCurrentTime(), x + pStack.x(), y + pStack.y(), true, pStack.amount());
                if (mouseX < x + pStack.x() || mouseX >= x + pStack.x() + 16 || mouseY < y + pStack.y() || mouseY >= y + pStack.y() + 16) continue;
                this.highlighted = pStack.getStackAtCurrentTime();
            }
            ArrowPosition arrow = this.arrowPositions.get(this.recipePage);
            ManualUtils.drawTexturedRect(transform, this.manual.texture, x + arrow.x(), y + arrow.y(), 16, 10, 0.0f, 0.0625f, 0.8828125f, 0.921875f);
        }
        this.renderHighlightedTooltip(transform, gui, mouseX, mouseY);
    }

    @Override
    public boolean listForSearch(String searchTag) {
        for (PositionedItemStack[] recipe : this.recipes) {
            for (PositionedItemStack pStack : recipe) {
                for (ItemStack stack : pStack.displayList()) {
                    if (!ManualUtils.listStack(searchTag, stack)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int getPixelsTaken() {
        int maxY = 0;
        for (PositionedItemStack[] recipe : this.recipes) {
            for (PositionedItemStack pstack : recipe) {
                maxY = Math.max(maxY, pstack.y());
            }
        }
        return maxY + 18;
    }

    record ArrowPosition(int x, int y) {
    }
}

