/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.register.IEPotions;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.items.IItemHandler;

public class IEShieldItem
extends UpgradeableToolItem {
    public IEShieldItem() {
        super(new Item.Properties().m_41499_(1024), "SHIELD");
    }

    public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(ItemCallback.USE_IEOBJ_RENDER);
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag nbt) {
        if (!stack.m_41619_()) {
            return new IEItemStackHandler(stack){
                final LazyOptional<EnergyHelper.ItemEnergyStorage> energyStorage;
                final LazyOptional<CapabilityShader.ShaderWrapper_Item> shaders;
                {
                    super(stack2);
                    this.energyStorage = CapabilityUtils.constantOptional(new EnergyHelper.ItemEnergyStorage(stack, IEShieldItem::getMaxEnergyStored));
                    this.shaders = CapabilityUtils.constantOptional(new CapabilityShader.ShaderWrapper_Item(new ResourceLocation("immersiveengineering", "shield"), stack));
                }

                @Override
                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    if (capability == ForgeCapabilities.ENERGY) {
                        return this.energyStorage.cast();
                    }
                    if (capability == CapabilityShader.SHADER_CAPABILITY) {
                        return this.shaders.cast();
                    }
                    return super.getCapability(capability, facing);
                }
            };
        }
        return null;
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return true;
        }
        LazyOptional wrapperOld = oldStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
        Optional sameShader = wrapperOld.map(wOld -> {
            LazyOptional wrapperNew = newStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
            return wrapperNew.map(w -> ItemStack.m_41728_((ItemStack)wOld.getShaderItem(), (ItemStack)w.getShaderItem())).orElse(true);
        });
        if (!sameShader.orElse(true).booleanValue()) {
            return true;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        if (IEShieldItem.getMaxEnergyStored(stack) > 0) {
            IEnergyStorage energyStorage = (IEnergyStorage)CapabilityUtils.getPresentCapability((ICapabilityProvider)stack, ForgeCapabilities.ENERGY);
            String stored = energyStorage.getEnergyStored() + "/" + IEShieldItem.getMaxEnergyStored(stack);
            list.add((Component)Component.m_237110_((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{stored}));
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity ent, int slot, boolean inHand) {
        super.m_6883_(stack, world, ent, slot, inHand);
        if (world.f_46443_) {
            return;
        }
        if (ent instanceof LivingEntity) {
            inHand |= ((LivingEntity)ent).m_21120_(InteractionHand.OFF_HAND) == stack;
        }
        boolean blocking = ent instanceof LivingEntity && ((LivingEntity)ent).m_21254_();
        IEnergyStorage energy = (IEnergyStorage)CapabilityUtils.getPresentCapability((ICapabilityProvider)stack, ForgeCapabilities.ENERGY);
        if (!inHand || !blocking) {
            int cooldown;
            if (this.getUpgrades(stack).m_128425_("flash_cooldown", 3) && energy.extractEnergy(10, true) == 10) {
                energy.extractEnergy(20, false);
                cooldown = this.getUpgrades(stack).m_128451_("flash_cooldown");
                if (--cooldown <= 0) {
                    this.getUpgrades(stack).m_128473_("flash_cooldown");
                } else {
                    this.getUpgrades(stack).m_128405_("flash_cooldown", cooldown);
                }
            }
            if (this.getUpgrades(stack).m_128425_("shock_cooldown", 3) && energy.extractEnergy(10, true) == 10) {
                energy.extractEnergy(20, false);
                cooldown = this.getUpgrades(stack).m_128451_("shock_cooldown");
                if (--cooldown <= 0) {
                    this.getUpgrades(stack).m_128473_("shock_cooldown");
                } else {
                    this.getUpgrades(stack).m_128405_("shock_cooldown", cooldown);
                }
            }
        }
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SHIELD_ACTIONS.contains(toolAction);
    }

    public void hitShield(ItemStack stack, Player player, DamageSource source, float amount, LivingAttackEvent event) {
        if (this.getUpgrades(stack).m_128471_("flash") && this.getUpgrades(stack).m_128451_("flash_cooldown") <= 0) {
            Vec3 look = player.m_20154_();
            List<LivingEntity> targets = Utils.getTargetsInCone(player.m_20193_(), player.m_20182_().m_82546_(look), player.m_20154_().m_82490_(9.0), 1.57079f, 0.5f);
            for (LivingEntity t : targets) {
                if (player.equals((Object)t)) continue;
                t.m_7292_(new MobEffectInstance((MobEffect)IEPotions.FLASHED.get(), 100, 1));
                if (!(t instanceof Mob)) continue;
                ((Mob)t).m_6710_(null);
            }
            this.getUpgrades(stack).m_128405_("flash_cooldown", 40);
        }
        if (this.getUpgrades(stack).m_128471_("shock") && this.getUpgrades(stack).m_128451_("shock_cooldown") <= 0) {
            boolean b = false;
            if (event.getSource().m_19360_() && event.getSource().m_7640_() != null) {
                Entity projectile = event.getSource().m_7640_();
                projectile.m_146870_();
                event.setCanceled(true);
                b = true;
            }
            if (event.getSource().m_7639_() != null && event.getSource().m_7639_() instanceof LivingEntity && event.getSource().m_7639_().m_20280_((Entity)player) < 4.0) {
                IEDamageSources.ElectricDamageSource dmgsrc = IEDamageSources.causeTeslaDamage(1.0f, true);
                dmgsrc.apply(event.getSource().m_7639_());
                b = true;
            }
            if (b) {
                this.getUpgrades(stack).m_128405_("shock_cooldown", 40);
                player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)IESounds.spark.get(), SoundSource.BLOCKS, 2.5f, 0.5f + ApiUtils.RANDOM.nextFloat());
            }
        }
    }

    public boolean m_6832_(ItemStack stack, ItemStack material) {
        return material.m_204117_(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot);
    }

    public static int getMaxEnergyStored(ItemStack container) {
        return IEShieldItem.getUpgradesStatic(container).m_128471_("flash") || IEShieldItem.getUpgradesStatic(container).m_128471_("shock") ? 3200 : 0;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, @Nonnull InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        playerIn.m_6672_(handIn);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    @Nonnull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BLOCK;
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler toolInventory) {
        return new Slot[]{new IESlot.Upgrades(container, toolInventory, 0, 80, 32, "SHIELD", stack, true, level, getPlayer), new IESlot.Upgrades(container, toolInventory, 1, 100, 32, "SHIELD", stack, true, level, getPlayer)};
    }

    @Override
    public int getSlotCount() {
        return 2;
    }

    public boolean m_5812_(ItemStack stack) {
        return false;
    }
}

