/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.api.posts;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;
import twistedgate.immersiveposts.api.posts.IPostMaterial;
import twistedgate.immersiveposts.common.blocks.HorizontalTrussBlock;
import twistedgate.immersiveposts.common.blocks.PostBlock;

public class PostMaterialRegistry {
    static final Map<IPostMaterial, Pair<RegistryObject<? extends Block>, RegistryObject<? extends Block>>> MAP = new HashMap<IPostMaterial, Pair<RegistryObject<? extends Block>, RegistryObject<? extends Block>>>();

    public static void register(DeferredRegister<Block> register, IPostMaterial material) {
        if (MAP.containsKey(material)) {
            throw new IllegalArgumentException("PostMaterial \"" + material.getName() + "\" already exists!");
        }
        RegistryObject post = register.register(material.getBlockName(), () -> new PostBlock(material));
        RegistryObject truss = register.register(material.getBlockName() + "_truss", () -> new HorizontalTrussBlock(material));
        MAP.put(material, (Pair<RegistryObject<? extends Block>, RegistryObject<? extends Block>>)Pair.of((Object)post, (Object)truss));
    }

    public static final RegistryObject<? extends Block> getPostFrom(IPostMaterial material) {
        Pair<RegistryObject<? extends Block>, RegistryObject<? extends Block>> pair = MAP.get(material);
        return pair != null ? (RegistryObject)pair.getLeft() : null;
    }

    public static final RegistryObject<? extends Block> getTrussFrom(IPostMaterial material) {
        Pair<RegistryObject<? extends Block>, RegistryObject<? extends Block>> pair = MAP.get(material);
        return pair != null ? (RegistryObject)pair.getRight() : null;
    }
}

