/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.blockentity;

import com.mojang.logging.LogUtils;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import novamachina.exnihilosequentia.common.block.InfestingLeavesBlock;
import novamachina.exnihilosequentia.common.init.ExNihiloBlockEntities;
import novamachina.exnihilosequentia.common.utility.Config;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;

public class InfestingLeavesEntity
extends BlockEntity {
    @Nonnull
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogUtils.getLogger());
    @Nonnull
    private static final String PROGRESS_TAG = "progress";
    private int progress = 0;
    private int progressWaitInterval = Config.getSecondsToTransformLeaves() * 20 / 100;
    private int spreadCounter = 0;

    public InfestingLeavesEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ExNihiloBlockEntities.INFESTING_LEAVES_ENTITY.get(), pos, state);
    }

    public int getProgress() {
        return this.progress;
    }

    public void tickServer() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        --this.progressWaitInterval;
        if (this.progressWaitInterval <= 0) {
            ++this.progress;
            ++this.spreadCounter;
            if (this.progress >= 100) {
                logger.debug("Finish insfesting leaves");
                InfestingLeavesBlock.finishInfestingBlock(this.f_58857_, this.f_58858_);
            }
            if (this.spreadCounter >= Config.getTicksBetweenSpreadAttempt()) {
                logger.debug("Spreading infested leaves");
                InfestingLeavesBlock.spread(this.f_58857_, this.f_58858_);
                this.spreadCounter = 0;
            }
            this.progressWaitInterval = Config.getSecondsToTransformLeaves() * 20 / 100;
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 2);
        }
    }

    @Nonnull
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(PROGRESS_TAG, this.progress);
        return nbt;
    }

    public void onDataPacket(@Nonnull Connection net, @Nonnull ClientboundBlockEntityDataPacket pkt) {
        CompoundTag nbt = pkt.m_131708_();
        if (nbt.m_128441_(PROGRESS_TAG)) {
            this.progress = nbt.m_128451_(PROGRESS_TAG);
        }
    }
}

