/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.loot.modifier;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.security.SecureRandom;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import novamachina.exnihilosequentia.api.tag.ExNihiloTags;
import novamachina.exnihilosequentia.common.crafting.ItemStackWithChance;
import novamachina.exnihilosequentia.common.registries.ExNihiloRegistries;
import novamachina.exnihilosequentia.common.utility.ExNihiloLogger;

public class UseHammerModifier
extends LootModifier {
    public static final Supplier<Codec<UseHammerModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> UseHammerModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, UseHammerModifier::new)));
    private static final ExNihiloLogger logger = new ExNihiloLogger(LogUtils.getLogger());
    private final Random random = new SecureRandom();

    public UseHammerModifier(@Nonnull LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @Nonnull
    public ObjectArrayList<ItemStack> doApply(@Nonnull ObjectArrayList<ItemStack> generatedLoot, @Nonnull LootContext context) {
        logger.debug("Fired Hammer Modifier");
        ItemStack tool = (ItemStack)context.m_78953_(LootContextParams.f_81463_);
        BlockState blockState = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        ObjectArrayList newLoot = new ObjectArrayList();
        if (tool != null && blockState != null && tool.m_41720_().m_7968_().m_204117_(ExNihiloTags.HAMMER) && ExNihiloRegistries.HAMMER_REGISTRY.isHammerable(blockState.m_60734_())) {
            List<ItemStackWithChance> list = ExNihiloRegistries.HAMMER_REGISTRY.getResult(blockState.m_60734_());
            for (ItemStackWithChance stackWithChance : list) {
                if (!(this.random.nextFloat() <= stackWithChance.getChance()) || stackWithChance.getStack() == ItemStack.f_41583_) continue;
                newLoot.add((Object)stackWithChance.getStack());
            }
        }
        if (!newLoot.isEmpty()) {
            logger.debug("Adding new loot");
            generatedLoot = newLoot;
        }
        logger.debug("Hammer Generated Loot: " + generatedLoot);
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

