/*
 * Decompiled with CFR 0.152.
 */
package dev.kosmx.playerAnim.api.layered.modifier;

import dev.kosmx.playerAnim.api.TransformType;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.core.util.Vec3f;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MirrorModifier
extends AbstractModifier {
    public static final Map<String, String> mirrorMap;
    private boolean enabled = true;

    @Override
    public Vec3f get3DTransform(String modelName, TransformType type, float tickDelta, Vec3f value0) {
        if (!this.enabled) {
            return super.get3DTransform(modelName, type, tickDelta, value0);
        }
        if (mirrorMap.containsKey(modelName)) {
            modelName = mirrorMap.get(modelName);
        }
        value0 = this.transformVector(value0, type);
        Vec3f vec3f = super.get3DTransform(modelName, type, tickDelta, value0);
        return this.transformVector(vec3f, type);
    }

    protected Vec3f transformVector(Vec3f value0, TransformType type) {
        switch (type) {
            case POSITION: {
                return new Vec3f(-((Float)value0.getX()).floatValue(), ((Float)value0.getY()).floatValue(), ((Float)value0.getZ()).floatValue());
            }
            case ROTATION: {
                return new Vec3f(((Float)value0.getX()).floatValue(), -((Float)value0.getY()).floatValue(), -((Float)value0.getZ()).floatValue());
            }
            case BEND: {
                return new Vec3f(((Float)value0.getX()).floatValue(), -((Float)value0.getY()).floatValue(), ((Float)value0.getZ()).floatValue());
            }
        }
        return value0;
    }

    public MirrorModifier() {
    }

    public MirrorModifier(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    static {
        HashMap<String, String> partMap = new HashMap<String, String>();
        partMap.put("leftArm", "rightArm");
        partMap.put("leftLeg", "rightLeg");
        partMap.put("leftItem", "rightItem");
        partMap.put("rightArm", "leftArm");
        partMap.put("rightLeg", "leftLeg");
        partMap.put("rightItem", "leftItem");
        mirrorMap = Collections.unmodifiableMap(partMap);
    }
}

