/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.robit;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.providers.IRobitSkinProvider;
import mekanism.api.text.TextComponentUtil;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class RobitSkin
implements IRobitSkinProvider {
    private final List<ResourceLocation> textures;
    @Nullable
    private String translationKey;

    public RobitSkin(ResourceLocation ... textures) {
        Objects.requireNonNull(textures, "Textures cannot be null.");
        this.textures = textures.length == 0 ? Collections.emptyList() : List.of(textures);
    }

    @Nullable
    public ResourceLocation getCustomModel() {
        return null;
    }

    public List<ResourceLocation> getTextures() {
        return this.textures;
    }

    public boolean isUnlocked(@NotNull Player player) {
        return true;
    }

    @Override
    public final RobitSkin getSkin() {
        return this;
    }

    @Override
    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.m_137492_((String)"robit_skin", (ResourceLocation)this.getRegistryName());
        }
        return this.translationKey;
    }

    @Override
    public Component getTextComponent() {
        return TextComponentUtil.translate(this.getTranslationKey(), new Object[0]);
    }

    @Override
    public final ResourceLocation getRegistryName() {
        IForgeRegistry<RobitSkin> registry = MekanismAPI.robitSkinRegistry();
        return registry == null ? null : registry.getKey((Object)this);
    }
}

