/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window.filter;

import java.util.Collections;
import java.util.List;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.window.filter.GuiFilter;
import mekanism.client.jei.interfaces.IJEIGhostTarget;
import mekanism.common.MekanismLang;
import mekanism.common.base.TagCache;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.StackUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GuiMaterialFilter<FILTER extends IMaterialFilter<FILTER>, TILE extends TileEntityMekanism>
extends GuiFilter<FILTER, TILE> {
    protected GuiMaterialFilter(IGuiWrapper gui, int x, int y, int width, int height, TILE tile, @Nullable FILTER origFilter) {
        super(gui, x, y, width, height, (Component)MekanismLang.MATERIAL_FILTER.translate(new Object[0]), tile, origFilter);
        if (((IMaterialFilter)this.filter).hasFilter()) {
            this.slotDisplay.updateStackList();
        }
    }

    @Override
    protected List<Component> getScreenText() {
        List<Component> list = super.getScreenText();
        if (((IMaterialFilter)this.filter).hasFilter()) {
            list.add((Component)MekanismLang.MATERIAL_FILTER_DETAILS.translate(new Object[0]));
            list.add(((IMaterialFilter)this.filter).getMaterialItem().m_41786_());
        }
        return list;
    }

    @Override
    protected ILangEntry getNoFilterSaveError() {
        return MekanismLang.ITEM_FILTER_NO_ITEM;
    }

    @Override
    @NotNull
    protected List<ItemStack> getRenderStacks() {
        if (((IMaterialFilter)this.filter).hasFilter()) {
            return TagCache.getMaterialStacks(((IMaterialFilter)this.filter).getMaterialItem());
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    protected IJEIGhostTarget.IGhostBlockItemConsumer getGhostHandler() {
        return ingredient -> this.setFilterStackWithSound(StackUtils.size((ItemStack)ingredient, 1));
    }

    @Override
    @Nullable
    protected GuiElement.IClickable getSlotClickHandler() {
        return GuiMaterialFilter.getHandleClickSlot(this.gui(), NOT_EMPTY_BLOCK, this::setFilterStack);
    }

    private void setFilterStack(@NotNull ItemStack stack) {
        ((IMaterialFilter)this.filter).setMaterialItem(stack);
        this.slotDisplay.updateStackList();
    }

    protected void setFilterStackWithSound(@NotNull ItemStack stack) {
        this.setFilterStack(stack);
        GuiMaterialFilter.playClickSound(SoundEvents.f_12490_);
    }
}

