/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.config.value;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.value.CachedResolvableConfigValue;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;

public class CachedOredictionificatorConfigValue
extends CachedResolvableConfigValue<Map<String, List<String>>, List<? extends String>> {
    private CachedOredictionificatorConfigValue(IMekanismConfig config, ForgeConfigSpec.ConfigValue<List<? extends String>> internal) {
        super(config, internal);
    }

    public static CachedOredictionificatorConfigValue define(IMekanismConfig config, ForgeConfigSpec.Builder builder, String path, Supplier<Map<String, List<String>>> defaults) {
        return new CachedOredictionificatorConfigValue(config, (ForgeConfigSpec.ConfigValue<List<? extends String>>)builder.defineListAllowEmpty(Collections.singletonList(path), () -> CachedOredictionificatorConfigValue.encodeStatic((Map)defaults.get()), o -> {
            String string;
            return o instanceof String && ResourceLocation.m_135830_((String)(string = (String)o).toLowerCase(Locale.ROOT));
        }));
    }

    @Override
    protected Map<String, List<String>> resolve(List<? extends String> encoded) {
        HashMap<String, List<String>> resolved = new HashMap<String, List<String>>(encoded.size());
        for (String string : encoded) {
            ResourceLocation rl = ResourceLocation.m_135820_((String)string.toLowerCase(Locale.ROOT));
            if (rl == null) continue;
            resolved.computeIfAbsent(rl.m_135827_(), r -> new ArrayList()).add(rl.m_135815_());
        }
        return resolved;
    }

    @Override
    protected List<? extends String> encode(Map<String, List<String>> values) {
        return CachedOredictionificatorConfigValue.encodeStatic(values);
    }

    private static List<? extends String> encodeStatic(Map<String, List<String>> values) {
        ArrayList<String> encoded = new ArrayList<String>(values.size());
        for (Map.Entry<String, List<String>> entry : values.entrySet()) {
            String namespace = entry.getKey().toLowerCase(Locale.ROOT);
            for (String path : entry.getValue()) {
                try {
                    ResourceLocation rl = new ResourceLocation(namespace + ":" + path.toLowerCase(Locale.ROOT));
                    encoded.add(rl.toString());
                }
                catch (ResourceLocationException resourceLocationException) {}
            }
        }
        Collections.sort(encoded);
        return encoded;
    }
}

