/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.layers.titlescreen.splash;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.DeepCustomizationElement;
import de.keksuccino.fancymenu.menu.fancy.menuhandler.deepcustomizationlayer.DeepCustomizationItem;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.rendering.RenderUtils;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class TitleScreenSplashItem
extends DeepCustomizationItem {
    public static String cachedSplashText;
    public String splashTextFilePath;
    public int splashRotation = -20;
    public Color splashColor = new Color(255, 255, 0);
    public String splashColorHEX = "#ffff00";
    protected int lastSplashPosX = 0;
    protected int lastSplashPosY = 0;

    public TitleScreenSplashItem(DeepCustomizationElement parentElement, PropertiesSection item) {
        super(parentElement, item);
        Color c;
        String splashCol;
        this.splashTextFilePath = item.getEntryValue("splash_file_path");
        String splashRot = item.getEntryValue("splash_rotation");
        if (splashRot != null && MathUtils.isInteger((String)splashRot)) {
            this.splashRotation = Integer.parseInt(splashRot);
        }
        if ((splashCol = item.getEntryValue("splash_color")) != null && (c = RenderUtils.getColorFromHexString((String)splashCol)) != null) {
            this.splashColor = c;
            this.splashColorHEX = splashCol;
        }
    }

    @Override
    public int getPosX(Screen menu) {
        return this.lastSplashPosX - this.getWidth() / 2;
    }

    @Override
    public int getPosY(Screen menu) {
        return this.lastSplashPosY - this.getHeight() / 2;
    }

    @Override
    public void render(PoseStack matrix, Screen menu) throws IOException {
        this.width = 60;
        this.height = 30;
        if (!this.hidden) {
            RenderSystem.m_69478_();
            this.renderSplash(matrix, Minecraft.m_91087_().f_91062_, menu);
        }
    }

    protected void renderSplash(PoseStack matrix, Font font, Screen s) {
        float finalPosX = s.f_96543_ / 2 + 90;
        float finalPosY = 70.0f;
        int originX = 0;
        int originY = 0;
        if (this.orientation.equalsIgnoreCase("original")) {
            originX = (int)finalPosX;
            originY = (int)finalPosY;
        } else if (!this.orientation.equalsIgnoreCase("top-left")) {
            if (this.orientation.equalsIgnoreCase("mid-left")) {
                originY = s.f_96544_ / 2;
            } else if (this.orientation.equalsIgnoreCase("bottom-left")) {
                originY = s.f_96544_;
            } else if (this.orientation.equalsIgnoreCase("top-centered")) {
                originX = s.f_96543_ / 2;
            } else if (this.orientation.equalsIgnoreCase("mid-centered")) {
                originX = s.f_96543_ / 2;
                originY = s.f_96544_ / 2;
            } else if (this.orientation.equalsIgnoreCase("bottom-centered")) {
                originX = s.f_96543_ / 2;
                originY = s.f_96544_;
            } else if (this.orientation.equalsIgnoreCase("top-right")) {
                originX = s.f_96543_;
            } else if (this.orientation.equalsIgnoreCase("mid-right")) {
                originX = s.f_96543_;
                originY = s.f_96544_ / 2;
            } else if (this.orientation.equalsIgnoreCase("bottom-right")) {
                originX = s.f_96543_;
                originY = s.f_96544_;
            }
        }
        finalPosX = originX + this.posX;
        finalPosY = originY + this.posY;
        this.lastSplashPosX = (int)finalPosX;
        this.lastSplashPosY = (int)finalPosY;
        if (cachedSplashText == null) {
            cachedSplashText = this.getRandomSplashText();
        }
        if (cachedSplashText == null) {
            cachedSplashText = "\u00a7c< ERROR! UNABLE TO GET SPLASH TEXT! >";
        }
        matrix.m_85836_();
        matrix.m_85837_((double)finalPosX, (double)finalPosY, 0.0);
        matrix.m_85845_(Vector3f.f_122227_.m_122240_((float)this.splashRotation));
        float f = 1.8f - Mth.m_14154_((float)(Mth.m_14031_((float)((float)(System.currentTimeMillis() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
        f = f * 100.0f / (float)(font.m_92895_(cachedSplashText) + 32);
        matrix.m_85841_(f, f, f);
        TitleScreenSplashItem.m_93215_((PoseStack)matrix, (Font)font, (Component)Component.m_237113_((String)cachedSplashText), (int)0, (int)-8, (int)this.splashColor.getRGB());
        matrix.m_85849_();
    }

    public String getRandomSplashText() {
        List l;
        File f;
        if (this.splashTextFilePath != null && !this.splashTextFilePath.replace(" ", "").equals("") && (f = new File(this.splashTextFilePath)).exists() && f.isFile() && f.getPath().toLowerCase().endsWith(".txt") && (l = FileUtils.getFileLines((File)f)) != null && !l.isEmpty()) {
            int random = MathUtils.getRandomNumberInRange((int)0, (int)(l.size() - 1));
            return (String)l.get(random);
        }
        return Minecraft.m_91087_().m_91310_().m_118867_();
    }
}

