/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.audio.tts;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.sound.sampled.AudioInputStream;
import marytts.LocalMaryInterface;
import marytts.MaryInterface;
import marytts.exceptions.MaryConfigurationException;
import marytts.exceptions.SynthesisException;
import marytts.server.Mary;
import marytts.util.data.audio.AudioPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pl.asie.computronics.audio.tts.SynthesizeTask;

public class TextToSpeech {
    public MaryInterface marytts;
    private ExecutorService ttsThreads;
    public final ArrayList<Future<Result>> processes = new ArrayList();
    public static final Logger log = LogManager.getLogger((String)"computronics-text-to-speech");

    public TextToSpeech() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void say(ICanSpeak device, String text) {
        Future<Result> fut = this.ttsThreads.submit(new SynthesizeTask(device, text));
        this.processes.add(fut);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            for (int i = 0; i < this.processes.size(); ++i) {
                Future<Result> process = this.processes.get(i);
                if (!process.isDone()) continue;
                try {
                    ICanSpeak device;
                    Result result = process.get();
                    if (result != null && (device = (ICanSpeak)result.device.get()) != null && device.isValid()) {
                        device.startTalking(result.data);
                    }
                }
                catch (Throwable t) {
                    log.error("Error while playing text to speech", t);
                }
                toRemove.add(i);
            }
            Iterator iterator = toRemove.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                this.processes.remove(i);
            }
        }
    }

    public boolean preInit() {
        try {
            this.marytts = new LocalMaryInterface();
            this.marytts.setStreamingAudio(true);
            String voice = this.marytts.getVoice();
            if (voice == null) {
                Set availableLocales = this.marytts.getAvailableLocales();
                for (Locale locale : availableLocales) {
                    this.marytts.setLocale(locale);
                    voice = this.marytts.getVoice();
                    if (voice == null) continue;
                    break;
                }
                if (voice == null) {
                    log.error("No voice found for available locales, please install a matching voice file. Available locales: " + StringUtils.join((Iterable)availableLocales, (String)", "));
                    if (Mary.currentState() == 2) {
                        Mary.shutdown();
                    }
                    this.marytts = null;
                    return false;
                }
            }
            this.marytts.setOutputType("AUDIO");
            this.ttsThreads = Executors.newFixedThreadPool(2, new ThreadFactoryBuilder().setPriority(1).build());
            log.info("Text To Speech successfully initialized with language " + this.marytts.getLocale() + " and voice " + voice + ".");
            return true;
        }
        catch (Exception e) {
            log.error("Text To Speech initialization failed, you will not be able to hear anything", (Throwable)e);
            if (Mary.currentState() == 2) {
                Mary.shutdown();
            }
            this.marytts = null;
            return false;
        }
    }

    public static void main(String[] args) {
        try {
            LocalMaryInterface marytts = new LocalMaryInterface();
            Set voices = marytts.getAvailableVoices();
            marytts.setVoice((String)voices.iterator().next());
            marytts.setLocale(Locale.US);
            AudioInputStream audio = marytts.generateAudio("I am a pastry fork.");
            AudioPlayer player = new AudioPlayer(audio);
            ExecutorService service = Executors.newCachedThreadPool();
            service.submit((Runnable)player).get();
        }
        catch (MaryConfigurationException e) {
            e.printStackTrace();
            e.getCause().printStackTrace();
            e.getCause().getCause().printStackTrace();
        }
        catch (SynthesisException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public static class Result {
        private final WeakReference<ICanSpeak> device;
        private final byte[] data;

        public Result(WeakReference<ICanSpeak> device, byte[] data) {
            this.device = device;
            this.data = data;
        }
    }

    public static interface ICanSpeak {
        public void startTalking(byte[] var1);

        public boolean isValid();
    }
}

