/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.integration;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import pl.asie.computronics.integration.CCMultiPeripheral;

public abstract class CCFilteredMultiPeripheral<T>
extends CCMultiPeripheral<T> {
    protected final List<String> methods;
    protected List<String> availableMethods;

    public CCFilteredMultiPeripheral() {
        this.methods = Collections.emptyList();
    }

    public CCFilteredMultiPeripheral(T tile, String name, World world, BlockPos pos) {
        super(tile, name, world, pos);
        this.methods = this.getAllMethods();
    }

    protected abstract List<String> getAllMethods();

    protected abstract boolean isMethodEnabled(String var1);

    protected boolean isMethodEnabled(int method) {
        return this.isMethodEnabled(this.methods.get(method));
    }

    public String[] getMethodNames() {
        this.availableMethods = new ArrayList<String>();
        for (String method : this.methods) {
            if (!this.isMethodEnabled(method)) continue;
            this.availableMethods.add(method);
        }
        return this.availableMethods.toArray(new String[this.availableMethods.size()]);
    }

    protected abstract Object[] call(IComputerAccess var1, ILuaContext var2, int var3, Object[] var4) throws LuaException, InterruptedException;

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws LuaException, InterruptedException {
        if (method < 0 || method >= this.availableMethods.size() || this.availableMethods.get(method) == null) {
            throw new LuaException("not a valid function");
        }
        int index = this.methods.indexOf(this.availableMethods.get(method));
        if (index < 0 || index >= this.methods.size()) {
            throw new LuaException("not a valid function");
        }
        return this.call(computer, context, index, arguments);
    }
}

