/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.lib.block;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pl.asie.lib.gui.managed.IGuiProvider;
import pl.asie.lib.integration.Integration;
import pl.asie.lib.reference.Mods;
import pl.asie.lib.tile.TileEntityBase;
import pl.asie.lib.util.ItemUtils;

public abstract class BlockBase
extends Block {
    public static final PropertyBool BUNDLED = PropertyBool.func_177716_a((String)"bundled");
    public final Rotation rotation;
    private final Object parent;
    private int gui = -1;
    protected IGuiProvider guiProvider;
    protected final BlockStateContainer field_176227_L;

    public BlockBase(Material material, Object parent, Rotation rotation) {
        super(material);
        this.func_149647_a(CreativeTabs.field_78026_f);
        this.rotation = rotation;
        this.func_149711_c(2.0f);
        this.parent = parent;
        this.field_176227_L = this.createActualBlockState();
        this.func_180632_j(this.createDefaultState());
    }

    protected IBlockState createDefaultState() {
        IBlockState state = this.field_176227_L.func_177621_b();
        if (this.rotation != Rotation.NONE) {
            state = state.func_177226_a((IProperty)this.rotation.FACING, (Comparable)EnumFacing.NORTH);
        }
        return state;
    }

    public boolean supportsBundledRedstone() {
        return false;
    }

    public BlockStateContainer func_176194_O() {
        return this.field_176227_L;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[0]);
    }

    protected BlockStateContainer createActualBlockState() {
        ArrayList<Object> properties = new ArrayList<Object>();
        if (this.rotation != Rotation.NONE) {
            properties.add(this.rotation.FACING);
        }
        if (this.supportsBundledRedstone()) {
            properties.add(BUNDLED);
        }
        return new BlockStateContainer((Block)this, properties.toArray(new IProperty[properties.size()]));
    }

    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState actualState = super.func_176221_a(state, world, pos);
        if (this.supportsBundledRedstone()) {
            actualState = actualState.func_177226_a((IProperty)BUNDLED, (Comparable)Boolean.valueOf(Mods.hasBundledRedstoneMod()));
        }
        return actualState;
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        switch (this.rotation) {
            case FOUR: {
                return state.func_177226_a((IProperty)this.rotation.FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
            }
            case SIX: {
                return state.func_177226_a((IProperty)this.rotation.FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
            }
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        switch (this.rotation) {
            case FOUR: {
                return ((EnumFacing)state.func_177229_b((IProperty)this.rotation.FACING)).func_176736_b();
            }
            case SIX: {
                return ((EnumFacing)state.func_177229_b((IProperty)this.rotation.FACING)).func_176745_a();
            }
        }
        return 0;
    }

    public boolean emitsRedstone(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean receivesRedstone(IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Deprecated
    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int getVanillaRedstoneValue(World world, BlockPos pos) {
        return world.func_175651_c(pos, this.getFacingDirection(world, pos));
    }

    @Deprecated
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos otherPos) {
        TileEntity tile;
        if (this.receivesRedstone((IBlockAccess)world, pos) && (tile = world.func_175625_s(pos)) != null && tile instanceof TileEntityBase) {
            int oldSignal;
            int newSignal = this.getVanillaRedstoneValue(world, pos);
            if (newSignal == (oldSignal = ((TileEntityBase)tile).getOldRedstoneSignal())) {
                return;
            }
            ((TileEntityBase)tile).setRedstoneSignal(newSignal);
        }
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.emitsRedstone(world, pos, side) || this.receivesRedstone(world, pos);
    }

    @Deprecated
    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (!this.emitsRedstone(world, pos, side)) {
            return 0;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityBase) {
            return ((TileEntityBase)te).requestCurrentRedstoneValue(side);
        }
        return 0;
    }

    public abstract boolean hasTileEntity(IBlockState var1);

    public abstract TileEntity createTileEntity(World var1, IBlockState var2);

    public EnumFacing getFacingDirection(World world, BlockPos pos) {
        return (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)this.rotation.FACING);
    }

    public EnumFacing getFacingDirection(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)this.rotation.FACING);
    }

    @Nullable
    private EnumFacing determineRotation(World world, BlockPos pos, EntityLivingBase entity) {
        if (this.rotation == Rotation.NONE) {
            return null;
        }
        if (this.rotation == Rotation.SIX && MathHelper.func_76135_e((float)((float)entity.field_70165_t - (float)pos.func_177958_n())) < 2.0f && MathHelper.func_76135_e((float)((float)entity.field_70161_v - (float)pos.func_177952_p())) < 2.0f) {
            double d0 = entity.field_70163_u + (double)entity.func_70047_e();
            if (d0 - (double)pos.func_177956_o() > 2.0) {
                return EnumFacing.UP;
            }
            if ((double)pos.func_177956_o() - d0 > 0.0) {
                return EnumFacing.DOWN;
            }
        }
        return entity.func_174811_aO().func_176734_d();
    }

    @Deprecated
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        if (this.rotation != Rotation.NONE) {
            EnumFacing rot = this.determineRotation(world, pos, placer);
            return this.func_176223_P().func_177226_a((IProperty)this.rotation.FACING, (Comparable)rot);
        }
        return super.getStateForPlacement(world, pos, side, hitX, hitY, hitZ, meta, placer, hand);
    }

    public Object getOwner() {
        return this.parent;
    }

    public boolean hasGui(World world, BlockPos pos, EntityPlayer player, EnumFacing side) {
        if (this.guiProvider != null) {
            this.gui = this.guiProvider.getGuiID();
        }
        return this.guiProvider != null && this.gui >= 0;
    }

    @Nullable
    public IGuiProvider getGuiProvider(World world, BlockPos pos, EntityPlayer player, EnumFacing side) {
        return this.guiProvider;
    }

    public void setGuiProvider(IGuiProvider provider) {
        this.guiProvider = provider;
        this.gui = this.guiProvider.getGuiID();
    }

    protected boolean rotate(World world, BlockPos pos, EntityPlayer player, EnumFacing side) {
        return !player.func_70093_af() && this.rotateBlock(world, pos, side);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing side) {
        if (this.rotation == Rotation.NONE) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        EnumFacing f = (EnumFacing)state.func_177229_b((IProperty)this.rotation.FACING);
        if (side == f && this.isValidFacing(world, pos, f.func_176734_d())) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)this.rotation.FACING, (Comparable)f.func_176734_d()), 3);
            return true;
        }
        if (this.isValidFacing(world, pos, side)) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)this.rotation.FACING, (Comparable)side), 3);
            return true;
        }
        if (this.rotation == Rotation.FOUR) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)this.rotation.FACING, (Comparable)f.func_176746_e()), 3);
            return true;
        }
        return false;
    }

    protected boolean isValidFacing(World world, BlockPos pos, EnumFacing f) {
        return this.rotation.FACING.func_177700_c().contains(f);
    }

    protected boolean onToolUsed(World world, BlockPos pos, EntityPlayer player, EnumFacing side) {
        return false;
    }

    protected boolean useTool(World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side) {
        ItemStack held = player.field_71071_by.func_70448_g();
        if (!held.func_190926_b() && Integration.isTool(held, player, hand, pos) && this.rotation != null) {
            boolean wrenched = Integration.useTool(held, player, hand, pos);
            return wrenched && (this.onToolUsed(world, pos, player, side) || this.rotate(world, pos, player, side));
        }
        return false;
    }

    protected boolean canUseTool(World world, BlockPos pos, EntityPlayer player, EnumFacing side) {
        return this.rotation != Rotation.NONE;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            IGuiProvider guiProvider;
            if (!(this.canUseTool(world, pos, player, side) && this.useTool(world, pos, player, hand, side) || (guiProvider = this.getGuiProvider(world, pos, player, side)) == null)) {
                if (guiProvider.canOpen(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), player, side) && this.onOpenGui(world, pos, player, side)) {
                    player.openGui(this.parent, guiProvider.getGuiID(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    return true;
                }
                this.onOpenGuiDenied(world, pos, player, side);
            }
            return false;
        }
        return true;
    }

    protected boolean onOpenGui(World world, BlockPos pos, EntityPlayer player, EnumFacing side) {
        return true;
    }

    protected void onOpenGuiDenied(World world, BlockPos pos, EntityPlayer player, EnumFacing side) {
    }

    public void onBlockDestroyed(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            if (tileEntity instanceof TileEntityBase) {
                ((TileEntityBase)tileEntity).onBlockDestroy();
            }
            if (tileEntity instanceof IInventory && !world.field_72995_K) {
                ItemUtils.dropItems(world, pos, (IInventory)tileEntity);
            }
            tileEntity.func_145843_s();
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.func_176208_a(world, pos, state, player);
        this.onBlockDestroyed(world, pos, state);
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        super.onBlockExploded(world, pos, explosion);
        this.onBlockDestroyed(world, pos, this.func_176203_a(0));
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.onBlockDestroyed(world, pos, state);
        super.func_180663_b(world, pos, state);
    }

    public static enum Rotation {
        NONE(PropertyDirection.func_177713_a((String)"facing", Collections.singleton(EnumFacing.NORTH))),
        FOUR(PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL)),
        SIX(PropertyDirection.func_177714_a((String)"facing"));

        public final PropertyDirection FACING;

        private Rotation(PropertyDirection facing) {
            this.FACING = facing;
        }
    }
}

