/*
 * Decompiled with CFR 0.152.
 */
package fr.blueslime.slimeperipherals.block;

import fr.blueslime.slimeperipherals.SlimePeripherals;
import fr.blueslime.slimeperipherals.block.BlockPeripheral;
import fr.blueslime.slimeperipherals.init.ModItems;
import fr.blueslime.slimeperipherals.tileentity.TileEntityMagneticCardReader;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMagneticCardReader
extends BlockPeripheral {
    public static final PropertyEnum<EnumOrientation> ORIENTATION = PropertyEnum.func_177709_a((String)"facing", EnumOrientation.class);
    public static final PropertyEnum<EnumState> STATE = PropertyEnum.func_177709_a((String)"state", EnumState.class);
    private static final AxisAlignedBB UP_X_AABB = new AxisAlignedBB(0.375, 0.0, 0.25, 0.625, 0.15625, 0.75);
    private static final AxisAlignedBB UP_Y_AABB = new AxisAlignedBB(0.25, 0.0, 0.375, 0.75, 0.15625, 0.625);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.375, 0.25, 1.0, 0.625, 0.75, 0.84375);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.25, 0.375, 0.15625, 0.75, 0.625);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.375, 0.25, 0.0, 0.625, 0.75, 0.15625);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(1.0, 0.25, 0.375, 0.84375, 0.75, 0.625);
    private static final AxisAlignedBB DOWN_X_AABB = new AxisAlignedBB(0.375, 1.0, 0.25, 0.625, 0.84375, 0.75);
    private static final AxisAlignedBB DOWN_Y_AABB = new AxisAlignedBB(0.25, 1.0, 0.375, 0.75, 0.84375, 0.625);

    public BlockMagneticCardReader() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(ORIENTATION, (Comparable)((Object)EnumOrientation.DOWN_NORTH)).func_177226_a(STATE, (Comparable)((Object)EnumState.IDLE)));
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setRegistryName("slimeperipherals", "magnetic_card_reader");
        this.func_149663_c("slimeperipherals.magnetic_card_reader");
        this.func_149647_a(SlimePeripherals.TAB);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityMagneticCardReader tileEntity;
        if (playerIn.func_70093_af() || worldIn.field_72995_K) {
            return false;
        }
        ItemStack itemStack = playerIn.func_184586_b(hand);
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() == ModItems.MAGNETIC_CARD && (tileEntity = (TileEntityMagneticCardReader)worldIn.func_175625_s(pos)) != null) {
            tileEntity.onCardSwipe(playerIn, itemStack);
        }
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityMagneticCardReader();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumOrientation)((Object)state.func_177229_b(ORIENTATION))) {
            case UP_NORTH: 
            case UP_SOUTH: {
                return UP_X_AABB;
            }
            case UP_EAST: 
            case UP_WEST: {
                return UP_Y_AABB;
            }
            case NORTH: {
                return NORTH_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case DOWN_NORTH: 
            case DOWN_SOUTH: {
                return DOWN_X_AABB;
            }
            case DOWN_EAST: 
            case DOWN_WEST: {
                return DOWN_Y_AABB;
            }
        }
        return field_185506_k;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(ORIENTATION, (Comparable)((Object)EnumOrientation.byFacings(facing, placer.func_174811_aO())));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(ORIENTATION, (Comparable)((Object)EnumOrientation.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumOrientation)((Object)state.func_177229_b(ORIENTATION))).ordinal();
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ORIENTATION, STATE});
    }

    public static enum EnumState implements IStringSerializable
    {
        IDLE("idle"),
        WAITING_CARD("waiting_card"),
        WAITING_CARD_WRITE("waiting_card_write"),
        BUSY("busy"),
        REJECTED("rejected");

        private final String name;

        private EnumState(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }

    public static enum EnumOrientation implements IStringSerializable
    {
        DOWN_NORTH("down_north", true),
        DOWN_EAST("down_east", true),
        DOWN_SOUTH("down_south", true),
        DOWN_WEST("down_west", true),
        NORTH("north", false),
        EAST("east", false),
        SOUTH("south", false),
        WEST("west", false),
        UP_NORTH("up_north", true),
        UP_EAST("up_east", true),
        UP_SOUTH("up_south", true),
        UP_WEST("up_west", true);

        private static final EnumOrientation[] META_LOOKUP;
        private final String name;
        private final boolean horizontal;

        private EnumOrientation(String name, boolean horizontal) {
            this.name = name;
            this.horizontal = horizontal;
        }

        public boolean isHorizontal() {
            return this.horizontal;
        }

        public String toString() {
            return this.name;
        }

        public static EnumOrientation byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public static EnumOrientation byFacings(EnumFacing clickedSide, EnumFacing entityFacing) {
            switch (clickedSide) {
                case DOWN: {
                    switch (entityFacing) {
                        case NORTH: {
                            return DOWN_NORTH;
                        }
                        case EAST: {
                            return DOWN_EAST;
                        }
                        case SOUTH: {
                            return DOWN_SOUTH;
                        }
                        case WEST: {
                            return DOWN_WEST;
                        }
                    }
                    throw new IllegalArgumentException("Invalid entityFacing " + entityFacing + " for facing " + clickedSide);
                }
                case UP: {
                    switch (entityFacing) {
                        case NORTH: {
                            return UP_NORTH;
                        }
                        case EAST: {
                            return UP_EAST;
                        }
                        case SOUTH: {
                            return UP_SOUTH;
                        }
                        case WEST: {
                            return UP_WEST;
                        }
                    }
                    throw new IllegalArgumentException("Invalid entityFacing " + entityFacing + " for facing " + clickedSide);
                }
                case NORTH: {
                    return NORTH;
                }
                case SOUTH: {
                    return SOUTH;
                }
                case WEST: {
                    return WEST;
                }
                case EAST: {
                    return EAST;
                }
            }
            throw new IllegalArgumentException("Invalid facing: " + clickedSide);
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumOrientation[EnumOrientation.values().length];
            EnumOrientation[] enumOrientationArray = EnumOrientation.values();
            int n = enumOrientationArray.length;
            for (int i = 0; i < n; ++i) {
                EnumOrientation facing;
                EnumOrientation.META_LOOKUP[facing.ordinal()] = facing = enumOrientationArray[i];
            }
        }
    }
}

