/*
 * Decompiled with CFR 0.152.
 */
package fr.blueslime.slimeperipherals.block;

import fr.blueslime.slimeperipherals.SlimePeripherals;
import fr.blueslime.slimeperipherals.block.BlockMagneticCardReader;
import fr.blueslime.slimeperipherals.block.BlockPeripheral;
import fr.blueslime.slimeperipherals.init.ModItems;
import fr.blueslime.slimeperipherals.tileentity.TileEntityRFIDWriter;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRFIDWriter
extends BlockPeripheral {
    private static final PropertyEnum<BlockMagneticCardReader.EnumOrientation> ORIENTATION = BlockMagneticCardReader.ORIENTATION;
    public static final PropertyEnum<EnumState> STATE = PropertyEnum.func_177709_a((String)"state", EnumState.class);
    public static final PropertyBool FILLED = PropertyBool.func_177716_a((String)"filled");
    private static final AxisAlignedBB UP_X_AABB = new AxisAlignedBB(0.3125, 0.0, 0.25, 0.6875, 0.15625, 0.75);
    private static final AxisAlignedBB UP_Y_AABB = new AxisAlignedBB(0.25, 0.0, 0.3125, 0.75, 0.15625, 0.6875);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.3125, 0.25, 1.0, 0.6875, 0.75, 0.84375);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.25, 0.3125, 0.15625, 0.75, 0.6875);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.3125, 0.25, 0.0, 0.6875, 0.75, 0.15625);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(1.0, 0.25, 0.3125, 0.84375, 0.75, 0.6875);
    private static final AxisAlignedBB DOWN_X_AABB = new AxisAlignedBB(0.3125, 1.0, 0.25, 0.6875, 0.84375, 0.75);
    private static final AxisAlignedBB DOWN_Y_AABB = new AxisAlignedBB(0.25, 1.0, 0.3125, 0.75, 0.84375, 0.6875);

    public BlockRFIDWriter() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(ORIENTATION, (Comparable)((Object)BlockMagneticCardReader.EnumOrientation.DOWN_NORTH)).func_177226_a(STATE, (Comparable)((Object)EnumState.IDLE)).func_177226_a((IProperty)FILLED, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setRegistryName("slimeperipherals", "rfid_writer");
        this.func_149663_c("slimeperipherals.rfid_writer");
        this.func_149647_a(SlimePeripherals.TAB);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af() || worldIn.field_72995_K) {
            return true;
        }
        ItemStack itemStack = playerIn.func_184586_b(hand);
        TileEntityRFIDWriter tileEntity = (TileEntityRFIDWriter)worldIn.func_175625_s(pos);
        if (tileEntity == null) {
            return true;
        }
        if (!itemStack.func_190926_b() && itemStack.func_77973_b() == ModItems.RFID_CARD) {
            tileEntity.onCardPlace(playerIn, itemStack);
        } else {
            tileEntity.onCardTake();
        }
        return true;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (!worldIn.field_72995_K && tileEntity instanceof TileEntityRFIDWriter) {
            ((TileEntityRFIDWriter)tileEntity).onBlockBreak();
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityRFIDWriter();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((BlockMagneticCardReader.EnumOrientation)((Object)state.func_177229_b(ORIENTATION))) {
            case UP_NORTH: 
            case UP_SOUTH: {
                return UP_X_AABB;
            }
            case UP_EAST: 
            case UP_WEST: {
                return UP_Y_AABB;
            }
            case NORTH: {
                return NORTH_AABB;
            }
            case EAST: {
                return EAST_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case DOWN_NORTH: 
            case DOWN_SOUTH: {
                return DOWN_X_AABB;
            }
            case DOWN_EAST: 
            case DOWN_WEST: {
                return DOWN_Y_AABB;
            }
        }
        return field_185506_k;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a(ORIENTATION, (Comparable)((Object)BlockMagneticCardReader.EnumOrientation.byFacings(facing, placer.func_174811_aO())));
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(ORIENTATION, (Comparable)((Object)BlockMagneticCardReader.EnumOrientation.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((BlockMagneticCardReader.EnumOrientation)((Object)state.func_177229_b(ORIENTATION))).ordinal();
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ORIENTATION, STATE, FILLED});
    }

    public static enum EnumState implements IStringSerializable
    {
        IDLE("idle"),
        WAITING_CARD("waiting_card"),
        BUSY("busy");

        private final String name;

        private EnumState(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

