/*
 * Decompiled with CFR 0.152.
 */
package fr.blueslime.slimeperipherals.init;

import fr.blueslime.slimeperipherals.item.ItemCard;
import fr.blueslime.slimeperipherals.item.ItemElectronicPad;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="slimeperipherals")
public class ModItems {
    public static final Item MAGNETIC_CARD = new ItemCard("magnetic");
    public static final Item RFID_CARD = new ItemCard("rfid");
    public static final Item ELECTRONIC_PAD = new ItemElectronicPad();

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)MAGNETIC_CARD);
        event.getRegistry().register((IForgeRegistryEntry)RFID_CARD);
        event.getRegistry().register((IForgeRegistryEntry)ELECTRONIC_PAD);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerItemsModels(ModelRegistryEvent event) {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            ModItems.registerModel(MAGNETIC_CARD, color.func_176765_a(), color.func_176762_d());
            ModItems.registerModel(RFID_CARD, color.func_176765_a(), color.func_176762_d());
        }
        ModItems.registerModel(ELECTRONIC_PAD, 0, null, false);
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerModel(Item item) {
        ModItems.registerModel(item, 0);
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerModel(Item item, int metadata) {
        ModItems.registerModel(item, metadata, null);
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerModel(Item item, int metadata, String metadataName) {
        ModItems.registerModel(item, metadata, metadataName, true);
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerModel(Item item, int metadata, String metadataName, boolean specialName) {
        String resourceName = item.func_77658_a().substring(5).replace('.', ':');
        if (specialName) {
            resourceName = resourceName + "_" + (metadataName != null ? metadataName : Integer.valueOf(metadata));
        }
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)metadata, (ModelResourceLocation)new ModelResourceLocation(resourceName, "inventory"));
    }
}

