/*
 * Decompiled with CFR 0.152.
 */
package fr.blueslime.slimeperipherals.tileentity;

import fr.blueslime.slimeperipherals.block.BlockMagneticCardReader;
import fr.blueslime.slimeperipherals.init.ModBlocks;
import fr.blueslime.slimeperipherals.item.ItemCard;
import fr.blueslime.slimeperipherals.tileentity.TileEntityPeripheral;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileEntityMagneticCardReader
extends TileEntityPeripheral {
    private static final String STATE_NBT = "State";
    private static final String DATA_TO_WRITE_NBT = "DataToWrite";
    private BlockMagneticCardReader.EnumState state = BlockMagneticCardReader.EnumState.IDLE;
    private String dataToWrite;
    private boolean dirtyState = true;

    public TileEntityMagneticCardReader() {
        this.setHasEventQueue();
        this.computerMethodRegistry.register("readData", this::onMethodReadData);
        this.computerMethodRegistry.register("writeData", this::onMethodWriteData);
        this.computerMethodRegistry.register("setIdle", this::onMethodSetIdle);
        this.computerMethodRegistry.register("setBusy", this::onMethodSetBusy);
        this.computerMethodRegistry.register("setRejected", this::onMethodSetRejected);
        this.computerMethodRegistry.register("getState", this::onMethodGetState);
    }

    public void onCardSwipe(EntityPlayer player, ItemStack stack) {
        String cardData = ItemCard.getData(stack);
        if (this.state == BlockMagneticCardReader.EnumState.WAITING_CARD) {
            this.pushEvent(new Object[]{player.func_70005_c_(), cardData});
        } else if (this.state == BlockMagneticCardReader.EnumState.WAITING_CARD_WRITE) {
            ItemCard.setData(stack, this.dataToWrite);
            this.state = BlockMagneticCardReader.EnumState.IDLE;
            this.dirtyState = true;
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.dirtyState) {
            IBlockState blockState = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_180501_a(this.field_174879_c, blockState.func_177226_a(BlockMagneticCardReader.STATE, (Comparable)((Object)this.state)), 3);
            this.dirtyState = false;
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (newState.func_177230_c() == oldState.func_177230_c() && oldState.func_177230_c() == ModBlocks.MAGNETIC_CARD_READER) {
            return false;
        }
        return super.shouldRefresh(world, pos, oldState, newState);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.state = BlockMagneticCardReader.EnumState.values()[nbtTagCompound.func_74762_e(STATE_NBT)];
        if (this.state == BlockMagneticCardReader.EnumState.WAITING_CARD_WRITE) {
            this.dataToWrite = nbtTagCompound.func_74779_i(DATA_TO_WRITE_NBT);
        }
        this.dirtyState = true;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        nbtTagCompound.func_74768_a(STATE_NBT, this.state.ordinal());
        if (this.state == BlockMagneticCardReader.EnumState.WAITING_CARD_WRITE) {
            nbtTagCompound.func_74778_a(DATA_TO_WRITE_NBT, this.dataToWrite);
        }
        return nbtTagCompound;
    }

    @Override
    public String getComputerName() {
        return "magnetic_card_reader";
    }

    private Object[] onMethodReadData(Object[] args) {
        this.state = BlockMagneticCardReader.EnumState.WAITING_CARD;
        this.dirtyState = true;
        return new Object[0];
    }

    private Object[] onMethodWriteData(Object[] args) {
        this.dataToWrite = String.valueOf(args[0]);
        this.state = BlockMagneticCardReader.EnumState.WAITING_CARD_WRITE;
        this.dirtyState = true;
        return new Object[0];
    }

    private Object[] onMethodSetIdle(Object[] args) {
        this.state = BlockMagneticCardReader.EnumState.IDLE;
        this.dirtyState = true;
        return new Object[0];
    }

    private Object[] onMethodSetBusy(Object[] args) {
        this.state = BlockMagneticCardReader.EnumState.BUSY;
        this.dirtyState = true;
        return new Object[0];
    }

    private Object[] onMethodSetRejected(Object[] args) {
        this.state = BlockMagneticCardReader.EnumState.REJECTED;
        this.dirtyState = true;
        return new Object[0];
    }

    private Object[] onMethodGetState(Object[] args) {
        return new Object[]{this.state.func_176610_l()};
    }
}

