/*
 * Decompiled with CFR 0.152.
 */
package fr.blueslime.slimeperipherals.tileentity;

import fr.blueslime.slimeperipherals.integration.computer.ComputerEvent;
import fr.blueslime.slimeperipherals.integration.computer.ComputerMethodRegistry;
import fr.blueslime.slimeperipherals.integration.computer.IComputerIntegration;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public abstract class TileEntityPeripheral
extends TileEntity
implements ITickable,
IComputerIntegration {
    private static final String OWNER_NBT = "Owner";
    protected ComputerMethodRegistry computerMethodRegistry = new ComputerMethodRegistry();
    protected UUID owner = null;
    private final Queue<ComputerEvent> queuedEvents = new ConcurrentLinkedQueue<ComputerEvent>();

    public void func_73660_a() {
        for (ComputerEvent computerEvent2 : this.queuedEvents) {
            computerEvent2.decrTTL();
        }
        this.queuedEvents.removeIf(computerEvent -> computerEvent.getTTL() < 0);
    }

    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b(OWNER_NBT)) {
            this.owner = UUID.fromString(nbtTagCompound.func_74779_i(OWNER_NBT));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbtTagCompound) {
        super.func_189515_b(nbtTagCompound);
        if (this.owner != null) {
            nbtTagCompound.func_74778_a(OWNER_NBT, this.owner.toString());
        }
        return nbtTagCompound;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public Object[] invokeComputerMethod(int index, Object[] args) throws NoSuchMethodException {
        return this.computerMethodRegistry.invokeMethod(index, args);
    }

    protected void pushEvent(Object[] payload) {
        this.queuedEvents.add(new ComputerEvent(payload, 20));
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    protected void setHasEventQueue() {
        this.computerMethodRegistry.register("pollEvent", this::onMethodPollEvent);
        this.computerMethodRegistry.register("getEventCount", this::onMethodGetEventCount);
        this.computerMethodRegistry.register("hasEvent", this::onMethodHasEvent);
    }

    @Override
    public String[] getComputerMethods() {
        return this.computerMethodRegistry.getMethods();
    }

    public UUID getOwner() {
        return this.owner;
    }

    protected boolean assertInteractWithSecurity(EntityPlayer player) {
        if (!this.owner.equals(player.func_110124_au())) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("slimeperipherals.peripheral.access_refused", new Object[0]));
            return false;
        }
        return true;
    }

    private Object[] onMethodPollEvent(Object[] args) {
        if (this.queuedEvents.isEmpty()) {
            return new Object[0];
        }
        return this.queuedEvents.poll().getPayload();
    }

    private Object[] onMethodGetEventCount(Object[] args) {
        return new Object[]{this.queuedEvents.size()};
    }

    private Object[] onMethodHasEvent(Object[] args) {
        return new Object[]{!this.queuedEvents.isEmpty()};
    }
}

