/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICodebreakable;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.DisguisableBlockEntity;
import net.geforcemods.securitycraft.blocks.KeycardReaderBlock;
import net.geforcemods.securitycraft.blocks.KeypadBlock;
import net.geforcemods.securitycraft.inventory.ItemContainer;
import net.geforcemods.securitycraft.items.CodebreakerItem;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.TeamUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class KeycardReaderBlockEntity
extends DisguisableBlockEntity
implements ILockable,
ICodebreakable {
    protected boolean[] acceptedLevels = new boolean[]{true, false, false, false, false};
    protected int signature = 0;
    protected Option.BooleanOption sendDenylistMessage = new Option.SendDenylistMessageOption(true);
    protected Option.IntOption signalLength = new Option.SignalLengthOption(() -> ((KeycardReaderBlockEntity)this).func_174877_v(), 60);
    protected Option.DisabledOption disabled = new Option.DisabledOption(false);

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound acceptedLevelsTag = new NBTTagCompound();
        for (int i = 1; i <= 5; ++i) {
            acceptedLevelsTag.func_74757_a("lvl" + i, this.acceptedLevels[i - 1]);
        }
        tag.func_74782_a("acceptedLevels", (NBTBase)acceptedLevelsTag);
        tag.func_74768_a("signature", this.signature);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("passLV")) {
            boolean oldRequiresExactKeycard = false;
            int oldPassLV = tag.func_74762_e("passLV") - 1;
            if (tag.func_74764_b("requiresExactKeycard")) {
                oldRequiresExactKeycard = tag.func_74767_n("requiresExactKeycard");
            }
            for (int i = 0; i < 5; ++i) {
                this.acceptedLevels[i] = oldRequiresExactKeycard ? i == oldPassLV : i >= oldPassLV;
            }
        }
        if (tag.func_150297_b("acceptedLevels", 10)) {
            NBTTagCompound acceptedLevelsTag = tag.func_74775_l("acceptedLevels");
            for (int i = 1; i <= 5; ++i) {
                this.acceptedLevels[i - 1] = acceptedLevelsTag.func_74767_n("lvl" + i);
            }
        }
        this.signature = tag.func_74762_e("signature");
        if (tag.func_74764_b("sendMessage")) {
            this.sendDenylistMessage.setValue(tag.func_74767_n("sendMessage"));
        }
    }

    @Override
    public boolean shouldAttemptCodebreak(EntityPlayer player) {
        return (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)KeypadBlock.POWERED) == false;
    }

    @Override
    public void useCodebreaker(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            this.activate();
        }
    }

    public boolean onRightClickWithActionItem(ItemStack stack, EntityPlayer player, boolean isCodebreaker, boolean isKeycardHolder) {
        Block block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        if (isCodebreaker) {
            double chance = ConfigHandler.codebreakerChance;
            if (chance < 0.0) {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(block, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), TextFormatting.RED);
            } else {
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new NBTTagCompound());
                }
                if (!player.func_184812_l_() && (this.isOwnedBy((Entity)player) || CodebreakerItem.wasRecentlyUsed(stack))) {
                    return false;
                }
                boolean isSuccessful = player.func_184812_l_() || SecurityCraft.RANDOM.nextDouble() < chance;
                NBTTagCompound tag = stack.func_77978_p();
                stack.func_77972_a(1, (EntityLivingBase)player);
                tag.func_74772_a("last_used_time", System.currentTimeMillis());
                tag.func_74757_a("was_successful", isSuccessful);
                if (isSuccessful) {
                    this.activate();
                } else {
                    PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(SCContent.codebreaker, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:codebreaker.failed", new Object[0]), TextFormatting.RED);
                }
            }
        } else if (isKeycardHolder) {
            ItemContainer holderInventory = ItemContainer.keycardHolder(stack);
            ITextComponent feedback = null;
            for (int i = 0; i < holderInventory.func_70302_i_(); ++i) {
                ItemStack keycardStack = holderInventory.func_70301_a(i);
                if (!(keycardStack.func_77973_b() instanceof KeycardItem) || !keycardStack.func_77942_o() || (feedback = this.insertCard(keycardStack, player)) != null) continue;
                return true;
            }
            if (feedback == null) {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(block, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:keycard_holder.no_keycards", new Object[0]), TextFormatting.RED);
            } else {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(block, new Object[0]), (ITextComponent)Utils.localize("messages.securitycraft:keycard_holder.fail", new Object[0]), TextFormatting.RED);
            }
        } else {
            ITextComponent feedback = this.insertCard(stack, player);
            if (feedback != null) {
                PlayerUtils.sendMessageToPlayer(player, (ITextComponent)Utils.localize(block, new Object[0]), feedback, TextFormatting.RED);
            }
        }
        return true;
    }

    public ITextComponent insertCard(ItemStack stack, EntityPlayer player) {
        boolean powered;
        NBTTagCompound tag = stack.func_77978_p();
        Owner keycardOwner = new Owner(tag.func_74779_i("ownerName"), tag.func_74779_i("ownerUUID"));
        String usableBy = tag.func_74779_i("usable_by");
        if (!TeamUtils.areOnSameTeam(this.getOwner(), keycardOwner) || !this.getOwner().getUUID().equals(keycardOwner.getUUID())) {
            return new TextComponentTranslation("messages.securitycraft:keycardReader.differentOwner", new Object[0]);
        }
        if (!usableBy.isEmpty() && !usableBy.equals(player.func_146103_bH().getName())) {
            return new TextComponentTranslation("messages.securitycraft:keycardReader.cantUse", new Object[0]);
        }
        if (this.getSignature() != tag.func_74762_e("signature")) {
            return new TextComponentTranslation("messages.securitycraft:keycardReader.wrongSignature", new Object[0]);
        }
        int level = ((KeycardItem)stack.func_77973_b()).getLevel();
        if (!this.getAcceptedLevels()[level]) {
            return new TextComponentTranslation("messages.securitycraft:keycardReader.wrongLevel", new Object[]{level + 1});
        }
        boolean bl = powered = (Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)KeycardReaderBlock.POWERED) != false && this.getSignalLength() > 0;
        if (!powered) {
            if (tag.func_74767_n("limited")) {
                int uses = tag.func_74762_e("uses");
                if (uses <= 0) {
                    return new TextComponentTranslation("messages.securitycraft:keycardReader.noUses", new Object[0]);
                }
                if (!player.func_184812_l_()) {
                    tag.func_74768_a("uses", --uses);
                }
            }
            this.activate();
        }
        return null;
    }

    public void activate() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = state.func_177230_c();
        int signalLength = this.getSignalLength();
        this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177231_a((IProperty)KeycardReaderBlock.POWERED));
        BlockUtils.updateIndirectNeighbors(this.field_145850_b, this.field_174879_c, block);
        if (signalLength > 0) {
            this.field_145850_b.func_175684_a(this.field_174879_c, block, signalLength);
        }
    }

    @Override
    public <T> void onOptionChanged(Option<T> option) {
        if (option == this.signalLength) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)KeycardReaderBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            BlockUtils.updateIndirectNeighbors(this.field_145850_b, this.field_174879_c, SCContent.keycardReader);
        }
    }

    @Override
    public void onOwnerChanged(IBlockState state, World level, BlockPos pos, EntityPlayer player, Owner oldOwner, Owner newOwner) {
        this.reset();
        level.func_175656_a(pos, state.func_177226_a((IProperty)KeycardReaderBlock.POWERED, (Comparable)Boolean.valueOf(false)));
        BlockUtils.updateIndirectNeighbors(level, pos, state.func_177230_c());
        super.onOwnerChanged(state, level, pos, player, oldOwner, newOwner);
    }

    public void reset() {
        this.acceptedLevels = new boolean[]{true, false, false, false, false};
        this.signature = 0;
        this.func_70296_d();
    }

    public void setAcceptedLevels(boolean[] acceptedLevels) {
        this.acceptedLevels = acceptedLevels;
    }

    public boolean[] getAcceptedLevels() {
        return this.acceptedLevels;
    }

    public void setSignature(int signature) {
        this.signature = signature;
    }

    public int getSignature() {
        return this.signature;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST, ModuleType.DISGUISE, ModuleType.SMART};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.sendDenylistMessage, this.signalLength, this.disabled};
    }

    public boolean sendsDenylistMessage() {
        return (Boolean)this.sendDenylistMessage.get();
    }

    public int getSignalLength() {
        return (Integer)this.signalLength.get();
    }

    public boolean isDisabled() {
        return (Boolean)this.disabled.get();
    }
}

