/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.hudmods;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaEntityAccessor;
import mcp.mobius.waila.api.IWailaEntityProvider;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.WailaPlugin;
import mcp.mobius.waila.api.event.WailaRenderEvent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.compat.hudmods.HudModHandler;
import net.geforcemods.securitycraft.entity.sentry.Sentry;
import net.geforcemods.securitycraft.network.ClientProxy;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@WailaPlugin(value="securitycraft")
public final class WailaDataProvider
extends HudModHandler
implements IWailaPlugin,
IWailaDataProvider,
IWailaEntityProvider {
    public void register(IWailaRegistrar registrar) {
        registrar.addConfigRemote("SecurityCraft", "securitycraft.showowner", Utils.localize("waila.securitycraft:displayOwner", new Object[0]).func_150254_d());
        registrar.addConfigRemote("SecurityCraft", "securitycraft.showmodules", Utils.localize("waila.securitycraft:showModules", new Object[0]).func_150254_d());
        registrar.addConfigRemote("SecurityCraft", "securitycraft.showcustomname", Utils.localize("waila.securitycraft:showCustomName", new Object[0]).func_150254_d());
        registrar.registerBodyProvider((IWailaDataProvider)this, IOwnable.class);
        registrar.registerStackProvider((IWailaDataProvider)this, IOverlayDisplay.class);
        registrar.registerBodyProvider((IWailaEntityProvider)this, Sentry.class);
    }

    public ItemStack getWailaStack(IWailaDataAccessor data, IWailaConfigHandler config) {
        ItemStack displayStack;
        if (data.getBlock() instanceof IOverlayDisplay && (displayStack = ((IOverlayDisplay)data.getBlock()).getDisplayStack(data.getWorld(), data.getBlockState(), data.getPosition())) != null) {
            return displayStack;
        }
        return ItemStack.field_190927_a;
    }

    public List<String> getWailaBody(ItemStack stack, List<String> tooltip, IWailaDataAccessor data, IWailaConfigHandler config) {
        World level = data.getWorld();
        BlockPos pos = data.getPosition();
        IBlockState state = data.getBlockState();
        Block block = data.getBlock();
        this.addDisguisedOwnerModuleNameInfo(level, pos, state, block, data.getTileEntity(), data.getPlayer(), tooltip::add, arg_0 -> ((IWailaConfigHandler)config).getConfig(arg_0));
        return tooltip;
    }

    public List<String> getWailaBody(Entity entity, List<String> tooltip, IWailaEntityAccessor data, IWailaConfigHandler config) {
        this.addEntityInfo(data.getEntity(), data.getPlayer(), tooltip::add, arg_0 -> ((IWailaConfigHandler)config).getConfig(arg_0));
        return tooltip;
    }

    @SubscribeEvent
    public static void onWailaRender(WailaRenderEvent.Pre event) {
        if (ClientProxy.isPlayerMountedOnCamera()) {
            event.setCanceled(true);
        }
    }

    static {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register(WailaDataProvider.class);
        }
    }
}

