/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.items.ColorableItem;
import net.geforcemods.securitycraft.misc.SaltData;
import net.geforcemods.securitycraft.screen.ScreenHandler;
import net.geforcemods.securitycraft.util.PasscodeUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BriefcaseItem
extends ColorableItem {
    public boolean func_77662_d() {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        this.extraHandling(stack, world, player);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public void extraHandling(ItemStack stack, World level, EntityPlayer player) {
        if (!level.field_72995_K) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            player.openGui((Object)SecurityCraft.instance, stack.func_77978_p().func_74764_b("passcode") ? ScreenHandler.Screens.BRIEFCASE_INSERT_CODE.ordinal() : ScreenHandler.Screens.BRIEFCASE_CODE_SETUP.ordinal(), level, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.field_190940_C;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack briefcase, World world, List<String> tooltip, ITooltipFlag flag) {
        String ownerName = BriefcaseItem.getOwnerName(briefcase);
        if (!ownerName.isEmpty()) {
            tooltip.add(Utils.localize("tooltip.securitycraft.component.owner", ownerName).func_150255_a(Utils.GRAY_STYLE).func_150254_d());
        }
    }

    @Override
    public int getDefaultColor() {
        return 0x333333;
    }

    public static void hashAndSetPasscode(NBTTagCompound briefcaseTag, String passcode, Consumer<byte[]> afterSet) {
        byte[] salt = PasscodeUtils.generateSalt();
        briefcaseTag.func_186854_a("saltKey", SaltData.putSalt(salt));
        PasscodeUtils.hashPasscode(passcode, salt, p -> {
            briefcaseTag.func_74778_a("passcode", PasscodeUtils.bytesToString(p));
            afterSet.accept((byte[])p);
        });
    }

    public static void checkPasscode(EntityPlayerMP player, String incomingCode, String briefcaseCode, NBTTagCompound tag) {
        UUID saltKey = tag.func_186855_b("saltKey") ? tag.func_186857_a("saltKey") : null;
        byte[] salt = SaltData.getSalt(saltKey);
        if (salt == null) {
            PasscodeUtils.filterPasscodeAndSaltFromTag(tag);
            return;
        }
        PasscodeUtils.setOnCooldown((EntityPlayer)player);
        PasscodeUtils.hashPasscode(incomingCode, salt, p -> {
            if (Arrays.equals(PasscodeUtils.stringToBytes(briefcaseCode), p)) {
                if (!tag.func_74764_b("owner")) {
                    tag.func_74778_a("owner", player.func_70005_c_());
                    tag.func_74778_a("ownerUUID", player.func_110124_au().toString());
                }
                player.openGui((Object)SecurityCraft.instance, ScreenHandler.Screens.BRIEFCASE_INVENTORY.ordinal(), player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            }
        });
    }

    public static boolean isOwnedBy(ItemStack briefcase, EntityPlayer player) {
        if (!briefcase.func_77942_o()) {
            return true;
        }
        String ownerName = BriefcaseItem.getOwnerName(briefcase);
        String ownerUUID = BriefcaseItem.getOwnerUUID(briefcase);
        return ownerName.isEmpty() || ownerUUID.equals(player.func_110124_au().toString()) || ownerUUID.equals("ownerUUID") && ownerName.equals(player.func_70005_c_());
    }

    public static String getOwnerName(ItemStack briefcase) {
        return briefcase.func_77942_o() ? briefcase.func_77978_p().func_74779_i("owner") : "";
    }

    public static String getOwnerUUID(ItemStack briefcase) {
        return briefcase.func_77942_o() ? briefcase.func_77978_p().func_74779_i("ownerUUID") : "";
    }
}

