/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.misc;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.NBTPredicate;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PartialNBTIngredient
extends Ingredient {
    private final Set<Item> items;
    private final NBTPredicate predicate;

    protected PartialNBTIngredient(Set<Item> items, NBTTagCompound nbt) {
        super((ItemStack[])items.stream().map(item -> {
            ItemStack stack = new ItemStack(item);
            stack.func_77982_d(nbt.func_74737_b());
            return stack;
        }).toArray(ItemStack[]::new));
        if (items.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a PartialNBTIngredient with no items");
        }
        this.items = Collections.unmodifiableSet(items);
        this.predicate = new NBTPredicate(nbt);
    }

    public static PartialNBTIngredient of(NBTTagCompound nbt, Item ... items) {
        return new PartialNBTIngredient(Arrays.stream(items).collect(Collectors.toSet()), nbt);
    }

    public boolean apply(ItemStack input) {
        if (input == null) {
            return false;
        }
        return this.items.contains(input.func_77973_b()) && this.predicate.func_193477_a((NBTBase)input.func_77973_b().getNBTShareTag(input));
    }

    public boolean isSimple() {
        return false;
    }
}

