/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.geforcemods.securitycraft.blockentities.RiftStabilizerBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecureRedstoneInterfaceBlockEntity;
import net.geforcemods.securitycraft.screen.AlarmScreen;
import net.geforcemods.securitycraft.screen.RiftStabilizerScreen;
import net.geforcemods.securitycraft.screen.SecureRedstoneInterfaceScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OpenScreen
implements IMessage {
    private DataType dataType;
    private BlockPos pos;

    public OpenScreen() {
    }

    public OpenScreen(DataType dataType, BlockPos pos) {
        this.dataType = dataType;
        this.pos = pos;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dataType.ordinal());
        buf.writeLong(this.pos.func_177986_g());
    }

    public void fromBytes(ByteBuf buf) {
        this.dataType = DataType.values()[buf.readInt()];
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
    }

    public static enum DataType {
        ALARM,
        RIFT_STABILIZER,
        SECURE_REDSTONE_INTERFACE;

    }

    public static class Handler
    implements IMessageHandler<OpenScreen, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(OpenScreen message, MessageContext context) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                World level = SecurityCraft.proxy.getClientLevel();
                TileEntity te = level.func_175625_s(message.pos);
                switch (message.dataType) {
                    case ALARM: {
                        if (!(te instanceof AlarmBlockEntity)) break;
                        FMLCommonHandler.instance().showGuiScreen((Object)new AlarmScreen((AlarmBlockEntity)te));
                        break;
                    }
                    case RIFT_STABILIZER: {
                        if (!(te instanceof RiftStabilizerBlockEntity)) break;
                        FMLCommonHandler.instance().showGuiScreen((Object)new RiftStabilizerScreen((RiftStabilizerBlockEntity)te));
                        break;
                    }
                    case SECURE_REDSTONE_INTERFACE: {
                        if (!(te instanceof SecureRedstoneInterfaceBlockEntity)) break;
                        FMLCommonHandler.instance().showGuiScreen((Object)new SecureRedstoneInterfaceScreen((SecureRedstoneInterfaceBlockEntity)te));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled data type: " + message.dataType.name());
                    }
                }
            });
            return null;
        }
    }
}

