/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SyncAlarmSettings
implements IMessage {
    private BlockPos pos;
    private ResourceLocation soundEvent;
    private float pitch;
    private int soundLength;

    public SyncAlarmSettings() {
    }

    public SyncAlarmSettings(BlockPos pos, ResourceLocation soundEvent, float pitch, int soundLength) {
        this.pos = pos;
        this.soundEvent = soundEvent;
        this.pitch = pitch;
        this.soundLength = soundLength;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.soundEvent.toString());
        buf.writeFloat(this.pitch);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.soundLength, (int)5);
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.soundEvent = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        this.pitch = buf.readFloat();
        this.soundLength = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
    }

    public static class Handler
    implements IMessageHandler<SyncAlarmSettings, IMessage> {
        public IMessage onMessage(SyncAlarmSettings message, MessageContext context) {
            Utils.addScheduledTask(context.getServerHandler().field_147369_b.field_70170_p, () -> {
                AlarmBlockEntity be;
                EntityPlayerMP player = context.getServerHandler().field_147369_b;
                TileEntity tile = player.field_70170_p.func_175625_s(message.pos);
                if (tile instanceof AlarmBlockEntity && (be = (AlarmBlockEntity)tile).isOwnedBy((Entity)player)) {
                    if (!message.soundEvent.equals((Object)be.getSound())) {
                        be.setSound(message.soundEvent);
                    }
                    if (message.pitch != be.getPitch()) {
                        be.setPitch(message.pitch);
                    }
                    if (message.soundLength != be.getSoundLength()) {
                        be.setSoundLength(message.soundLength);
                    }
                }
            });
            return null;
        }
    }
}

