/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.client.config.GuiButtonExt;

public class Slider
extends GuiButtonExt {
    private double sliderValue;
    private boolean dragging = false;
    private double minValue = 0.0;
    private double maxValue = 5.0;
    @Nullable
    private ISlider parent = null;
    private boolean drawString = true;
    private String denotation;
    private String prefix;

    public Slider(String initialString, String denotation, int id, int xPos, int yPos, int width, int height, String prefix, double minVal, double maxVal, double currentVal, boolean drawStr, @Nullable ISlider par) {
        super(id, xPos, yPos, width, height, prefix);
        this.setMinValue(minVal);
        this.setMaxValue(maxVal);
        this.parent = par;
        this.denotation = denotation;
        this.setSliderValue((currentVal - minVal) / (maxVal - minVal));
        this.prefix = prefix;
        this.field_146126_j = initialString;
        this.drawString = drawStr;
        if (!this.drawString) {
            this.field_146126_j = "";
        }
    }

    public int func_146114_a(boolean par1) {
        return 0;
    }

    protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
        if (this.field_146125_m) {
            if (this.isDragging()) {
                this.setSliderValue((double)(mouseX - (this.field_146128_h + 4)) / (double)(this.field_146120_f - 8));
                this.updateSlider();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_73729_b(this.field_146128_h + (int)(this.getSliderValue() * (double)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, 20);
            this.func_73729_b(this.field_146128_h + (int)(this.getSliderValue() * (double)(this.field_146120_f - 8)) + 4, this.field_146129_i, 196, 66, 4, 20);
        }
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY)) {
            this.setSliderValue((double)(mouseX - (this.field_146128_h + 4)) / (double)(this.field_146120_f - 8));
            this.updateSlider();
            this.setDragging(true);
            return true;
        }
        return false;
    }

    public void updateSlider() {
        if (this.getSliderValue() < 0.0) {
            this.setSliderValue(0.0);
        }
        if (this.getSliderValue() > 1.0) {
            this.setSliderValue(1.0);
        }
        if (this.parent != null) {
            this.parent.onChangeSliderValue(this, this.denotation, this.field_146127_k);
        }
    }

    public void func_146118_a(int mouseX, int mouseY) {
        this.setDragging(false);
        if (this.parent != null) {
            this.parent.onMouseRelease(this.field_146127_k);
        }
    }

    public int getValueInt() {
        return (int)Math.round(this.getValue());
    }

    public double getValue() {
        return this.getSliderValue() * (this.maxValue - this.minValue) + this.minValue;
    }

    public void setValue(double newValue) {
        this.setSliderValue((newValue - this.minValue) / (this.maxValue - this.minValue));
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    public double getSliderValue() {
        return this.sliderValue;
    }

    public void setSliderValue(double sliderValue) {
        this.sliderValue = sliderValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static interface ISlider {
        public void onChangeSliderValue(Slider var1, String var2, int var3);

        public void onMouseRelease(int var1);
    }
}

