/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.geforcemods.securitycraft.util.IToggleableEntries;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.client.GuiScrollingList;
import net.minecraftforge.fml.client.config.GuiUtils;

public class ToggleScrollList<T>
extends GuiScrollingList {
    private static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    private int hoveredSlot = -1;
    private int slotTop = -1;
    private final List<T> orderedFilterList;
    private final Map<T, ITextComponent> typeNames = new HashMap<T, ITextComponent>();
    private final Minecraft mc;
    private final IToggleableEntries<T> te;
    private final boolean hasSmartModule;
    private final boolean hasRedstoneModule;

    public ToggleScrollList(IToggleableEntries<T> te, boolean hasSmartModule, boolean hasRedstoneModule, Minecraft mc, int width, int height, int top, int left, int screenWidth, int screenHeight) {
        super(mc, width, height, top, top + height, left, 12, screenWidth, screenHeight);
        this.mc = mc;
        this.te = te;
        this.hasSmartModule = hasSmartModule;
        this.hasRedstoneModule = hasRedstoneModule;
        this.orderedFilterList = new ArrayList<T>(te.getFilters().keySet());
        this.orderedFilterList.sort((e1, e2) -> {
            if (e1 == te.getDefaultType()) {
                return 1;
            }
            if (e2 == te.getDefaultType()) {
                return -1;
            }
            return te.getTypeName(e1).compareTo(te.getTypeName(e2));
        });
    }

    protected int getSize() {
        return this.orderedFilterList.size();
    }

    protected boolean isSelected(int index) {
        return this.hasSmartModule && index == this.hoveredSlot;
    }

    protected void drawBackground() {
    }

    protected int getContentHeight() {
        int height = this.getSize() * (this.mc.field_71466_p.field_78288_b + 3);
        if (height < this.bottom - this.top - 4) {
            height = this.bottom - this.top - 4;
        }
        return height;
    }

    protected void elementClicked(int index, boolean doubleClick) {
        if (this.hasSmartModule) {
            this.te.toggleFilter(this.orderedFilterList.get(index));
            this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        int comparatorOutput;
        super.drawScreen(mouseX, mouseY, partialTicks);
        int slotBottom = this.slotTop + this.slotHeight;
        if (this.hasRedstoneModule && mouseX >= this.left && mouseX <= this.right - 7 && this.hoveredSlot >= 0 && this.hoveredSlot < this.getSize() && mouseY >= this.top && mouseY <= this.bottom && (comparatorOutput = this.te.getComparatorOutputFunction().applyAsInt(this.orderedFilterList.get(this.hoveredSlot))) > 0) {
            GuiUtils.drawHoveringText(Collections.singletonList(Utils.localize("gui.securitycraft:toggleList.comparatorOutput", comparatorOutput).func_150254_d()), (int)(this.right - 8), (int)slotBottom, (int)this.screenWidth, (int)this.screenHeight, (int)-1, (FontRenderer)this.mc.field_71466_p);
            RenderHelper.func_74518_a();
        }
    }

    protected void drawSlot(int slotIndex, int entryRight, int slotTop, int slotBuffer, Tessellator tess) {
        if (this.mouseX >= this.left && this.mouseX <= entryRight && slotIndex >= 0 && slotIndex < this.getSize() && this.mouseY >= slotTop - 1 && this.mouseY <= slotTop + slotBuffer + 2) {
            this.hoveredSlot = slotIndex;
            this.slotTop = slotTop;
        } else if (this.mouseX < this.left || this.mouseX > this.right || this.mouseY < this.top || this.mouseY > this.bottom || this.mouseY > this.top + this.slotHeight * this.getSize()) {
            this.hoveredSlot = -1;
        }
        T type = this.orderedFilterList.get(slotIndex);
        String name = this.typeNames.computeIfAbsent(type, t -> Utils.localize(t == this.te.getDefaultType() ? this.te.getDefaultTypeName() : this.te.getTypeName(t), new Object[0])).func_150254_d();
        this.mc.field_71466_p.func_78276_b(name, this.left + this.listWidth / 2 - this.mc.field_71466_p.func_78256_a(name) / 2, slotTop, 0xC6C6C6);
        this.mc.func_110434_K().func_110577_a(BEACON_GUI);
        Gui.func_152125_a((int)this.left, (int)(slotTop - 3), (float)(this.te.getFilter(type) ? 88.0f : 110.0f), (float)219.0f, (int)21, (int)22, (int)14, (int)14, (float)256.0f, (float)256.0f);
    }
}

