/*
 * Decompiled with CFR 0.152.
 */
package com.v1993.galacticcomputers;

import com.v1993.galacticcomputers.SubMod;
import com.v1993.galacticcomputers.gccore.GCCoreSubmod;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;

@Mod(modid="galacticcomputers", name="Galactic Computers", version="1.0.0", dependencies="required-after:opencomputers@[1.7,);required-after:galacticraftcore@[4.0.2,);after:galacticraftplanets@[4.0.2,);after:galaxyspace@[2.0.16,)")
public class GalacticComputers {
    public static final String MODID = "galacticcomputers";
    public static final String NAME = "Galactic Computers";
    public static final String VERSION = "1.0.0";
    private static Logger logger;
    private static List<SubMod> submods;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws Exception {
        logger = event.getModLog();
        submods = new ArrayList<SubMod>();
        logger.info("Loading GalacticComputers integrations");
        logger.info("Unconditionally loading GalactiCraft Core integration");
        submods.add(new GCCoreSubmod());
        if (Loader.isModLoaded((String)"galacticraftplanets")) {
            logger.info("Loading GalactiCraft Planets integration");
            submods.add((SubMod)Class.forName("com.v1993.galacticcomputers.gcplanets.GCPlanetsSubmod").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        if (Loader.isModLoaded((String)"galaxyspace")) {
            logger.info("Loading GalaxySpace integration");
            submods.add((SubMod)Class.forName("com.v1993.galacticcomputers.galaxyspace.GalaxySpaceSubmod").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        for (SubMod smod : submods) {
            smod.preInit(event);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        for (SubMod smod : submods) {
            smod.init(event);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (SubMod smod : submods) {
            smod.postInit(event);
        }
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        for (SubMod smod : submods) {
            smod.registerBlocks(event);
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        for (SubMod smod : submods) {
            smod.registerItems(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        for (SubMod smod : submods) {
            smod.registerModels(event);
        }
    }
}

