/*
 * Decompiled with CFR 0.152.
 */
package com.v1993.galacticcomputers.gccore;

import com.v1993.galacticcomputers.utils.NamedManagedEnvironment;
import java.lang.reflect.Field;
import java.util.HashMap;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.prefab.DriverSidedTileEntity;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTelemetry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DriverTelemetryUnit
extends DriverSidedTileEntity {
    public Class<?> getTileEntityClass() {
        return TileEntityTelemetry.class;
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing facing) {
        TileEntityTelemetry tile = (TileEntityTelemetry)world.func_175625_s(pos);
        return new InternalManagedEnvironment(tile);
    }

    public static class InternalManagedEnvironment
    extends NamedManagedEnvironment<TileEntityTelemetry> {
        protected static Class<?> classAstroMiner = null;

        public InternalManagedEnvironment(TileEntityTelemetry tileEntity) {
            super(tileEntity, "telemetry_unit");
        }

        @Callback(doc="function(): boolean -- Is telemetry unit linked to something")
        public Object[] isLinked(Context context, Arguments args) {
            return new Object[]{((TileEntityTelemetry)this.tileEntity).linkedEntity != null};
        }

        @Callback(doc="function(): table -- Read telemetry data from linked entity (try it and see results!)")
        public Object[] readTelemetry(Context context, Arguments args) {
            Entity e = ((TileEntityTelemetry)this.tileEntity).linkedEntity;
            if (e == null) {
                return new Object[]{null};
            }
            if (classAstroMiner == null && GalacticraftCore.isPlanetsLoaded) {
                try {
                    classAstroMiner = Class.forName("micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityAstroMiner");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            HashMap<String, Object> m = new HashMap<String, Object>();
            m.put("name", e.func_70005_c_());
            double xmotion = e.field_70159_w;
            double ymotion = e instanceof EntityLivingBase ? e.field_70181_x + 0.0784 : e.field_70181_x;
            double zmotion = e.field_70179_y;
            double speed = Math.sqrt(xmotion * xmotion + ymotion * ymotion + zmotion * zmotion) * 20.0;
            m.put("speed", speed);
            m.put("x", e.field_70165_t);
            m.put("y", e.field_70163_u);
            m.put("z", e.field_70161_v);
            if (e instanceof EntityPlayer) {
                m.put("type", "PLAYER");
                m.put("food", ((EntityPlayer)e).func_71024_bL().func_75116_a() * 5);
                GCPlayerStats stats = GCPlayerStats.get((Entity)e);
                double oxygen = stats.getAirRemaining() * 4096 + stats.getAirRemaining2();
                m.put("oxygenSecondsLeft", oxygen * 9.0 / 20.0);
            } else if (e instanceof EntitySpaceshipBase) {
                EntitySpaceshipBase es = (EntitySpaceshipBase)e;
                m.put("type", "ROCKET");
                m.put("countdown", Float.valueOf((float)es.timeUntilLaunch / 20.0f));
                m.put("isIgnited", es.launchPhase != 0);
                m.put("fuelTank", es.fuelTank.getInfo());
            } else if (classAstroMiner != null && classAstroMiner.isInstance(e)) {
                m.put("type", "ASTRO_MINER");
                try {
                    m.put("storedEnergy", classAstroMiner.getField("energyLevel").getInt(e));
                    m.put("maxEnergy", 12000);
                }
                catch (Exception es) {
                    // empty catch block
                }
                try {
                    int ai = classAstroMiner.getField("AIstate").getInt(e);
                    String status = "UNKNOWN";
                    if (ai == classAstroMiner.getField("AISTATE_STUCK").getInt(e)) {
                        status = "STUCK";
                    } else if (ai == classAstroMiner.getField("AISTATE_ATBASE").getInt(e)) {
                        status = "DOCKED";
                    } else if (ai == classAstroMiner.getField("AISTATE_TRAVELLING").getInt(e)) {
                        status = "TRAVELLING";
                    } else if (ai == classAstroMiner.getField("AISTATE_MINING").getInt(e)) {
                        status = "MINING";
                    } else if (ai == classAstroMiner.getField("AISTATE_RETURNING").getInt(e)) {
                        status = "RETURNING";
                    } else if (ai == classAstroMiner.getField("AISTATE_DOCKING").getInt(e)) {
                        status = "DOCKING";
                    } else if (ai == classAstroMiner.getField("AISTATE_OFFLINE").getInt(e)) {
                        status = "OFFLINE";
                    }
                    m.put("status", status);
                }
                catch (Exception ai) {}
            } else if (e instanceof EntityLivingBase) {
                m.put("type", "MOB");
            } else {
                m.put("type", "GENERIC");
            }
            if (e instanceof EntityLivingBase) {
                EntityLivingBase el = (EntityLivingBase)e;
                m.put("health", Float.valueOf(el.func_110143_aJ()));
                m.put("maxHealth", Float.valueOf(el.func_110138_aP()));
                m.put("recentlyHurt", el.field_70737_aN > 0);
                try {
                    Field f = TileEntityTelemetry.class.getDeclaredField("pulseRate");
                    f.setAccessible(true);
                    m.put("pulseRate", (Integer)f.get(this.tileEntity) / 10);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new Object[]{m};
        }
    }
}

