/*
 * Decompiled with CFR 0.152.
 */
package marytts.cart.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Scanner;
import java.util.StringTokenizer;
import marytts.cart.CART;
import marytts.cart.DecisionNode;
import marytts.cart.LeafNode;
import marytts.cart.Node;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureDefinition;
import marytts.htsengine.HMMData;
import marytts.htsengine.PhoneTranslator;
import marytts.util.MaryUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class HTSCARTReader {
    private FeatureDefinition featDef;
    private PhoneTranslator phTrans;
    private Logger logger = MaryUtils.getLogger("HTSCARTReader");
    private int vectorSize;

    public int getVectorSize() {
        return this.vectorSize;
    }

    public CART[] load(int numStates, InputStream treeStream, InputStream pdfStream, HMMData.PdfFileFormat fileFormat, FeatureDefinition featDefinition, PhoneTranslator phTranslator) throws IOException, MaryConfigurationException {
        String line;
        this.featDef = featDefinition;
        BufferedReader s = null;
        this.phTrans = phTranslator;
        CART[] treeSet = new CART[numStates];
        int i = 0;
        while (i < numStates) {
            treeSet[i] = new CART();
            ++i;
        }
        double[][][][] pdf = this.loadPdfs(numStates, pdfStream, fileFormat);
        assert (featDefinition != null) : "Feature Definition was not set";
        s = new BufferedReader(new InputStreamReader(treeStream, "UTF-8"));
        while ((line = s.readLine()) != null) {
            if (line.indexOf("QS") < 0) break;
        }
        while ((line = s.readLine()) != null) {
            if (line.indexOf("{*}") < 0) continue;
            String aux = line.substring(line.indexOf("[") + 1, line.indexOf("]"));
            int state = Integer.parseInt(aux);
            treeSet[state - 2].setRootNode(this.loadStateTree(s, pdf[state - 2]));
            if (treeSet[state - 2].getRootNode() instanceof DecisionNode) {
                ((DecisionNode)treeSet[state - 2].getRootNode()).countData();
            }
            this.logger.debug("load: CART[" + (state - 2) + "], total number of nodes in this CART: " + treeSet[state - 2].getNumNodes());
        }
        if (s != null) {
            s.close();
        }
        if (treeSet.length == 0) {
            throw new IOException("LoadTreeSet: error no trees loaded");
        }
        return treeSet;
    }

    private Node loadStateTree(BufferedReader s, double[][][] pdf) throws IOException, MaryConfigurationException {
        DecisionNode.BinaryByteDecisionNode nextNode;
        DecisionNode.BinaryByteDecisionNode rootNode = null;
        rootNode = nextNode = new DecisionNode.BinaryByteDecisionNode(0, this.featDef);
        nextNode.setIsRoot(true);
        int ndec = 0;
        int nleaf = 0;
        Node node = null;
        String aux = s.readLine();
        if (aux.indexOf("{") >= 0) {
            while ((aux = s.readLine()) != null && aux.indexOf("}") < 0) {
                Node auxnode;
                int iaux;
                int id;
                StringTokenizer sline = new StringTokenizer(aux);
                String buf = sline.nextToken();
                if (buf.startsWith("-")) {
                    id = Integer.parseInt(buf.substring(1));
                    ++ndec;
                } else if (buf.contentEquals("0")) {
                    id = 0;
                } else {
                    throw new MaryConfigurationException("LoadStateTree: line does not start with a decision node (-id), line=" + aux);
                }
                node = this.findDecisionNode(rootNode, id);
                if (node == null) {
                    throw new MaryConfigurationException("LoadStateTree: Node not found, index = " + buf);
                }
                buf = sline.nextToken();
                String[] fea_val = buf.split("=");
                this.featDef.getFeatureIndex(fea_val[0]);
                if (fea_val[0].contentEquals("sentence_punc") || fea_val[0].contentEquals("prev_punctuation") || fea_val[0].contentEquals("next_punctuation")) {
                    fea_val[1] = this.phTrans.replaceBackPunc(fea_val[1]);
                } else if (fea_val[0].contains("tobi_")) {
                    fea_val[1] = this.phTrans.replaceBackToBI(fea_val[1]);
                } else if (fea_val[0].contains("phone")) {
                    fea_val[1] = this.phTrans.replaceBackTrickyPhones(fea_val[1]);
                }
                ((DecisionNode.BinaryByteDecisionNode)node).setFeatureAndFeatureValue(fea_val[0], fea_val[1]);
                buf = sline.nextToken();
                if (buf.startsWith("-")) {
                    iaux = Integer.parseInt(buf.substring(1));
                    auxnode = new DecisionNode.BinaryByteDecisionNode(iaux, this.featDef);
                    ((DecisionNode)node).replaceDaughter(auxnode, 1);
                } else {
                    iaux = Integer.parseInt(buf.substring(buf.lastIndexOf("_") + 1, buf.length() - 1));
                    auxnode = new LeafNode.PdfLeafNode(iaux, pdf[iaux - 1]);
                    ((DecisionNode)node).replaceDaughter(auxnode, 1);
                    ++nleaf;
                }
                buf = sline.nextToken();
                if (buf.startsWith("-")) {
                    iaux = Integer.parseInt(buf.substring(1));
                    auxnode = new DecisionNode.BinaryByteDecisionNode(iaux, this.featDef);
                    ((DecisionNode)node).replaceDaughter(auxnode, 0);
                } else {
                    iaux = Integer.parseInt(buf.substring(buf.lastIndexOf("_") + 1, buf.length() - 1));
                    auxnode = new LeafNode.PdfLeafNode(iaux, pdf[iaux - 1]);
                    ((DecisionNode)node).replaceDaughter(auxnode, 0);
                    ++nleaf;
                }
                sline = null;
            }
        }
        this.logger.debug("loadStateTree: loaded CART contains " + (ndec + 1) + " Decision nodes and " + nleaf + " Leaf nodes.");
        return rootNode;
    }

    private Node findDecisionNode(Node node, int numId) {
        Node aux = null;
        if (node instanceof DecisionNode) {
            if (((DecisionNode)node).getUniqueDecisionNodeId() == numId) {
                return node;
            }
            int i = 0;
            while (i < ((DecisionNode)node).getNumberOfDaugthers()) {
                aux = this.findDecisionNode(((DecisionNode)node).getDaughter(i), numId);
                if (aux != null) {
                    return aux;
                }
                ++i;
            }
        }
        return aux;
    }

    private double[][][][] loadPdfs(int numState, InputStream pdfStream, HMMData.PdfFileFormat fileFormat) throws IOException, MaryConfigurationException {
        Object pdf = null;
        if (fileFormat == HMMData.PdfFileFormat.dur || fileFormat == HMMData.PdfFileFormat.join) {
            DataInputStream data_in = new DataInputStream(new BufferedInputStream(pdfStream));
            this.logger.debug("loadPdfs reading model of type " + (Object)((Object)fileFormat));
            data_in.readInt();
            int numStream = data_in.readInt();
            this.vectorSize = data_in.readInt();
            numState = numStream;
            if (numState < 0) {
                throw new MaryConfigurationException("loadPdfs: #HMM states must be positive value.");
            }
            int numDurPdf = data_in.readInt();
            this.logger.debug("loadPdfs: numPdf[state:0]=" + numDurPdf);
            pdf = new double[1][numDurPdf][1][2 * numState];
            int vsize = 2 * numState;
            int i = 0;
            while (i < numDurPdf) {
                int j = 0;
                while (j < numState) {
                    pdf[0][i][0][j] = data_in.readFloat();
                    pdf[0][i][0][j + numState] = data_in.readFloat();
                    ++j;
                }
                ++i;
            }
            data_in.close();
            data_in = null;
        } else if (fileFormat == HMMData.PdfFileFormat.lf0) {
            DataInputStream data_in = new DataInputStream(new BufferedInputStream(pdfStream));
            this.logger.debug("loadPdfs reading model of type " + (Object)((Object)fileFormat));
            data_in.readInt();
            int numStream = data_in.readInt();
            this.vectorSize = data_in.readInt();
            int lf0Stream = numStream;
            if (lf0Stream < 0) {
                throw new MaryConfigurationException("loadPdfs:  #stream for log f0 part must be positive value.");
            }
            pdf = new double[numState][][][];
            int[] numPdf = new int[numState];
            int i = 0;
            while (i < numState) {
                numPdf[i] = data_in.readInt();
                this.logger.debug("loadPdfs: numPdf[state:" + i + "]=" + numPdf[i]);
                if (numPdf[i] < 0) {
                    throw new MaryConfigurationException("loadPdfs: #lf0 pdf at state " + i + " must be positive value.");
                }
                pdf[i] = new double[numPdf[i]][lf0Stream][4];
                ++i;
            }
            i = 0;
            while (i < numState) {
                int j = 0;
                while (j < numPdf[i]) {
                    int k = 0;
                    while (k < lf0Stream) {
                        int l = 0;
                        while (l < 4) {
                            pdf[i][j][k][l] = data_in.readFloat();
                            ++l;
                        }
                        double vw = pdf[i][j][k][2];
                        double uvw = pdf[i][j][k][3];
                        if (vw < 0.0 || uvw < 0.0 || vw + uvw < 0.99 || vw + uvw > 1.01) {
                            throw new MaryConfigurationException("loadPdfs: voiced/unvoiced weights must be within 0.99 to 1.01.");
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            data_in.close();
            data_in = null;
        } else if (fileFormat == HMMData.PdfFileFormat.mgc || fileFormat == HMMData.PdfFileFormat.str || fileFormat == HMMData.PdfFileFormat.mag) {
            DataInputStream data_in = new DataInputStream(new BufferedInputStream(pdfStream));
            this.logger.debug("loadPdfs reading model of type " + (Object)((Object)fileFormat));
            data_in.readInt();
            int numStream = data_in.readInt();
            int vsize = this.vectorSize = data_in.readInt();
            if (vsize < 0) {
                throw new MaryConfigurationException("loadPdfs: vector size of pdf must be positive.");
            }
            pdf = new double[numState][][][];
            int[] numPdf = new int[numState];
            int i = 0;
            while (i < numState) {
                numPdf[i] = data_in.readInt();
                this.logger.debug("loadPdfs: numPdf[state:" + i + "]=" + numPdf[i]);
                if (numPdf[i] < 0) {
                    throw new MaryConfigurationException("loadPdfs: #pdf at state " + i + " must be positive value.");
                }
                pdf[i] = new double[numPdf[i]][numStream][2 * vsize];
                ++i;
            }
            i = 0;
            while (i < numState) {
                int j = 0;
                while (j < numPdf[i]) {
                    int k = 0;
                    while (k < vsize) {
                        pdf[i][j][0][k] = data_in.readFloat();
                        pdf[i][j][0][k + vsize] = data_in.readFloat();
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
            data_in.close();
            data_in = null;
        }
        return pdf;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        BasicConfigurator.configure();
        String contextFile = "/project/mary/marcela/openmary/lib/voices/hsmm-slt/cmu_us_arctic_slt_a0001.pfeats";
        Scanner context = new Scanner(new BufferedReader(new FileReader(contextFile)));
        String strContext = "";
        while (context.hasNext()) {
            strContext = String.valueOf(strContext) + context.nextLine();
            strContext = String.valueOf(strContext) + "\n";
        }
        context.close();
        FeatureDefinition feaDef = new FeatureDefinition(new BufferedReader(new StringReader(strContext)), false);
        int numStates = 5;
        String trickyPhones = "/project/mary/marcela/openmary/lib/voices/hsmm-slt/trickyPhones.txt";
        String treefile = "/project/mary/marcela/openmary/lib/voices/hsmm-slt/tree-dur.inf";
        String pdffile = "/project/mary/marcela/openmary/lib/voices/hsmm-slt/dur.pdf";
        PhoneTranslator phTranslator = new PhoneTranslator(new FileInputStream(trickyPhones));
        HTSCARTReader htsReader = new HTSCARTReader();
        try {
            htsReader.load(numStates, new FileInputStream(treefile), new FileInputStream(pdffile), HMMData.PdfFileFormat.dur, feaDef, phTranslator);
            int vSize = htsReader.getVectorSize();
            System.out.println("loaded " + pdffile + "  vector size=" + vSize);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }
}

