/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.datatypes.MaryDataType;
import marytts.modules.SynthesisCallerBase;
import marytts.modules.synthesis.Voice;
import marytts.server.MaryProperties;
import marytts.util.MaryRuntimeUtils;
import marytts.util.MaryUtils;
import marytts.util.data.audio.AudioDestination;
import marytts.util.data.audio.AudioReader;
import org.apache.log4j.Logger;

public class FestivalCaller
extends SynthesisCallerBase {
    protected File festivalDir;
    protected File relationsDir;
    protected File segmentDir;
    protected File syllableDir;
    protected File wordDir;
    protected File intEventDir;
    protected File phraseDir;
    protected File targetDir;
    protected File uttsDir;
    private static int timeout;

    public FestivalCaller() {
        super("FestivalCaller", MaryDataType.FESTIVAL_UTT, MaryDataType.AUDIO);
        timeout = MaryProperties.needInteger("modules.timeout");
    }

    @Override
    public synchronized void startup() throws Exception {
        this.festivalDir = new File(MaryProperties.getFilename("festival.tmp.dir", String.valueOf(System.getProperty("mary.base")) + File.separator + "tmp" + File.separator + "festival"));
        this.relationsDir = new File(String.valueOf(this.festivalDir.getPath()) + File.separator + "relations");
        this.segmentDir = new File(String.valueOf(this.relationsDir.getPath()) + File.separator + "Segment");
        this.syllableDir = new File(String.valueOf(this.relationsDir.getPath()) + File.separator + "Syllable");
        this.wordDir = new File(String.valueOf(this.relationsDir.getPath()) + File.separator + "Word");
        this.intEventDir = new File(String.valueOf(this.relationsDir.getPath()) + File.separator + "IntEvent");
        this.phraseDir = new File(String.valueOf(this.relationsDir.getPath()) + File.separator + "Phrase");
        this.targetDir = new File(String.valueOf(this.relationsDir.getPath()) + File.separator + "Target");
        this.uttsDir = new File(String.valueOf(this.festivalDir.getPath()) + File.separator + "utts");
        this.makeSureIsDirectory(this.festivalDir);
        this.makeSureIsDirectory(this.relationsDir);
        this.makeSureIsDirectory(this.segmentDir);
        this.makeSureIsDirectory(this.syllableDir);
        this.makeSureIsDirectory(this.wordDir);
        this.makeSureIsDirectory(this.intEventDir);
        this.makeSureIsDirectory(this.phraseDir);
        this.makeSureIsDirectory(this.targetDir);
        this.makeSureIsDirectory(this.uttsDir);
        super.startup();
    }

    private void makeSureIsDirectory(File dir) throws IOException {
        if (!dir.isDirectory()) {
            boolean success;
            if (dir.exists() && !(success = dir.delete())) {
                throw new IOException("Need to create directory " + dir.getPath() + ", but file exists that cannot be deleted.");
            }
            success = dir.mkdir();
            if (!success) {
                throw new IOException("Cannot create directory " + dir.getPath());
            }
        }
    }

    @Override
    public AudioInputStream synthesiseOneSection(String festivalUtt, Voice voice) throws IOException {
        this.writeRelationFiles(festivalUtt);
        File audioFile = new File(String.valueOf(this.festivalDir.getPath()) + File.separator + "mary.wav");
        String festivalVoiceCmd = "(voice_" + voice.getName() + ")";
        AudioInputStream sound = this.festivalSynthesise(audioFile, festivalVoiceCmd);
        return sound;
    }

    private void writeRelationFiles(String festivalUtt) throws IOException {
        String line;
        BufferedReader buf = new BufferedReader(new StringReader(festivalUtt));
        String relation = null;
        PrintWriter pw = null;
        while ((line = buf.readLine()) != null) {
            if (line.startsWith("==") && !line.startsWith("===")) {
                relation = line.substring(2, line.indexOf(61, 2));
                this.logger.debug("Writing " + relation + " relation:");
                if (pw != null) {
                    pw.close();
                }
                pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(String.valueOf(this.relationsDir.getPath()) + File.separator + relation + File.separator + "mary." + relation), "ISO-8859-15"));
                continue;
            }
            if (pw == null) continue;
            pw.println(line);
            this.logger.debug(line);
        }
        if (pw != null) {
            pw.close();
        }
    }

    private AudioInputStream festivalSynthesise(File audioFile, String festVoiceCmd) throws IOException {
        String festvoxDirPath = String.valueOf(MaryProperties.maryBase()) + File.separator + "lib" + File.separator + "festvox" + File.separator;
        String festCmd = "(begin (set! argv nil) (load \"" + festvoxDirPath.replaceAll("\\\\", "/") + "make_utts\") " + festVoiceCmd + " " + "(set! label_dir \"" + this.festivalDir.getAbsolutePath().replaceAll("\\\\", "/") + "/relations\")" + "(set! utt_dir \"" + this.uttsDir.getAbsolutePath().replaceAll("\\\\", "/") + "\") " + "(set! utt1 (make_utt \"mary\" basic_relations)) " + "(utt.save utt1 \"" + this.uttsDir.getAbsolutePath().replaceAll("\\\\", "/") + "/mary.utt\") " + "(Wave_Synth utt1) " + "(utt.send.wave.client utt1) " + ")";
        return new SimpleFestivalClient().process(festCmd);
    }

    public static class SimpleFestivalClient {
        private Socket socket;
        private Logger logger;

        public SimpleFestivalClient() throws UnknownHostException, IOException {
            this("localhost", 1314);
        }

        public SimpleFestivalClient(String host, int port) throws UnknownHostException, IOException {
            this.socket = new Socket(host, port);
            this.logger = MaryUtils.getLogger("SimpleFestivalClient");
        }

        public AudioInputStream process(String request) throws IOException {
            PrintStream toFestival = new PrintStream(this.socket.getOutputStream());
            toFestival.println("(Parameter.set 'Wavefiletype 'riff)\n");
            this.logger.debug("Sending request to Festival:\n" + request);
            toFestival.println(request);
            toFestival.flush();
            AudioDestination audioDestination = MaryRuntimeUtils.createAudioDestination();
            int c = -1;
            InputStream fromFestival = this.socket.getInputStream();
            this.logger.debug("Trying to read from Festival...");
            while ((c = fromFestival.read()) != -1) {
                this.logger.debug("Read: " + (char)c);
                if (c != 87 || (c = fromFestival.read()) != 86 || (c = fromFestival.read()) != 10) continue;
                AudioReader readingThread = new AudioReader(fromFestival, audioDestination, "ft_StUfF_key");
                readingThread.start();
                boolean timeoutOccurred = false;
                do {
                    try {
                        readingThread.join(timeout);
                    }
                    catch (InterruptedException interruptedException) {
                        this.logger.warn("Unexpected interruption while waiting for reader thread.");
                    }
                    boolean bl = timeoutOccurred = System.currentTimeMillis() - readingThread.latestSeenTime() >= (long)timeout;
                } while (readingThread.isAlive() && !timeoutOccurred);
                if (!timeoutOccurred) {
                    try {
                        return audioDestination.convertToAudioInputStream();
                    }
                    catch (UnsupportedAudioFileException e) {
                        this.logger.warn("Cannot interpret audio data", e);
                        return null;
                    }
                }
                this.logger.warn("Timeout occurred");
            }
            return null;
        }
    }
}

