/*
 * Decompiled with CFR 0.152.
 */
package marytts.modules;

import java.io.IOException;
import marytts.modules.ExternalModule;
import marytts.util.MaryUtils;
import org.apache.log4j.Logger;

public class ProcessTimeoutDestroyer
extends Thread {
    private boolean listening = false;
    private boolean exit = false;
    private ExternalModule module = null;
    private Thread customer = null;
    private long timeLimit = 0L;
    private boolean didDestroy = false;
    private Logger logger;

    public ProcessTimeoutDestroyer(ExternalModule module) {
        this.module = module;
        this.logger = MaryUtils.getLogger(String.valueOf(module.name()) + " timer");
        this.setPriority(this.getPriority() + 1);
    }

    public synchronized Process getProcess() {
        return this.module.getProcess();
    }

    public synchronized long getTimeLimit() {
        return this.timeLimit;
    }

    private synchronized Thread getCustomer() {
        return this.customer;
    }

    private synchronized boolean shouldExit() {
        return this.exit;
    }

    public synchronized void setTimeLimit(long timeLimit) {
        if (timeLimit <= 0L) {
            return;
        }
        this.timeLimit = timeLimit;
        this.customer = Thread.currentThread();
        this.notify();
    }

    public synchronized void resetTimeLimit() {
        if (this.customer == Thread.currentThread()) {
            this.doResetTimeLimit();
            this.notify();
        }
    }

    private synchronized void doResetTimeLimit() {
        this.timeLimit = 0L;
        this.customer = null;
    }

    public synchronized void pleaseExit() {
        this.exit = true;
        this.notify();
    }

    private synchronized void doDestroy() {
        Process process = this.getProcess();
        if (process != null) {
            try {
                process.getOutputStream().close();
                process.getInputStream().close();
                process.getErrorStream().close();
            }
            catch (IOException e) {
                this.logger.info("Problems destroying process: ", e);
            }
            process.destroy();
        }
        this.didDestroy = true;
    }

    public synchronized boolean didDestroy() {
        boolean d = this.didDestroy;
        this.didDestroy = false;
        return d;
    }

    public void makeSureWereReady() {
        while (!this.listening) {
            Thread.yield();
        }
    }

    public synchronized void doWait(long time) {
        try {
            this.listening = true;
            this.wait(time);
        }
        catch (InterruptedException e) {
            this.logger.warn("Wait interrupted: ", e);
        }
    }

    @Override
    public void run() {
        while (true) {
            Thread orderingCustomer;
            if ((orderingCustomer = this.getCustomer()) == null) {
                this.logger.info("Waiting for timer request.");
            } else {
                this.logger.info("Received timer request: " + this.getTimeLimit() + " ms.");
            }
            this.doWait(this.getTimeLimit());
            if (this.shouldExit()) {
                this.logger.info("Exiting.");
                return;
            }
            if (this.getCustomer() == null) {
                this.logger.info("Normal operation, timer stopped.");
                continue;
            }
            if (this.getCustomer() != orderingCustomer) continue;
            this.logger.info("Timeout occurred. Destroying Process.");
            this.doDestroy();
            this.doResetTimeLimit();
        }
    }
}

