/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.codebook;

import java.util.Arrays;
import marytts.signalproc.adaptation.Context;
import marytts.signalproc.adaptation.VocalTractTransformationFunction;
import marytts.signalproc.adaptation.codebook.WeightedCodebook;
import marytts.signalproc.adaptation.codebook.WeightedCodebookLsfMatch;
import marytts.signalproc.adaptation.codebook.WeightedCodebookMapperParams;
import marytts.signalproc.analysis.distance.DistanceComputer;
import marytts.util.math.MathUtils;

public class WeightedCodebookMapper
extends VocalTractTransformationFunction {
    public WeightedCodebookMapperParams mapperParams;
    private double[] bestMatchDists;
    private int[] bestMatchIndices;
    private int[] sortedIndicesOfBestMatchIndices;
    double[] weights;
    public WeightedCodebookLsfMatch returnedMatch;

    public WeightedCodebookMapper(WeightedCodebookMapperParams mp) {
        this.mapperParams = new WeightedCodebookMapperParams(mp);
        if (this.mapperParams.numBestMatches > 0) {
            this.bestMatchDists = new double[this.mapperParams.numBestMatches];
            this.bestMatchIndices = new int[this.mapperParams.numBestMatches];
            this.sortedIndicesOfBestMatchIndices = new int[this.mapperParams.numBestMatches];
        } else {
            this.bestMatchDists = null;
            this.bestMatchIndices = null;
            this.sortedIndicesOfBestMatchIndices = null;
        }
        this.returnedMatch = null;
    }

    public int[] preselect(Context currentContext, WeightedCodebook codebook, boolean isMatchUsingTargetCodebook, int minimumCandidates) {
        int i;
        double[] scores = new double[codebook.header.totalEntries];
        int[] indices = new int[codebook.header.totalEntries];
        int total = 0;
        if (!isMatchUsingTargetCodebook) {
            i = 0;
            while (i < codebook.entries.length) {
                scores[i] = currentContext.matchScore(codebook.entries[i].sourceItem.context);
                ++i;
            }
        } else {
            i = 0;
            while (i < codebook.entries.length) {
                scores[i] = currentContext.matchScore(codebook.entries[i].targetItem.context);
                ++i;
            }
        }
        double[] possibleScores = currentContext.getPossibleScores();
        total = 0;
        i = 0;
        while (i < possibleScores.length) {
            int j = 0;
            while (j < scores.length) {
                if (scores[j] == possibleScores[i]) {
                    indices[total] = j;
                    ++total;
                }
                ++j;
            }
            if (total >= minimumCandidates) break;
            ++i;
        }
        if (total < minimumCandidates) {
            i = 0;
            while (i < codebook.entries.length) {
                indices[i] = i;
                ++i;
            }
        }
        return indices;
    }

    public WeightedCodebookLsfMatch transform(double[] inputLsfs, WeightedCodebook codebook, boolean isVocalTractMatchUsingTargetCodebook, int[] preselectedIndices) {
        double currentDist;
        int i;
        double worstBestDist = -1.0;
        int worstBestDistInd = 0;
        if (this.mapperParams.distanceMeasure == WeightedCodebookMapperParams.LSF_EUCLIDEAN_DISTANCE) {
            i = 0;
            while (i < preselectedIndices.length) {
                if (i >= this.mapperParams.numBestMatches) {
                    currentDist = !isVocalTractMatchUsingTargetCodebook ? DistanceComputer.getEuclideanDistance(inputLsfs, codebook.entries[preselectedIndices[i]].sourceItem.lsfs) : DistanceComputer.getEuclideanDistance(inputLsfs, codebook.entries[preselectedIndices[i]].targetItem.lsfs);
                    if (currentDist < worstBestDist) {
                        this.bestMatchDists[worstBestDistInd] = currentDist;
                        this.bestMatchIndices[worstBestDistInd] = preselectedIndices[i];
                        worstBestDistInd = MathUtils.getMaxIndex(this.bestMatchDists);
                        worstBestDist = this.bestMatchDists[worstBestDistInd];
                    }
                } else {
                    this.bestMatchDists[i] = !isVocalTractMatchUsingTargetCodebook ? DistanceComputer.getEuclideanDistance(inputLsfs, codebook.entries[preselectedIndices[i]].sourceItem.lsfs) : DistanceComputer.getEuclideanDistance(inputLsfs, codebook.entries[preselectedIndices[i]].targetItem.lsfs);
                    this.bestMatchIndices[i] = preselectedIndices[i];
                    if (i == 0 || this.bestMatchDists[i] > worstBestDist) {
                        worstBestDist = this.bestMatchDists[i];
                        worstBestDistInd = i;
                    }
                }
                ++i;
            }
        } else if (this.mapperParams.distanceMeasure == WeightedCodebookMapperParams.LSF_INVERSE_HARMONIC_DISTANCE) {
            i = 0;
            while (i < preselectedIndices.length) {
                if (i >= this.mapperParams.numBestMatches) {
                    currentDist = !isVocalTractMatchUsingTargetCodebook ? DistanceComputer.getLsfInverseHarmonicDistance(inputLsfs, codebook.entries[preselectedIndices[i]].sourceItem.lsfs, this.mapperParams.freqRange) : DistanceComputer.getLsfInverseHarmonicDistance(inputLsfs, codebook.entries[preselectedIndices[i]].targetItem.lsfs, this.mapperParams.freqRange);
                    if (currentDist < worstBestDist) {
                        this.bestMatchDists[worstBestDistInd] = currentDist;
                        this.bestMatchIndices[worstBestDistInd] = preselectedIndices[i];
                        worstBestDistInd = MathUtils.getMaxIndex(this.bestMatchDists);
                        worstBestDist = this.bestMatchDists[worstBestDistInd];
                    }
                } else {
                    this.bestMatchDists[i] = !isVocalTractMatchUsingTargetCodebook ? DistanceComputer.getLsfInverseHarmonicDistance(inputLsfs, codebook.entries[preselectedIndices[i]].sourceItem.lsfs, this.mapperParams.freqRange) : DistanceComputer.getLsfInverseHarmonicDistance(inputLsfs, codebook.entries[preselectedIndices[i]].targetItem.lsfs, this.mapperParams.freqRange);
                    this.bestMatchIndices[i] = preselectedIndices[i];
                    if (i == 0 || this.bestMatchDists[i] > worstBestDist) {
                        worstBestDist = this.bestMatchDists[i];
                        worstBestDistInd = i;
                    }
                }
                ++i;
            }
        } else if (this.mapperParams.distanceMeasure == WeightedCodebookMapperParams.LSF_INVERSE_HARMONIC_DISTANCE_SYMMETRIC) {
            i = 0;
            while (i < preselectedIndices.length) {
                if (i >= this.mapperParams.numBestMatches) {
                    currentDist = !isVocalTractMatchUsingTargetCodebook ? DistanceComputer.getLsfInverseHarmonicDistanceSymmetric(inputLsfs, codebook.entries[preselectedIndices[i]].sourceItem.lsfs, this.mapperParams.alphaForSymmetric, this.mapperParams.freqRange) : DistanceComputer.getLsfInverseHarmonicDistanceSymmetric(inputLsfs, codebook.entries[preselectedIndices[i]].targetItem.lsfs, this.mapperParams.alphaForSymmetric, this.mapperParams.freqRange);
                    if (currentDist < worstBestDist) {
                        this.bestMatchDists[worstBestDistInd] = currentDist;
                        this.bestMatchIndices[worstBestDistInd] = preselectedIndices[i];
                        worstBestDistInd = MathUtils.getMaxIndex(this.bestMatchDists);
                        worstBestDist = this.bestMatchDists[worstBestDistInd];
                    }
                } else {
                    this.bestMatchDists[i] = !isVocalTractMatchUsingTargetCodebook ? DistanceComputer.getLsfInverseHarmonicDistanceSymmetric(inputLsfs, codebook.entries[preselectedIndices[i]].sourceItem.lsfs, this.mapperParams.alphaForSymmetric, this.mapperParams.freqRange) : DistanceComputer.getLsfInverseHarmonicDistanceSymmetric(inputLsfs, codebook.entries[preselectedIndices[i]].targetItem.lsfs, this.mapperParams.alphaForSymmetric, this.mapperParams.freqRange);
                    this.bestMatchIndices[i] = preselectedIndices[i];
                    if (i == 0 || this.bestMatchDists[i] > worstBestDist) {
                        worstBestDist = this.bestMatchDists[i];
                        worstBestDistInd = i;
                    }
                }
                ++i;
            }
        } else if (this.mapperParams.distanceMeasure == WeightedCodebookMapperParams.LSF_MAHALANOBIS_DISTANCE) {
            double[][] inverseCovarianceMatrix = null;
            i = 0;
            while (i < preselectedIndices.length) {
                if (i >= this.mapperParams.numBestMatches) {
                    currentDist = !isVocalTractMatchUsingTargetCodebook ? DistanceComputer.getMahalanobisDistance(inputLsfs, codebook.entries[preselectedIndices[i]].sourceItem.lsfs, inverseCovarianceMatrix) : DistanceComputer.getMahalanobisDistance(inputLsfs, codebook.entries[preselectedIndices[i]].targetItem.lsfs, inverseCovarianceMatrix);
                    if (currentDist < worstBestDist) {
                        this.bestMatchDists[worstBestDistInd] = currentDist;
                        this.bestMatchIndices[worstBestDistInd] = preselectedIndices[i];
                        worstBestDistInd = MathUtils.getMaxIndex(this.bestMatchDists);
                        worstBestDist = this.bestMatchDists[worstBestDistInd];
                    }
                } else {
                    this.bestMatchDists[i] = !isVocalTractMatchUsingTargetCodebook ? DistanceComputer.getMahalanobisDistance(inputLsfs, codebook.entries[preselectedIndices[i]].sourceItem.lsfs, inverseCovarianceMatrix) : DistanceComputer.getMahalanobisDistance(inputLsfs, codebook.entries[preselectedIndices[i]].targetItem.lsfs, inverseCovarianceMatrix);
                    this.bestMatchIndices[i] = preselectedIndices[i];
                    if (i == 0 || this.bestMatchDists[i] > worstBestDist) {
                        worstBestDist = this.bestMatchDists[i];
                        worstBestDistInd = i;
                    }
                }
                ++i;
            }
        } else if (this.mapperParams.distanceMeasure == WeightedCodebookMapperParams.LSF_ABSOLUTE_VALUE_DISTANCE) {
            i = 0;
            while (i < preselectedIndices.length) {
                if (i >= this.mapperParams.numBestMatches) {
                    currentDist = !isVocalTractMatchUsingTargetCodebook ? DistanceComputer.getAbsoluteValueDistance(inputLsfs, codebook.entries[preselectedIndices[i]].sourceItem.lsfs) : DistanceComputer.getAbsoluteValueDistance(inputLsfs, codebook.entries[preselectedIndices[i]].targetItem.lsfs);
                    if (currentDist < worstBestDist) {
                        this.bestMatchDists[worstBestDistInd] = currentDist;
                        this.bestMatchIndices[worstBestDistInd] = preselectedIndices[i];
                        worstBestDistInd = MathUtils.getMaxIndex(this.bestMatchDists);
                        worstBestDist = this.bestMatchDists[worstBestDistInd];
                    }
                } else {
                    this.bestMatchDists[i] = !isVocalTractMatchUsingTargetCodebook ? DistanceComputer.getAbsoluteValueDistance(inputLsfs, codebook.entries[preselectedIndices[i]].sourceItem.lsfs) : DistanceComputer.getAbsoluteValueDistance(inputLsfs, codebook.entries[preselectedIndices[i]].targetItem.lsfs);
                    this.bestMatchIndices[i] = preselectedIndices[i];
                    if (i == 0 || this.bestMatchDists[i] > worstBestDist) {
                        worstBestDist = this.bestMatchDists[i];
                        worstBestDistInd = i;
                    }
                }
                ++i;
            }
        } else {
            return null;
        }
        this.sortedIndicesOfBestMatchIndices = MathUtils.quickSort(this.bestMatchDists, 0, Math.min(this.mapperParams.numBestMatches, codebook.header.totalEntries) - 1);
        this.weights = WeightedCodebookMapper.getWeights(this.bestMatchDists, Math.min(this.mapperParams.numBestMatches, codebook.header.totalEntries), this.mapperParams.weightingMethod, this.mapperParams.weightingSteepness);
        String strBestIndices = "";
        String strWeights = "";
        this.returnedMatch = new WeightedCodebookLsfMatch(Math.min(this.mapperParams.numBestMatches, codebook.header.totalEntries), this.mapperParams.lpOrder);
        Arrays.fill(this.returnedMatch.entry.sourceItem.lsfs, 0.0);
        Arrays.fill(this.returnedMatch.entry.targetItem.lsfs, 0.0);
        i = 0;
        while (i < this.returnedMatch.totalMatches) {
            this.returnedMatch.weights[i] = this.weights[i];
            this.returnedMatch.indices[i] = this.bestMatchIndices[this.sortedIndicesOfBestMatchIndices[i]];
            int j = 0;
            while (j < this.mapperParams.lpOrder) {
                int n = j;
                this.returnedMatch.entry.sourceItem.lsfs[n] = this.returnedMatch.entry.sourceItem.lsfs[n] + this.returnedMatch.weights[i] * codebook.entries[this.returnedMatch.indices[i]].sourceItem.lsfs[j];
                int n2 = j;
                this.returnedMatch.entry.targetItem.lsfs[n2] = this.returnedMatch.entry.targetItem.lsfs[n2] + this.returnedMatch.weights[i] * codebook.entries[this.returnedMatch.indices[i]].targetItem.lsfs[j];
                ++j;
            }
            strBestIndices = String.valueOf(strBestIndices) + String.valueOf(this.returnedMatch.indices[i]) + " ";
            strWeights = String.valueOf(strWeights) + String.valueOf(this.returnedMatch.weights[i]) + " ";
            if (i > 0 && this.weights[i] > this.weights[i - 1]) {
                System.out.println("Weight should be less than prev weight!!!");
            }
            ++i;
        }
        System.out.println("Best entry indices = " + strBestIndices + " with weights = " + strWeights);
        return this.returnedMatch;
    }

    public WeightedCodebookLsfMatch transform(double[] inputLsfs, WeightedCodebook codebook, boolean isVocalTractMatchUsingTargetCodebook) {
        int[] allIndices = new int[codebook.entries.length];
        int i = 0;
        while (i < allIndices.length) {
            allIndices[i] = i;
            ++i;
        }
        return this.transform(inputLsfs, codebook, isVocalTractMatchUsingTargetCodebook, allIndices);
    }

    public WeightedCodebookLsfMatch transformOld(double[] inputLsfs, WeightedCodebook codebook, boolean isVocalTractMatchUsingTargetCodebook) {
        double currentDist;
        int i;
        double worstBestDist = -1.0;
        int worstBestDistInd = 0;
        if (this.mapperParams.distanceMeasure == WeightedCodebookMapperParams.LSF_EUCLIDEAN_DISTANCE) {
            i = 0;
            while (i < codebook.header.totalEntries) {
                if (i >= this.mapperParams.numBestMatches) {
                    currentDist = !isVocalTractMatchUsingTargetCodebook ? DistanceComputer.getEuclideanDistance(inputLsfs, codebook.entries[i].sourceItem.lsfs) : DistanceComputer.getEuclideanDistance(inputLsfs, codebook.entries[i].targetItem.lsfs);
                    if (currentDist < worstBestDist) {
                        this.bestMatchDists[worstBestDistInd] = currentDist;
                        this.bestMatchIndices[worstBestDistInd] = i;
                        worstBestDistInd = MathUtils.getMaxIndex(this.bestMatchDists);
                        worstBestDist = this.bestMatchDists[worstBestDistInd];
                    }
                } else {
                    this.bestMatchDists[i] = !isVocalTractMatchUsingTargetCodebook ? DistanceComputer.getEuclideanDistance(inputLsfs, codebook.entries[i].sourceItem.lsfs) : DistanceComputer.getEuclideanDistance(inputLsfs, codebook.entries[i].targetItem.lsfs);
                    this.bestMatchIndices[i] = i;
                    if (i == 0 || this.bestMatchDists[i] > worstBestDist) {
                        worstBestDist = this.bestMatchDists[i];
                        worstBestDistInd = i;
                    }
                }
                ++i;
            }
        } else if (this.mapperParams.distanceMeasure == WeightedCodebookMapperParams.LSF_INVERSE_HARMONIC_DISTANCE) {
            i = 0;
            while (i < codebook.header.totalEntries) {
                if (i >= this.mapperParams.numBestMatches) {
                    currentDist = !isVocalTractMatchUsingTargetCodebook ? DistanceComputer.getLsfInverseHarmonicDistance(inputLsfs, codebook.entries[i].sourceItem.lsfs, this.mapperParams.freqRange) : DistanceComputer.getLsfInverseHarmonicDistance(inputLsfs, codebook.entries[i].targetItem.lsfs, this.mapperParams.freqRange);
                    if (currentDist < worstBestDist) {
                        this.bestMatchDists[worstBestDistInd] = currentDist;
                        this.bestMatchIndices[worstBestDistInd] = i;
                        worstBestDistInd = MathUtils.getMaxIndex(this.bestMatchDists);
                        worstBestDist = this.bestMatchDists[worstBestDistInd];
                    }
                } else {
                    this.bestMatchDists[i] = !isVocalTractMatchUsingTargetCodebook ? DistanceComputer.getLsfInverseHarmonicDistance(inputLsfs, codebook.entries[i].sourceItem.lsfs, this.mapperParams.freqRange) : DistanceComputer.getLsfInverseHarmonicDistance(inputLsfs, codebook.entries[i].targetItem.lsfs, this.mapperParams.freqRange);
                    this.bestMatchIndices[i] = i;
                    if (i == 0 || this.bestMatchDists[i] > worstBestDist) {
                        worstBestDist = this.bestMatchDists[i];
                        worstBestDistInd = i;
                    }
                }
                ++i;
            }
        } else if (this.mapperParams.distanceMeasure == WeightedCodebookMapperParams.LSF_INVERSE_HARMONIC_DISTANCE_SYMMETRIC) {
            i = 0;
            while (i < codebook.header.totalEntries) {
                if (i >= this.mapperParams.numBestMatches) {
                    currentDist = !isVocalTractMatchUsingTargetCodebook ? DistanceComputer.getLsfInverseHarmonicDistanceSymmetric(inputLsfs, codebook.entries[i].sourceItem.lsfs, this.mapperParams.alphaForSymmetric, this.mapperParams.freqRange) : DistanceComputer.getLsfInverseHarmonicDistanceSymmetric(inputLsfs, codebook.entries[i].targetItem.lsfs, this.mapperParams.alphaForSymmetric, this.mapperParams.freqRange);
                    if (currentDist < worstBestDist) {
                        this.bestMatchDists[worstBestDistInd] = currentDist;
                        this.bestMatchIndices[worstBestDistInd] = i;
                        worstBestDistInd = MathUtils.getMaxIndex(this.bestMatchDists);
                        worstBestDist = this.bestMatchDists[worstBestDistInd];
                    }
                } else {
                    this.bestMatchDists[i] = !isVocalTractMatchUsingTargetCodebook ? DistanceComputer.getLsfInverseHarmonicDistanceSymmetric(inputLsfs, codebook.entries[i].sourceItem.lsfs, this.mapperParams.alphaForSymmetric, this.mapperParams.freqRange) : DistanceComputer.getLsfInverseHarmonicDistanceSymmetric(inputLsfs, codebook.entries[i].targetItem.lsfs, this.mapperParams.alphaForSymmetric, this.mapperParams.freqRange);
                    this.bestMatchIndices[i] = i;
                    if (i == 0 || this.bestMatchDists[i] > worstBestDist) {
                        worstBestDist = this.bestMatchDists[i];
                        worstBestDistInd = i;
                    }
                }
                ++i;
            }
        } else if (this.mapperParams.distanceMeasure == WeightedCodebookMapperParams.LSF_MAHALANOBIS_DISTANCE) {
            double[][] inverseCovarianceMatrix = null;
            i = 0;
            while (i < codebook.header.totalEntries) {
                if (i >= this.mapperParams.numBestMatches) {
                    currentDist = !isVocalTractMatchUsingTargetCodebook ? DistanceComputer.getMahalanobisDistance(inputLsfs, codebook.entries[i].sourceItem.lsfs, inverseCovarianceMatrix) : DistanceComputer.getMahalanobisDistance(inputLsfs, codebook.entries[i].targetItem.lsfs, inverseCovarianceMatrix);
                    if (currentDist < worstBestDist) {
                        this.bestMatchDists[worstBestDistInd] = currentDist;
                        this.bestMatchIndices[worstBestDistInd] = i;
                        worstBestDistInd = MathUtils.getMaxIndex(this.bestMatchDists);
                        worstBestDist = this.bestMatchDists[worstBestDistInd];
                    }
                } else {
                    this.bestMatchDists[i] = !isVocalTractMatchUsingTargetCodebook ? DistanceComputer.getMahalanobisDistance(inputLsfs, codebook.entries[i].sourceItem.lsfs, inverseCovarianceMatrix) : DistanceComputer.getMahalanobisDistance(inputLsfs, codebook.entries[i].targetItem.lsfs, inverseCovarianceMatrix);
                    this.bestMatchIndices[i] = i;
                    if (i == 0 || this.bestMatchDists[i] > worstBestDist) {
                        worstBestDist = this.bestMatchDists[i];
                        worstBestDistInd = i;
                    }
                }
                ++i;
            }
        } else if (this.mapperParams.distanceMeasure == WeightedCodebookMapperParams.LSF_ABSOLUTE_VALUE_DISTANCE) {
            i = 0;
            while (i < codebook.header.totalEntries) {
                if (i >= this.mapperParams.numBestMatches) {
                    currentDist = !isVocalTractMatchUsingTargetCodebook ? DistanceComputer.getAbsoluteValueDistance(inputLsfs, codebook.entries[i].sourceItem.lsfs) : DistanceComputer.getAbsoluteValueDistance(inputLsfs, codebook.entries[i].targetItem.lsfs);
                    if (currentDist < worstBestDist) {
                        this.bestMatchDists[worstBestDistInd] = currentDist;
                        this.bestMatchIndices[worstBestDistInd] = i;
                        worstBestDistInd = MathUtils.getMaxIndex(this.bestMatchDists);
                        worstBestDist = this.bestMatchDists[worstBestDistInd];
                    }
                } else {
                    this.bestMatchDists[i] = !isVocalTractMatchUsingTargetCodebook ? DistanceComputer.getAbsoluteValueDistance(inputLsfs, codebook.entries[i].sourceItem.lsfs) : DistanceComputer.getAbsoluteValueDistance(inputLsfs, codebook.entries[i].targetItem.lsfs);
                    this.bestMatchIndices[i] = i;
                    if (i == 0 || this.bestMatchDists[i] > worstBestDist) {
                        worstBestDist = this.bestMatchDists[i];
                        worstBestDistInd = i;
                    }
                }
                ++i;
            }
        } else {
            return null;
        }
        this.sortedIndicesOfBestMatchIndices = MathUtils.quickSort(this.bestMatchDists, 0, Math.min(this.mapperParams.numBestMatches, codebook.header.totalEntries) - 1);
        this.weights = WeightedCodebookMapper.getWeights(this.bestMatchDists, Math.min(this.mapperParams.numBestMatches, codebook.header.totalEntries), this.mapperParams.weightingMethod, this.mapperParams.weightingSteepness);
        String strBestIndices = "";
        String strWeights = "";
        this.returnedMatch = new WeightedCodebookLsfMatch(Math.min(this.mapperParams.numBestMatches, codebook.header.totalEntries), this.mapperParams.lpOrder);
        Arrays.fill(this.returnedMatch.entry.sourceItem.lsfs, 0.0);
        Arrays.fill(this.returnedMatch.entry.targetItem.lsfs, 0.0);
        i = 0;
        while (i < this.returnedMatch.totalMatches) {
            this.returnedMatch.weights[i] = this.weights[i];
            this.returnedMatch.indices[i] = this.bestMatchIndices[this.sortedIndicesOfBestMatchIndices[i]];
            int j = 0;
            while (j < this.mapperParams.lpOrder) {
                int n = j;
                this.returnedMatch.entry.sourceItem.lsfs[n] = this.returnedMatch.entry.sourceItem.lsfs[n] + this.returnedMatch.weights[i] * codebook.entries[this.returnedMatch.indices[i]].sourceItem.lsfs[j];
                int n2 = j;
                this.returnedMatch.entry.targetItem.lsfs[n2] = this.returnedMatch.entry.targetItem.lsfs[n2] + this.returnedMatch.weights[i] * codebook.entries[this.returnedMatch.indices[i]].targetItem.lsfs[j];
                ++j;
            }
            strBestIndices = String.valueOf(strBestIndices) + String.valueOf(this.returnedMatch.indices[i]) + " ";
            strWeights = String.valueOf(strWeights) + String.valueOf(this.returnedMatch.weights[i]) + " ";
            if (i > 0 && this.weights[i] > this.weights[i - 1]) {
                System.out.println("Weight should be less than prev weight!!!");
            }
            ++i;
        }
        System.out.println("Best entry indices = " + strBestIndices + " with weights = " + strWeights);
        return this.returnedMatch;
    }

    public static double[] getWeights(double[] bestDistances, int numBestDistances, int weightingMethod, double steepness) {
        double[] outputWeights;
        block3: {
            block2: {
                outputWeights = MathUtils.normalizeToRange(bestDistances, numBestDistances, 0.0, Math.max(1.0, steepness + 1.0));
                if (weightingMethod != WeightedCodebookMapperParams.EXPONENTIAL_HALF_WINDOW) break block2;
                int i = 0;
                while (i < outputWeights.length) {
                    outputWeights[i] = Math.exp(-steepness * outputWeights[i]);
                    ++i;
                }
                break block3;
            }
            if (weightingMethod != WeightedCodebookMapperParams.TRIANGLE_HALF_WINDOW) break block3;
            int i = 0;
            while (i < outputWeights.length) {
                outputWeights[i] = 1.0 / Math.pow(outputWeights[i], (double)i * steepness) + (1.0 + steepness);
                ++i;
            }
        }
        return MathUtils.normalizeToSumUpTo(outputWeights, 1.0);
    }

    public static void main(String[] args) {
    }
}

