/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.gmm.jointgmm;

import java.io.IOException;
import java.util.Arrays;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.exceptions.MaryConfigurationException;
import marytts.machinelearning.ContextualGMMParams;
import marytts.machinelearning.GMM;
import marytts.machinelearning.GMMTrainer;
import marytts.machinelearning.GMMTrainerParams;
import marytts.modules.phonemiser.AllophoneSet;
import marytts.signalproc.adaptation.BaselineFeatureExtractor;
import marytts.signalproc.adaptation.BaselinePreprocessor;
import marytts.signalproc.adaptation.codebook.WeightedCodebook;
import marytts.signalproc.adaptation.codebook.WeightedCodebookFile;
import marytts.signalproc.adaptation.codebook.WeightedCodebookFileHeader;
import marytts.signalproc.adaptation.codebook.WeightedCodebookParallelTrainer;
import marytts.signalproc.adaptation.codebook.WeightedCodebookTrainerParams;
import marytts.signalproc.adaptation.gmm.jointgmm.JointGMM;
import marytts.signalproc.adaptation.gmm.jointgmm.JointGMMSet;
import marytts.signalproc.adaptation.gmm.jointgmm.JointGMMTrainer;
import marytts.signalproc.adaptation.gmm.jointgmm.JointGMMTrainerParams;
import marytts.signalproc.adaptation.outlier.TotalStandardDeviations;
import marytts.signalproc.adaptation.prosody.PitchMappingFile;
import marytts.util.io.FileUtils;
import marytts.util.string.StringUtils;

public class JointGMMParallelTrainer
extends JointGMMTrainer {
    protected WeightedCodebookParallelTrainer wcpTrainer;
    protected JointGMMTrainerParams jgParams;

    public JointGMMParallelTrainer(BaselinePreprocessor pp, BaselineFeatureExtractor fe, WeightedCodebookTrainerParams pa, JointGMMTrainerParams gp, ContextualGMMParams cg) {
        super(pp, fe, pa, gp, cg);
        this.wcpTrainer = new WeightedCodebookParallelTrainer(pp, fe, pa);
        this.jgParams = new JointGMMTrainerParams(gp);
    }

    public void run() {
        this.train();
    }

    public void train() {
        if (!FileUtils.exists(this.codebookTrainerParams.codebookFile)) {
            try {
                this.wcpTrainer.run();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (UnsupportedAudioFileException e) {
                e.printStackTrace();
            }
        }
        WeightedCodebookFile codebookFile = new WeightedCodebookFile(this.wcpTrainer.wcParams.codebookFile, WeightedCodebookFile.OPEN_FOR_READ);
        WeightedCodebook codebook = null;
        try {
            codebook = codebookFile.readCodebookFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (this.cgParams == null || this.cgParams.phoneClasses == null) {
            JointGMMSet gmmSet = null;
            GMM gmm = null;
            if (codebook != null) {
                int i;
                double[][] xy = null;
                boolean bFeatureExisting = false;
                if (this.codebookTrainerParams.codebookHeader.vocalTractFeature == BaselineFeatureExtractor.LSF_FEATURES) {
                    xy = new double[codebook.entries.length][2 * codebook.header.lsfParams.dimension];
                    i = 0;
                    while (i < codebook.entries.length) {
                        System.arraycopy(codebook.entries[i].sourceItem.lsfs, 0, xy[i], 0, codebook.header.lsfParams.dimension);
                        System.arraycopy(codebook.entries[i].targetItem.lsfs, 0, xy[i], codebook.header.lsfParams.dimension, codebook.header.lsfParams.dimension);
                        ++i;
                    }
                    bFeatureExisting = true;
                } else if (this.codebookTrainerParams.codebookHeader.vocalTractFeature == BaselineFeatureExtractor.MFCC_FEATURES_FROM_FILES) {
                    xy = new double[codebook.entries.length][2 * codebook.header.mfccParams.dimension];
                    i = 0;
                    while (i < codebook.entries.length) {
                        System.arraycopy(codebook.entries[i].sourceItem.mfccs, 0, xy[i], 0, codebook.header.mfccParams.dimension);
                        System.arraycopy(codebook.entries[i].targetItem.mfccs, 0, xy[i], codebook.header.mfccParams.dimension, codebook.header.mfccParams.dimension);
                        ++i;
                    }
                    bFeatureExisting = true;
                }
                assert (bFeatureExisting);
                GMMTrainer g = new GMMTrainer();
                gmmSet = new JointGMMSet(1, this.cgParams);
                gmm = g.train(xy, this.jgParams.gmmEMTrainerParams);
                if (this.codebookTrainerParams.codebookHeader.vocalTractFeature == BaselineFeatureExtractor.LSF_FEATURES) {
                    gmmSet.gmms[0] = new JointGMM(gmm, codebook.header.lsfParams);
                } else if (this.codebookTrainerParams.codebookHeader.vocalTractFeature == BaselineFeatureExtractor.MFCC_FEATURES_FROM_FILES) {
                    gmmSet.gmms[0] = new JointGMM(gmm, codebook.header.mfccParams);
                }
            }
            if (gmmSet != null) {
                gmmSet.write(this.jgParams.jointGMMFile);
            }
        } else {
            int i;
            double[][] xy = null;
            int[] totals = new int[this.cgParams.phoneClasses.length + 1];
            int[] classIndices = new int[codebook.entries.length];
            Arrays.fill(totals, 0);
            JointGMMSet gmmSet = new JointGMMSet(totals.length, this.cgParams);
            if (codebook != null) {
                i = 0;
                while (i < codebook.entries.length) {
                    classIndices[i] = this.cgParams.getClassIndex(codebook.entries[i].sourceItem.phn);
                    if (classIndices[i] < 0) {
                        classIndices[i] = totals.length - 1;
                    }
                    int n = classIndices[i];
                    totals[n] = totals[n] + 1;
                    ++i;
                }
            }
            int n = 0;
            while (n < totals.length) {
                GMM gmm = null;
                int count = 0;
                if (totals[n] > 0) {
                    if (this.codebookTrainerParams.codebookHeader.vocalTractFeature == BaselineFeatureExtractor.LSF_FEATURES) {
                        xy = new double[totals[n]][2 * codebook.header.lsfParams.dimension];
                        i = 0;
                        while (i < classIndices.length) {
                            if (count < totals[n]) {
                                if (classIndices[i] == n) {
                                    System.arraycopy(codebook.entries[i].sourceItem.lsfs, 0, xy[count], 0, codebook.header.lsfParams.dimension);
                                    System.arraycopy(codebook.entries[i].targetItem.lsfs, 0, xy[count], codebook.header.lsfParams.dimension, codebook.header.lsfParams.dimension);
                                    ++count;
                                }
                                ++i;
                                continue;
                            }
                            break;
                        }
                    } else if (this.codebookTrainerParams.codebookHeader.vocalTractFeature == BaselineFeatureExtractor.MFCC_FEATURES_FROM_FILES) {
                        xy = new double[totals[n]][2 * codebook.header.mfccParams.dimension];
                        i = 0;
                        while (i < classIndices.length) {
                            if (count < totals[n]) {
                                if (classIndices[i] == n) {
                                    System.arraycopy(codebook.entries[i].sourceItem.mfccs, 0, xy[count], 0, codebook.header.mfccParams.dimension);
                                    System.arraycopy(codebook.entries[i].targetItem.mfccs, 0, xy[count], codebook.header.mfccParams.dimension, codebook.header.mfccParams.dimension);
                                    ++count;
                                }
                                ++i;
                                continue;
                            }
                            break;
                        }
                    }
                    GMMTrainer g = new GMMTrainer();
                    gmm = g.train(xy, this.cgParams.classTrainerParams[n]);
                    if (n < totals.length - 1) {
                        gmm.info = "";
                        i = 0;
                        while (i < this.cgParams.phoneClasses[n].length - 1) {
                            gmm.info = String.valueOf(gmm.info) + this.cgParams.phoneClasses[n][i] + " ";
                            ++i;
                        }
                        gmm.info = String.valueOf(gmm.info) + this.cgParams.phoneClasses[n][this.cgParams.phoneClasses[n].length - 1];
                    } else {
                        gmm.info = "other";
                    }
                    if (this.codebookTrainerParams.codebookHeader.vocalTractFeature == BaselineFeatureExtractor.LSF_FEATURES) {
                        codebook.header.lsfParams.numfrm = totals[n];
                        gmmSet.gmms[n] = new JointGMM(gmm, codebook.header.lsfParams);
                    } else if (this.codebookTrainerParams.codebookHeader.vocalTractFeature == BaselineFeatureExtractor.MFCC_FEATURES_FROM_FILES) {
                        codebook.header.mfccParams.numfrm = totals[n];
                        gmmSet.gmms[n] = new JointGMM(gmm, codebook.header.mfccParams);
                    }
                }
                ++n;
            }
            if (gmmSet != null) {
                gmmSet.write(this.jgParams.jointGMMFile);
            }
        }
        System.out.println("Joint source-target GMM training completed...");
    }

    public static void main(String[] args) throws UnsupportedAudioFileException, IOException, MaryConfigurationException {
        JointGMMParallelTrainer.mainQuickTest2(args);
    }

    public static void mainIEEE_TASLP_2009_rap(String[] args) throws UnsupportedAudioFileException, IOException, MaryConfigurationException {
        int i;
        String wavBaseFolder = "D:/Oytun/Papers/IEEE_Transaction_VT/musicVC/final_gmm/";
        String sourceTag = "uch";
        String targetTag = "target";
        boolean isContextualGMMs = false;
        int contextClassificationType = -1;
        int[] numComponents = new int[]{32};
        BaselinePreprocessor pp = new BaselinePreprocessor();
        BaselineFeatureExtractor fe = new BaselineFeatureExtractor();
        WeightedCodebookTrainerParams pa = new WeightedCodebookTrainerParams();
        JointGMMTrainerParams gp = new JointGMMTrainerParams();
        ContextualGMMParams cg = null;
        pa.codebookHeader.codebookType = WeightedCodebookFileHeader.FRAMES;
        String method = "F";
        pa.codebookHeader.vocalTractFeature = BaselineFeatureExtractor.LSF_FEATURES;
        pa.codebookHeader.sourceTag = String.valueOf(sourceTag) + method;
        pa.codebookHeader.targetTag = String.valueOf(targetTag) + method;
        pa.trainingBaseFolder = wavBaseFolder;
        pa.sourceTrainingFolder = String.valueOf(wavBaseFolder) + sourceTag + "_train/";
        pa.targetTrainingFolder = String.valueOf(wavBaseFolder) + targetTag + "_train/";
        pa.indexMapFileExtension = ".imf";
        pa.codebookHeader.lsfParams.dimension = 0;
        pa.codebookHeader.lsfParams.preCoef = 0.97f;
        pa.codebookHeader.lsfParams.skipsize = 0.01f;
        pa.codebookHeader.lsfParams.winsize = 0.02f;
        pa.codebookHeader.lsfParams.windowType = 1;
        pa.codebookHeader.lsfParams.isBarkScaled = true;
        gp.vocalTractFeature = pa.codebookHeader.vocalTractFeature;
        gp.isContextualGMMs = isContextualGMMs;
        gp.gmmEMTrainerParams.totalComponents = numComponents[0];
        gp.gmmEMTrainerParams.isDiagonalCovariance = true;
        gp.gmmEMTrainerParams.kmeansMaxIterations = 200;
        gp.gmmEMTrainerParams.kmeansMinClusterChangePercent = 0.1;
        gp.gmmEMTrainerParams.kmeansMinSamplesInOneCluster = 50;
        gp.gmmEMTrainerParams.emMinIterations = 100;
        gp.gmmEMTrainerParams.emMaxIterations = 400;
        gp.gmmEMTrainerParams.isUpdateCovariances = true;
        gp.gmmEMTrainerParams.tinyLogLikelihoodChangePercent = 1.0E-5;
        gp.gmmEMTrainerParams.minCovarianceAllowed = 1.0E-4;
        gp.gmmEMTrainerParams.useNativeCLibTrainer = true;
        if (gp.isContextualGMMs) {
            GMMTrainerParams[] gmmParams = new GMMTrainerParams[numComponents.length];
            i = 0;
            while (i < numComponents.length) {
                gmmParams[i] = new GMMTrainerParams(gp.gmmEMTrainerParams);
                gmmParams[i].totalComponents = numComponents[i];
                ++i;
            }
            String phonemeSetFile = "D:/Mary TTS New/lib/modules/de/cap/phoneme-list-de.xml";
            cg = JointGMMParallelTrainer.getContextualGMMParams(phonemeSetFile, gmmParams, contextClassificationType);
        }
        String baseFile = String.valueOf(StringUtils.checkLastSlash(pa.trainingBaseFolder)) + pa.codebookHeader.sourceTag + "_X_" + pa.codebookHeader.targetTag;
        pa.codebookFile = String.valueOf(baseFile) + ".wcf";
        pa.pitchMappingFile = String.valueOf(baseFile) + PitchMappingFile.DEFAULT_EXTENSION;
        if (!isContextualGMMs) {
            gp.jointGMMFile = String.valueOf(baseFile) + "_" + String.valueOf(gp.gmmEMTrainerParams.totalComponents) + ".jgs";
        } else {
            gp.jointGMMFile = String.valueOf(baseFile) + "_context" + String.valueOf(contextClassificationType);
            i = 0;
            while (i < numComponents.length) {
                gp.jointGMMFile = String.valueOf(gp.jointGMMFile) + "_" + String.valueOf(numComponents[i]);
                ++i;
            }
            gp.jointGMMFile = String.valueOf(gp.jointGMMFile) + ".jgs";
        }
        pa.isForcedAnalysis = false;
        pa.codebookHeader.ptcParams.windowSizeInSeconds = 0.04;
        pa.codebookHeader.ptcParams.skipSizeInSeconds = 0.005;
        pa.codebookHeader.ptcParams.voicingThreshold = 0.3;
        pa.codebookHeader.ptcParams.isDoublingCheck = false;
        pa.codebookHeader.ptcParams.isHalvingCheck = false;
        pa.codebookHeader.ptcParams.minimumF0 = 40.0;
        pa.codebookHeader.ptcParams.maximumF0 = 400.0;
        pa.codebookHeader.ptcParams.centerClippingRatio = 0.3;
        pa.codebookHeader.ptcParams.cutOff1 = pa.codebookHeader.ptcParams.minimumF0 - 20.0;
        pa.codebookHeader.ptcParams.cutOff2 = pa.codebookHeader.ptcParams.maximumF0 + 200.0;
        pa.codebookHeader.energyParams.windowSizeInSeconds = 0.02;
        pa.codebookHeader.energyParams.skipSizeInSeconds = 0.01;
        TotalStandardDeviations tsd = new TotalStandardDeviations();
        tsd.lsf = 1.5;
        tsd.f0 = 1.0;
        tsd.duration = 1.0;
        tsd.energy = 2.0;
        pa.gaussianEliminatorParams.isActive = true;
        pa.gaussianEliminatorParams.isCheckLsfOutliers = true;
        pa.gaussianEliminatorParams.isEliminateTooSimilarLsf = false;
        pa.gaussianEliminatorParams.isCheckF0Outliers = true;
        pa.gaussianEliminatorParams.isCheckDurationOutliers = true;
        pa.gaussianEliminatorParams.isCheckEnergyOutliers = true;
        pa.gaussianEliminatorParams.totalStandardDeviations = new TotalStandardDeviations(tsd);
        pa.kmeansEliminatorParams.isActive = false;
        pa.kmeansEliminatorParams.eliminationAlgorithm = 2;
        pa.kmeansEliminatorParams.distanceType = 3;
        pa.kmeansEliminatorParams.isGlobalVariance = true;
        pa.kmeansEliminatorParams.isSeparateClustering = false;
        tsd.general = 0.1;
        pa.kmeansEliminatorParams.numClusters = 30;
        tsd.lsf = 1.0;
        tsd.f0 = 1.0;
        tsd.duration = 1.0;
        tsd.energy = 1.0;
        pa.kmeansEliminatorParams.numClustersLsf = 30;
        pa.kmeansEliminatorParams.numClustersF0 = 50;
        pa.kmeansEliminatorParams.numClustersDuration = 5;
        pa.kmeansEliminatorParams.numClustersEnergy = 5;
        pa.kmeansEliminatorParams.isCheckLsfOutliers = false;
        pa.kmeansEliminatorParams.isCheckF0Outliers = false;
        pa.kmeansEliminatorParams.isCheckDurationOutliers = false;
        pa.kmeansEliminatorParams.isCheckEnergyOutliers = false;
        pa.kmeansEliminatorParams.totalStandardDeviations = new TotalStandardDeviations(tsd);
        JointGMMParallelTrainer t = new JointGMMParallelTrainer(pp, fe, pa, gp, cg);
        t.run();
    }

    public static void mainHmmVoiceConversion(String[] args) throws UnsupportedAudioFileException, IOException, MaryConfigurationException {
        int i;
        String wavBaseFolder = "D:/Oytun/DFKI/voices/hmmVoiceConversionTest2/";
        String sourceTag = "hmmSource_gv";
        String targetTag = "origTarget";
        int numTrainingFiles = 1092;
        boolean isContextualGMMs = false;
        int contextClassificationType = -1;
        int[] numComponents = new int[]{128};
        BaselinePreprocessor pp = new BaselinePreprocessor();
        BaselineFeatureExtractor fe = new BaselineFeatureExtractor();
        WeightedCodebookTrainerParams pa = new WeightedCodebookTrainerParams();
        JointGMMTrainerParams gp = new JointGMMTrainerParams();
        ContextualGMMParams cg = null;
        pa.codebookHeader.codebookType = WeightedCodebookFileHeader.FRAMES;
        String method = "F";
        pa.codebookHeader.vocalTractFeature = BaselineFeatureExtractor.LSF_FEATURES;
        pa.codebookHeader.sourceTag = String.valueOf(sourceTag) + method;
        pa.codebookHeader.targetTag = String.valueOf(targetTag) + method;
        pa.trainingBaseFolder = String.valueOf(wavBaseFolder) + "output/" + sourceTag + "2" + targetTag;
        pa.sourceTrainingFolder = String.valueOf(wavBaseFolder) + sourceTag + "/train_" + String.valueOf(numTrainingFiles) + "/";
        pa.targetTrainingFolder = String.valueOf(wavBaseFolder) + targetTag + "/train_" + String.valueOf(numTrainingFiles) + "/";
        pa.indexMapFileExtension = ".imf";
        pa.codebookHeader.lsfParams.dimension = 0;
        pa.codebookHeader.lsfParams.preCoef = 0.97f;
        pa.codebookHeader.lsfParams.skipsize = 0.01f;
        pa.codebookHeader.lsfParams.winsize = 0.02f;
        pa.codebookHeader.lsfParams.windowType = 1;
        gp.vocalTractFeature = pa.codebookHeader.vocalTractFeature;
        gp.isContextualGMMs = isContextualGMMs;
        gp.gmmEMTrainerParams.totalComponents = numComponents[0];
        gp.gmmEMTrainerParams.isDiagonalCovariance = true;
        gp.gmmEMTrainerParams.kmeansMaxIterations = 200;
        gp.gmmEMTrainerParams.kmeansMinClusterChangePercent = 0.1;
        gp.gmmEMTrainerParams.kmeansMinSamplesInOneCluster = 50;
        gp.gmmEMTrainerParams.emMinIterations = 100;
        gp.gmmEMTrainerParams.emMaxIterations = 400;
        gp.gmmEMTrainerParams.isUpdateCovariances = true;
        gp.gmmEMTrainerParams.tinyLogLikelihoodChangePercent = 1.0E-5;
        gp.gmmEMTrainerParams.minCovarianceAllowed = 1.0E-4;
        gp.gmmEMTrainerParams.useNativeCLibTrainer = true;
        if (gp.isContextualGMMs) {
            GMMTrainerParams[] gmmParams = new GMMTrainerParams[numComponents.length];
            i = 0;
            while (i < numComponents.length) {
                gmmParams[i] = new GMMTrainerParams(gp.gmmEMTrainerParams);
                gmmParams[i].totalComponents = numComponents[i];
                ++i;
            }
            String phoneSetFile = "D:/Mary TTS New/lib/modules/de/cap/phone-list-de.xml";
            cg = JointGMMParallelTrainer.getContextualGMMParams(phoneSetFile, gmmParams, contextClassificationType);
        }
        String baseFile = String.valueOf(StringUtils.checkLastSlash(pa.trainingBaseFolder)) + pa.codebookHeader.sourceTag + "_X_" + pa.codebookHeader.targetTag;
        pa.codebookFile = String.valueOf(baseFile) + "_" + String.valueOf(numTrainingFiles) + ".wcf";
        pa.pitchMappingFile = String.valueOf(baseFile) + "_" + String.valueOf(numTrainingFiles) + PitchMappingFile.DEFAULT_EXTENSION;
        if (!isContextualGMMs) {
            gp.jointGMMFile = String.valueOf(baseFile) + "_" + String.valueOf(numTrainingFiles) + "_" + String.valueOf(gp.gmmEMTrainerParams.totalComponents) + ".jgs";
        } else {
            gp.jointGMMFile = String.valueOf(baseFile) + "_" + String.valueOf(numTrainingFiles) + "_context" + String.valueOf(contextClassificationType);
            i = 0;
            while (i < numComponents.length) {
                gp.jointGMMFile = String.valueOf(gp.jointGMMFile) + "_" + String.valueOf(numComponents[i]);
                ++i;
            }
            gp.jointGMMFile = String.valueOf(gp.jointGMMFile) + ".jgs";
        }
        pa.isForcedAnalysis = false;
        pa.codebookHeader.ptcParams.windowSizeInSeconds = 0.04;
        pa.codebookHeader.ptcParams.skipSizeInSeconds = 0.005;
        pa.codebookHeader.ptcParams.voicingThreshold = 0.3;
        pa.codebookHeader.ptcParams.isDoublingCheck = false;
        pa.codebookHeader.ptcParams.isHalvingCheck = false;
        pa.codebookHeader.ptcParams.minimumF0 = 40.0;
        pa.codebookHeader.ptcParams.maximumF0 = 400.0;
        pa.codebookHeader.ptcParams.centerClippingRatio = 0.3;
        pa.codebookHeader.ptcParams.cutOff1 = pa.codebookHeader.ptcParams.minimumF0 - 20.0;
        pa.codebookHeader.ptcParams.cutOff2 = pa.codebookHeader.ptcParams.maximumF0 + 200.0;
        pa.codebookHeader.energyParams.windowSizeInSeconds = 0.02;
        pa.codebookHeader.energyParams.skipSizeInSeconds = 0.01;
        TotalStandardDeviations tsd = new TotalStandardDeviations();
        tsd.lsf = 1.5;
        tsd.f0 = 1.0;
        tsd.duration = 1.0;
        tsd.energy = 2.0;
        pa.gaussianEliminatorParams.isActive = true;
        pa.gaussianEliminatorParams.isCheckLsfOutliers = true;
        pa.gaussianEliminatorParams.isEliminateTooSimilarLsf = false;
        pa.gaussianEliminatorParams.isCheckF0Outliers = true;
        pa.gaussianEliminatorParams.isCheckDurationOutliers = true;
        pa.gaussianEliminatorParams.isCheckEnergyOutliers = true;
        pa.gaussianEliminatorParams.totalStandardDeviations = new TotalStandardDeviations(tsd);
        pa.kmeansEliminatorParams.isActive = false;
        pa.kmeansEliminatorParams.eliminationAlgorithm = 2;
        pa.kmeansEliminatorParams.distanceType = 3;
        pa.kmeansEliminatorParams.isGlobalVariance = true;
        pa.kmeansEliminatorParams.isSeparateClustering = false;
        tsd.general = 0.1;
        pa.kmeansEliminatorParams.numClusters = 30;
        tsd.lsf = 1.0;
        tsd.f0 = 1.0;
        tsd.duration = 1.0;
        tsd.energy = 1.0;
        pa.kmeansEliminatorParams.numClustersLsf = 30;
        pa.kmeansEliminatorParams.numClustersF0 = 50;
        pa.kmeansEliminatorParams.numClustersDuration = 5;
        pa.kmeansEliminatorParams.numClustersEnergy = 5;
        pa.kmeansEliminatorParams.isCheckLsfOutliers = false;
        pa.kmeansEliminatorParams.isCheckF0Outliers = false;
        pa.kmeansEliminatorParams.isCheckDurationOutliers = false;
        pa.kmeansEliminatorParams.isCheckEnergyOutliers = false;
        pa.kmeansEliminatorParams.totalStandardDeviations = new TotalStandardDeviations(tsd);
        JointGMMParallelTrainer t = new JointGMMParallelTrainer(pp, fe, pa, gp, cg);
        t.run();
    }

    public static void mainInterspeech2008(String[] args) throws UnsupportedAudioFileException, IOException, MaryConfigurationException {
        String emotion = "angry";
        String method = "F";
        int numTrainingFiles = 200;
        boolean isContextualGMMs = false;
        int contextClassificationType = -1;
        int[] numComponents = new int[]{40};
        JointGMMParallelTrainer.mainParametric(numTrainingFiles, numComponents, isContextualGMMs, contextClassificationType, "neutral", emotion, method);
    }

    public static void mainParametric(int numTrainingFiles, int[] numComponents, boolean isContextualGMMs, int contextClassificationType, String sourceTag, String targetTag, String method) throws UnsupportedAudioFileException, IOException, MaryConfigurationException {
        int i;
        BaselinePreprocessor pp = new BaselinePreprocessor();
        BaselineFeatureExtractor fe = new BaselineFeatureExtractor();
        WeightedCodebookTrainerParams pa = new WeightedCodebookTrainerParams();
        JointGMMTrainerParams gp = new JointGMMTrainerParams();
        ContextualGMMParams cg = null;
        pa.codebookHeader.codebookType = WeightedCodebookFileHeader.FRAMES;
        pa.codebookHeader.sourceTag = String.valueOf(sourceTag) + method;
        pa.codebookHeader.targetTag = String.valueOf(targetTag) + method;
        pa.trainingBaseFolder = "D:/Oytun/DFKI/voices/Interspeech08_out2/" + sourceTag + "2" + targetTag;
        pa.sourceTrainingFolder = "D:/Oytun/DFKI/voices/Interspeech08/" + sourceTag + "/train_" + String.valueOf(numTrainingFiles);
        pa.targetTrainingFolder = "D:/Oytun/DFKI/voices/Interspeech08/" + targetTag + "/train_" + String.valueOf(numTrainingFiles);
        pa.indexMapFileExtension = ".imf";
        pa.codebookHeader.lsfParams.dimension = 0;
        pa.codebookHeader.lsfParams.preCoef = 0.97f;
        pa.codebookHeader.lsfParams.skipsize = 0.01f;
        pa.codebookHeader.lsfParams.winsize = 0.02f;
        pa.codebookHeader.lsfParams.windowType = 1;
        gp.isContextualGMMs = isContextualGMMs;
        gp.gmmEMTrainerParams.totalComponents = numComponents[0];
        gp.gmmEMTrainerParams.isDiagonalCovariance = true;
        gp.gmmEMTrainerParams.kmeansMaxIterations = 200;
        gp.gmmEMTrainerParams.kmeansMinClusterChangePercent = 0.1;
        gp.gmmEMTrainerParams.kmeansMinSamplesInOneCluster = 50;
        gp.gmmEMTrainerParams.emMinIterations = 200;
        gp.gmmEMTrainerParams.emMaxIterations = 2000;
        gp.gmmEMTrainerParams.isUpdateCovariances = true;
        gp.gmmEMTrainerParams.tinyLogLikelihoodChangePercent = 1.0E-5;
        gp.gmmEMTrainerParams.minCovarianceAllowed = 1.0E-4;
        gp.gmmEMTrainerParams.useNativeCLibTrainer = true;
        if (gp.isContextualGMMs) {
            GMMTrainerParams[] gmmParams = new GMMTrainerParams[numComponents.length];
            i = 0;
            while (i < numComponents.length) {
                gmmParams[i] = new GMMTrainerParams(gp.gmmEMTrainerParams);
                gmmParams[i].totalComponents = numComponents[i];
                ++i;
            }
            String phoneSetFile = "D:/Mary TTS New/lib/modules/de/cap/phone-list-de.xml";
            cg = JointGMMParallelTrainer.getContextualGMMParams(phoneSetFile, gmmParams, contextClassificationType);
        }
        String baseFile = String.valueOf(StringUtils.checkLastSlash(pa.trainingBaseFolder)) + pa.codebookHeader.sourceTag + "_X_" + pa.codebookHeader.targetTag;
        pa.codebookFile = String.valueOf(baseFile) + "_" + String.valueOf(numTrainingFiles) + ".wcf";
        pa.pitchMappingFile = String.valueOf(baseFile) + "_" + String.valueOf(numTrainingFiles) + PitchMappingFile.DEFAULT_EXTENSION;
        if (!isContextualGMMs) {
            gp.jointGMMFile = String.valueOf(baseFile) + "_" + String.valueOf(numTrainingFiles) + "_" + String.valueOf(gp.gmmEMTrainerParams.totalComponents) + ".jgs";
        } else {
            gp.jointGMMFile = String.valueOf(baseFile) + "_" + String.valueOf(numTrainingFiles) + "_context" + String.valueOf(contextClassificationType);
            i = 0;
            while (i < numComponents.length) {
                gp.jointGMMFile = String.valueOf(gp.jointGMMFile) + "_" + String.valueOf(numComponents[i]);
                ++i;
            }
            gp.jointGMMFile = String.valueOf(gp.jointGMMFile) + ".jgs";
        }
        pa.isForcedAnalysis = false;
        pa.codebookHeader.ptcParams.windowSizeInSeconds = 0.04;
        pa.codebookHeader.ptcParams.skipSizeInSeconds = 0.005;
        pa.codebookHeader.ptcParams.voicingThreshold = 0.3;
        pa.codebookHeader.ptcParams.isDoublingCheck = false;
        pa.codebookHeader.ptcParams.isHalvingCheck = false;
        pa.codebookHeader.ptcParams.minimumF0 = 40.0;
        pa.codebookHeader.ptcParams.maximumF0 = 400.0;
        pa.codebookHeader.ptcParams.centerClippingRatio = 0.3;
        pa.codebookHeader.ptcParams.cutOff1 = pa.codebookHeader.ptcParams.minimumF0 - 20.0;
        pa.codebookHeader.ptcParams.cutOff2 = pa.codebookHeader.ptcParams.maximumF0 + 200.0;
        pa.codebookHeader.energyParams.windowSizeInSeconds = 0.02;
        pa.codebookHeader.energyParams.skipSizeInSeconds = 0.01;
        TotalStandardDeviations tsd = new TotalStandardDeviations();
        tsd.lsf = 1.5;
        tsd.f0 = 1.0;
        tsd.duration = 1.0;
        tsd.energy = 2.0;
        pa.gaussianEliminatorParams.isActive = true;
        pa.gaussianEliminatorParams.isCheckLsfOutliers = true;
        pa.gaussianEliminatorParams.isEliminateTooSimilarLsf = true;
        pa.gaussianEliminatorParams.isCheckF0Outliers = true;
        pa.gaussianEliminatorParams.isCheckDurationOutliers = true;
        pa.gaussianEliminatorParams.isCheckEnergyOutliers = true;
        pa.gaussianEliminatorParams.totalStandardDeviations = new TotalStandardDeviations(tsd);
        pa.kmeansEliminatorParams.isActive = true;
        pa.kmeansEliminatorParams.eliminationAlgorithm = 2;
        pa.kmeansEliminatorParams.distanceType = 3;
        pa.kmeansEliminatorParams.isGlobalVariance = true;
        pa.kmeansEliminatorParams.isSeparateClustering = false;
        tsd.general = 0.1;
        pa.kmeansEliminatorParams.numClusters = 30;
        tsd.lsf = 1.0;
        tsd.f0 = 1.0;
        tsd.duration = 1.0;
        tsd.energy = 1.0;
        pa.kmeansEliminatorParams.numClustersLsf = 30;
        pa.kmeansEliminatorParams.numClustersF0 = 50;
        pa.kmeansEliminatorParams.numClustersDuration = 5;
        pa.kmeansEliminatorParams.numClustersEnergy = 5;
        pa.kmeansEliminatorParams.isCheckLsfOutliers = true;
        pa.kmeansEliminatorParams.isCheckF0Outliers = false;
        pa.kmeansEliminatorParams.isCheckDurationOutliers = false;
        pa.kmeansEliminatorParams.isCheckEnergyOutliers = false;
        pa.labelsToExcludeFromTraining = new String[1];
        pa.labelsToExcludeFromTraining[0] = "_";
        pa.kmeansEliminatorParams.totalStandardDeviations = new TotalStandardDeviations(tsd);
        JointGMMParallelTrainer t = new JointGMMParallelTrainer(pp, fe, pa, gp, cg);
        t.run();
    }

    public static void mainQuickTest(String[] args) throws UnsupportedAudioFileException, IOException, MaryConfigurationException {
        int i;
        String wavBaseFolder = "D:/quickTest/";
        String sourceTag = "source";
        String targetTag = "target";
        int numTrainingFiles = 50;
        boolean isContextualGMMs = false;
        int contextClassificationType = -1;
        int[] numComponents = new int[]{10};
        BaselinePreprocessor pp = new BaselinePreprocessor();
        BaselineFeatureExtractor fe = new BaselineFeatureExtractor();
        WeightedCodebookTrainerParams pa = new WeightedCodebookTrainerParams();
        JointGMMTrainerParams gp = new JointGMMTrainerParams();
        ContextualGMMParams cg = null;
        pa.codebookHeader.codebookType = WeightedCodebookFileHeader.FRAMES;
        String method = "F";
        pa.codebookHeader.vocalTractFeature = BaselineFeatureExtractor.LSF_FEATURES;
        pa.codebookHeader.sourceTag = String.valueOf(sourceTag) + method;
        pa.codebookHeader.targetTag = String.valueOf(targetTag) + method;
        pa.trainingBaseFolder = String.valueOf(wavBaseFolder) + "output/" + sourceTag + "2" + targetTag;
        pa.sourceTrainingFolder = String.valueOf(wavBaseFolder) + sourceTag + "/train_" + String.valueOf(numTrainingFiles) + "/";
        pa.targetTrainingFolder = String.valueOf(wavBaseFolder) + targetTag + "/train_" + String.valueOf(numTrainingFiles) + "/";
        pa.indexMapFileExtension = ".imf";
        pa.codebookHeader.lsfParams.dimension = 0;
        pa.codebookHeader.lsfParams.preCoef = 0.97f;
        pa.codebookHeader.lsfParams.skipsize = 0.01f;
        pa.codebookHeader.lsfParams.winsize = 0.02f;
        pa.codebookHeader.lsfParams.windowType = 1;
        gp.vocalTractFeature = pa.codebookHeader.vocalTractFeature;
        gp.isContextualGMMs = isContextualGMMs;
        gp.gmmEMTrainerParams.totalComponents = numComponents[0];
        gp.gmmEMTrainerParams.isDiagonalCovariance = true;
        gp.gmmEMTrainerParams.kmeansMaxIterations = 200;
        gp.gmmEMTrainerParams.kmeansMinClusterChangePercent = 0.1;
        gp.gmmEMTrainerParams.kmeansMinSamplesInOneCluster = 50;
        gp.gmmEMTrainerParams.emMinIterations = 100;
        gp.gmmEMTrainerParams.emMaxIterations = 400;
        gp.gmmEMTrainerParams.isUpdateCovariances = true;
        gp.gmmEMTrainerParams.tinyLogLikelihoodChangePercent = 1.0E-5;
        gp.gmmEMTrainerParams.minCovarianceAllowed = 1.0E-4;
        gp.gmmEMTrainerParams.useNativeCLibTrainer = true;
        if (gp.isContextualGMMs) {
            GMMTrainerParams[] gmmParams = new GMMTrainerParams[numComponents.length];
            i = 0;
            while (i < numComponents.length) {
                gmmParams[i] = new GMMTrainerParams(gp.gmmEMTrainerParams);
                gmmParams[i].totalComponents = numComponents[i];
                ++i;
            }
            String phoneSetFile = "D:/Mary TTS New/lib/modules/de/cap/phone-list-de.xml";
            cg = JointGMMParallelTrainer.getContextualGMMParams(phoneSetFile, gmmParams, contextClassificationType);
        }
        String baseFile = String.valueOf(StringUtils.checkLastSlash(pa.trainingBaseFolder)) + pa.codebookHeader.sourceTag + "_X_" + pa.codebookHeader.targetTag;
        pa.codebookFile = String.valueOf(baseFile) + "_" + String.valueOf(numTrainingFiles) + ".wcf";
        pa.pitchMappingFile = String.valueOf(baseFile) + "_" + String.valueOf(numTrainingFiles) + PitchMappingFile.DEFAULT_EXTENSION;
        if (!isContextualGMMs) {
            gp.jointGMMFile = String.valueOf(baseFile) + "_" + String.valueOf(numTrainingFiles) + "_" + String.valueOf(gp.gmmEMTrainerParams.totalComponents) + ".jgs";
        } else {
            gp.jointGMMFile = String.valueOf(baseFile) + "_" + String.valueOf(numTrainingFiles) + "_context" + String.valueOf(contextClassificationType);
            i = 0;
            while (i < numComponents.length) {
                gp.jointGMMFile = String.valueOf(gp.jointGMMFile) + "_" + String.valueOf(numComponents[i]);
                ++i;
            }
            gp.jointGMMFile = String.valueOf(gp.jointGMMFile) + ".jgs";
        }
        pa.isForcedAnalysis = false;
        pa.codebookHeader.ptcParams.windowSizeInSeconds = 0.04;
        pa.codebookHeader.ptcParams.skipSizeInSeconds = 0.005;
        pa.codebookHeader.ptcParams.voicingThreshold = 0.3;
        pa.codebookHeader.ptcParams.isDoublingCheck = false;
        pa.codebookHeader.ptcParams.isHalvingCheck = false;
        pa.codebookHeader.ptcParams.minimumF0 = 40.0;
        pa.codebookHeader.ptcParams.maximumF0 = 400.0;
        pa.codebookHeader.ptcParams.centerClippingRatio = 0.3;
        pa.codebookHeader.ptcParams.cutOff1 = pa.codebookHeader.ptcParams.minimumF0 - 20.0;
        pa.codebookHeader.ptcParams.cutOff2 = pa.codebookHeader.ptcParams.maximumF0 + 200.0;
        pa.codebookHeader.energyParams.windowSizeInSeconds = 0.02;
        pa.codebookHeader.energyParams.skipSizeInSeconds = 0.01;
        TotalStandardDeviations tsd = new TotalStandardDeviations();
        tsd.lsf = 1.5;
        tsd.f0 = 1.0;
        tsd.duration = 1.0;
        tsd.energy = 2.0;
        pa.gaussianEliminatorParams.isActive = true;
        pa.gaussianEliminatorParams.isCheckLsfOutliers = true;
        pa.gaussianEliminatorParams.isEliminateTooSimilarLsf = false;
        pa.gaussianEliminatorParams.isCheckF0Outliers = true;
        pa.gaussianEliminatorParams.isCheckDurationOutliers = true;
        pa.gaussianEliminatorParams.isCheckEnergyOutliers = true;
        pa.gaussianEliminatorParams.totalStandardDeviations = new TotalStandardDeviations(tsd);
        pa.kmeansEliminatorParams.isActive = false;
        pa.kmeansEliminatorParams.eliminationAlgorithm = 2;
        pa.kmeansEliminatorParams.distanceType = 3;
        pa.kmeansEliminatorParams.isGlobalVariance = true;
        pa.kmeansEliminatorParams.isSeparateClustering = false;
        tsd.general = 0.1;
        pa.kmeansEliminatorParams.numClusters = 30;
        tsd.lsf = 1.0;
        tsd.f0 = 1.0;
        tsd.duration = 1.0;
        tsd.energy = 1.0;
        pa.kmeansEliminatorParams.numClustersLsf = 30;
        pa.kmeansEliminatorParams.numClustersF0 = 50;
        pa.kmeansEliminatorParams.numClustersDuration = 5;
        pa.kmeansEliminatorParams.numClustersEnergy = 5;
        pa.kmeansEliminatorParams.isCheckLsfOutliers = false;
        pa.kmeansEliminatorParams.isCheckF0Outliers = false;
        pa.kmeansEliminatorParams.isCheckDurationOutliers = false;
        pa.kmeansEliminatorParams.isCheckEnergyOutliers = false;
        pa.kmeansEliminatorParams.totalStandardDeviations = new TotalStandardDeviations(tsd);
        pa.labelsToExcludeFromTraining = new String[1];
        pa.labelsToExcludeFromTraining[0] = "_";
        JointGMMParallelTrainer t = new JointGMMParallelTrainer(pp, fe, pa, gp, cg);
        t.run();
    }

    public static void mainQuickTest2(String[] args) throws UnsupportedAudioFileException, IOException, MaryConfigurationException {
        int i;
        String wavBaseFolder = "/project/mary/marcela/VoiceConversion/Neutral-Spike-Conversion/";
        String sourceTag = "source";
        String targetTag = "target";
        int numTrainingFiles = 99;
        boolean isContextualGMMs = false;
        int contextClassificationType = -1;
        int[] numComponents = new int[]{10};
        BaselinePreprocessor pp = new BaselinePreprocessor();
        BaselineFeatureExtractor fe = new BaselineFeatureExtractor();
        WeightedCodebookTrainerParams pa = new WeightedCodebookTrainerParams();
        JointGMMTrainerParams gp = new JointGMMTrainerParams();
        ContextualGMMParams cg = null;
        pa.codebookHeader.codebookType = WeightedCodebookFileHeader.FRAMES;
        String method = "F";
        pa.codebookHeader.vocalTractFeature = BaselineFeatureExtractor.LSF_FEATURES;
        pa.codebookHeader.sourceTag = String.valueOf(sourceTag) + method;
        pa.codebookHeader.targetTag = String.valueOf(targetTag) + method;
        pa.trainingBaseFolder = String.valueOf(wavBaseFolder) + "output/" + sourceTag + "2" + targetTag;
        pa.sourceTrainingFolder = String.valueOf(wavBaseFolder) + sourceTag + "/train_" + String.valueOf(numTrainingFiles) + "/";
        pa.targetTrainingFolder = String.valueOf(wavBaseFolder) + targetTag + "/train_" + String.valueOf(numTrainingFiles) + "/";
        pa.indexMapFileExtension = ".imf";
        pa.codebookHeader.lsfParams.dimension = 0;
        pa.codebookHeader.lsfParams.preCoef = 0.97f;
        pa.codebookHeader.lsfParams.skipsize = 0.01f;
        pa.codebookHeader.lsfParams.winsize = 0.02f;
        pa.codebookHeader.lsfParams.windowType = 1;
        gp.vocalTractFeature = pa.codebookHeader.vocalTractFeature;
        gp.isContextualGMMs = isContextualGMMs;
        gp.gmmEMTrainerParams.totalComponents = numComponents[0];
        gp.gmmEMTrainerParams.isDiagonalCovariance = true;
        gp.gmmEMTrainerParams.kmeansMaxIterations = 200;
        gp.gmmEMTrainerParams.kmeansMinClusterChangePercent = 0.1;
        gp.gmmEMTrainerParams.kmeansMinSamplesInOneCluster = 50;
        gp.gmmEMTrainerParams.emMinIterations = 100;
        gp.gmmEMTrainerParams.emMaxIterations = 400;
        gp.gmmEMTrainerParams.isUpdateCovariances = true;
        gp.gmmEMTrainerParams.tinyLogLikelihoodChangePercent = 1.0E-5;
        gp.gmmEMTrainerParams.minCovarianceAllowed = 1.0E-4;
        gp.gmmEMTrainerParams.useNativeCLibTrainer = true;
        if (gp.isContextualGMMs) {
            GMMTrainerParams[] gmmParams = new GMMTrainerParams[numComponents.length];
            i = 0;
            while (i < numComponents.length) {
                gmmParams[i] = new GMMTrainerParams(gp.gmmEMTrainerParams);
                gmmParams[i].totalComponents = numComponents[i];
                ++i;
            }
            String phoneSetFile = "/project/mary/marcela/openmary/lib/modules/de/cap/phone-list-de.xml";
            cg = JointGMMParallelTrainer.getContextualGMMParams(phoneSetFile, gmmParams, contextClassificationType);
        }
        String baseFile = String.valueOf(StringUtils.checkLastSlash(pa.trainingBaseFolder)) + pa.codebookHeader.sourceTag + "_X_" + pa.codebookHeader.targetTag;
        pa.codebookFile = String.valueOf(baseFile) + "_" + String.valueOf(numTrainingFiles) + ".wcf";
        pa.pitchMappingFile = String.valueOf(baseFile) + "_" + String.valueOf(numTrainingFiles) + PitchMappingFile.DEFAULT_EXTENSION;
        if (!isContextualGMMs) {
            gp.jointGMMFile = String.valueOf(baseFile) + "_" + String.valueOf(numTrainingFiles) + "_" + String.valueOf(gp.gmmEMTrainerParams.totalComponents) + ".jgs";
        } else {
            gp.jointGMMFile = String.valueOf(baseFile) + "_" + String.valueOf(numTrainingFiles) + "_context" + String.valueOf(contextClassificationType);
            i = 0;
            while (i < numComponents.length) {
                gp.jointGMMFile = String.valueOf(gp.jointGMMFile) + "_" + String.valueOf(numComponents[i]);
                ++i;
            }
            gp.jointGMMFile = String.valueOf(gp.jointGMMFile) + ".jgs";
        }
        pa.isForcedAnalysis = false;
        pa.codebookHeader.ptcParams.windowSizeInSeconds = 0.04;
        pa.codebookHeader.ptcParams.skipSizeInSeconds = 0.005;
        pa.codebookHeader.ptcParams.voicingThreshold = 0.3;
        pa.codebookHeader.ptcParams.isDoublingCheck = false;
        pa.codebookHeader.ptcParams.isHalvingCheck = false;
        pa.codebookHeader.ptcParams.minimumF0 = 40.0;
        pa.codebookHeader.ptcParams.maximumF0 = 400.0;
        pa.codebookHeader.ptcParams.centerClippingRatio = 0.3;
        pa.codebookHeader.ptcParams.cutOff1 = pa.codebookHeader.ptcParams.minimumF0 - 20.0;
        pa.codebookHeader.ptcParams.cutOff2 = pa.codebookHeader.ptcParams.maximumF0 + 200.0;
        pa.codebookHeader.energyParams.windowSizeInSeconds = 0.02;
        pa.codebookHeader.energyParams.skipSizeInSeconds = 0.01;
        TotalStandardDeviations tsd = new TotalStandardDeviations();
        tsd.lsf = 1.5;
        tsd.f0 = 1.0;
        tsd.duration = 1.0;
        tsd.energy = 2.0;
        pa.gaussianEliminatorParams.isActive = true;
        pa.gaussianEliminatorParams.isCheckLsfOutliers = true;
        pa.gaussianEliminatorParams.isEliminateTooSimilarLsf = false;
        pa.gaussianEliminatorParams.isCheckF0Outliers = true;
        pa.gaussianEliminatorParams.isCheckDurationOutliers = true;
        pa.gaussianEliminatorParams.isCheckEnergyOutliers = true;
        pa.gaussianEliminatorParams.totalStandardDeviations = new TotalStandardDeviations(tsd);
        pa.kmeansEliminatorParams.isActive = false;
        pa.kmeansEliminatorParams.eliminationAlgorithm = 2;
        pa.kmeansEliminatorParams.distanceType = 3;
        pa.kmeansEliminatorParams.isGlobalVariance = true;
        pa.kmeansEliminatorParams.isSeparateClustering = false;
        tsd.general = 0.1;
        pa.kmeansEliminatorParams.numClusters = 30;
        tsd.lsf = 1.0;
        tsd.f0 = 1.0;
        tsd.duration = 1.0;
        tsd.energy = 1.0;
        pa.kmeansEliminatorParams.numClustersLsf = 30;
        pa.kmeansEliminatorParams.numClustersF0 = 50;
        pa.kmeansEliminatorParams.numClustersDuration = 5;
        pa.kmeansEliminatorParams.numClustersEnergy = 5;
        pa.kmeansEliminatorParams.isCheckLsfOutliers = false;
        pa.kmeansEliminatorParams.isCheckF0Outliers = false;
        pa.kmeansEliminatorParams.isCheckDurationOutliers = false;
        pa.kmeansEliminatorParams.isCheckEnergyOutliers = false;
        pa.kmeansEliminatorParams.totalStandardDeviations = new TotalStandardDeviations(tsd);
        pa.labelsToExcludeFromTraining = new String[1];
        pa.labelsToExcludeFromTraining[0] = "_";
        JointGMMParallelTrainer t = new JointGMMParallelTrainer(pp, fe, pa, gp, cg);
        t.run();
    }

    public static ContextualGMMParams getContextualGMMParams(String phoneSetFile, GMMTrainerParams[] params, int contextClassificationType) throws MaryConfigurationException {
        AllophoneSet allophoneSet = AllophoneSet.getAllophoneSet(phoneSetFile);
        assert (allophoneSet != null);
        ContextualGMMParams cg = new ContextualGMMParams(allophoneSet, params, contextClassificationType);
        return cg;
    }
}

