/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.audio;

import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;

public class TimedAudioRecorder
extends Thread {
    private TargetDataLine m_line;
    private AudioFileFormat.Type m_targetType;
    private AudioInputStream m_audioInputStream;
    private File m_outputFile;
    private long timeout;

    public TimedAudioRecorder(TargetDataLine line, AudioFileFormat.Type targetType, File file, long timeout) {
        this.m_line = line;
        this.m_audioInputStream = new AudioInputStream(line);
        this.m_targetType = targetType;
        this.m_outputFile = file;
        this.timeout = timeout;
    }

    @Override
    public void start() {
        this.m_line.start();
        super.start();
    }

    public void stopRecording() {
        this.m_line.stop();
        this.m_line.close();
    }

    @Override
    public void run() {
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                TimedAudioRecorder.this.stopRecording();
                timer.cancel();
            }
        }, this.timeout);
        try {
            AudioSystem.write(this.m_audioInputStream, this.m_targetType, this.m_outputFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length < 3 || args[0].equals("-h")) {
            TimedAudioRecorder.printUsageAndExit();
        }
        long duration = 0L;
        long rate = 16000L;
        int channels = 1;
        int i = 0;
        while (i < args.length - 1) {
            if (args[i].equals("-dur")) {
                duration = Long.parseLong(args[i + 1]);
                i += 2;
                continue;
            }
            if (args[i].equals("-mono")) {
                channels = 1;
                ++i;
                continue;
            }
            if (args[i].equals("-stereo")) {
                channels = 2;
                ++i;
                continue;
            }
            if (args[i].equals("-rate")) {
                rate = Long.parseLong(args[i + 1]);
                i += 2;
                continue;
            }
            TimedAudioRecorder.printUsageAndExit();
        }
        String strFilename = args[args.length - 1];
        File outputFile = new File(strFilename);
        AudioFormat audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, rate, 16, channels, 2 * channels, rate, false);
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, audioFormat);
        TargetDataLine targetDataLine = null;
        try {
            targetDataLine = (TargetDataLine)AudioSystem.getLine(info);
            targetDataLine.open(audioFormat);
        }
        catch (LineUnavailableException e) {
            TimedAudioRecorder.out("unable to get a recording line");
            e.printStackTrace();
            System.exit(1);
        }
        AudioFileFormat.Type targetType = AudioFileFormat.Type.WAVE;
        TimedAudioRecorder recorder = new TimedAudioRecorder(targetDataLine, targetType, outputFile, duration);
        recorder.start();
        TimedAudioRecorder.out("Recording...");
        try {
            recorder.join();
        }
        catch (InterruptedException interruptedException) {}
        TimedAudioRecorder.out("Recording stopped.");
    }

    private static void printUsageAndExit() {
        TimedAudioRecorder.out("TimedAudioRecorder: usage:");
        TimedAudioRecorder.out("\tjava org.jsresources.TimedAudioRecorder -h");
        TimedAudioRecorder.out("\tjava org.jsresources.TimeedAudioRecorder -dur <dur> [-rate <samplerate>] [-stereo|-mono] <audiofile>");
        System.exit(0);
    }

    private static void out(String strMessage) {
        System.out.println(strMessage);
    }
}

