/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.text;

public class PraatInterval {
    private double xmin = Double.NaN;
    private double xmax = Double.NaN;
    private String text = null;
    private double duration = Double.NaN;

    public PraatInterval(double xmin, double xmax) {
        this.setXmin(xmin);
        this.setXmax(xmax);
    }

    public PraatInterval(double xmin, double xmax, String text) {
        this(xmin, xmax);
        this.setText(text);
    }

    public PraatInterval(double duration) {
        this.setDuration(duration);
    }

    public PraatInterval(double duration, String text) {
        this(duration);
        this.setText(text);
    }

    public double getXmin() {
        return this.xmin;
    }

    public double getXmax() {
        return this.xmax;
    }

    public String getText() {
        if (this.text == null) {
            return "";
        }
        return this.text;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setXmin(double xmin) {
        this.xmin = xmin;
        this.updateDuration();
    }

    public void setXmax(double xmax) {
        this.xmax = xmax;
        this.updateDuration();
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setDuration(double duration) throws IllegalArgumentException {
        if (Double.isNaN(duration) || duration < 0.0) {
            throw new IllegalArgumentException("duration must be a non-negative value, but was " + duration);
        }
        this.duration = duration;
    }

    public void updateDuration() {
        if (!Double.isNaN(this.getXmin()) && !Double.isNaN(this.getXmax())) {
            this.setDuration(this.getXmax() - this.getXmin());
        }
    }

    public boolean isComplete() {
        return !Double.isNaN(this.getXmin()) && !Double.isNaN(this.getXmax());
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("xmin = " + this.getXmin() + " \n");
        str.append("xmax = " + this.getXmax() + " \n");
        str.append("text = \"" + this.getText() + "\" \n");
        return str.toString();
    }
}

