/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.math;

import marytts.util.math.ComplexArray;
import marytts.util.math.MathUtils;

public class FFTMixedRadix {
    private static int maxf = 10000;
    private static int maxp = 10000;
    private static int[] nfac;
    private static int[] np;
    private static double[] at;
    private static double[] ck;
    private static double[] bt;
    private static double[] sk;
    private static int factInd;
    private static int nt;
    private static int ks;
    private static int kspan;
    private static int nn;
    private static int jc;
    private static double radf;
    private static int jf;
    private static double sd;
    private static double cd;
    private static int kk;
    private static int k1;
    private static int k2;
    private static double ak;
    private static double bk;
    private static double c1;
    private static double s1;
    private static double aj;
    private static double bj;
    private static int kspnn;
    private static int k3;
    private static int k4;
    private static double akp;
    private static double akm;
    private static double ajp;
    private static double ajm;
    private static double bkp;
    private static double bkm;
    private static double bjp;
    private static double bjm;
    private static double c2;
    private static double s2;
    private static double c3;
    private static double s3;
    private static double aa;
    private static double bb;
    private static int currentFactor;
    private static int jCount;
    private static int jj;
    private static int jn;
    private static int kt;
    private static int mCount;
    private static int inc;
    private static double c72;
    private static double s72;
    private static double s120;
    private static double rad;

    public static double[] fftPowerSpectrum(double[] x) {
        return FFTMixedRadix.fftPowerSpectrum(x, x.length);
    }

    public static double[] fftPowerSpectrum(double[] x, int fftSize) {
        int xlen = x.length;
        ComplexArray h = new ComplexArray(fftSize);
        double[] Ps = new double[fftSize];
        int w = 0;
        while (w < xlen) {
            h.real[w] = x[w];
            h.imag[w] = 0.0;
            ++w;
        }
        w = xlen;
        while (w < fftSize) {
            h.real[w] = 0.0;
            h.imag[w] = 0.0;
            ++w;
        }
        FFTMixedRadix.mixedRadixFFTBase(h.real, h.imag, fftSize, fftSize, fftSize, 1);
        w = 0;
        while (w < fftSize) {
            h.imag[w] = -h.imag[w];
            ++w;
        }
        w = 0;
        while (w < fftSize) {
            Ps[w] = 10.0 * MathUtils.log10(h.real[w] * h.real[w] + h.imag[w] * h.imag[w]);
            ++w;
        }
        return Ps;
    }

    public static double[] fftAbsSpectrum(double[] x) {
        return FFTMixedRadix.fftAbsSpectrum(x, x.length);
    }

    public static double[] fftAbsSpectrum(double[] x, int fftSize) {
        int xlen = x.length;
        ComplexArray h = new ComplexArray(fftSize);
        double[] Ps = new double[fftSize];
        int w = 0;
        while (w < xlen) {
            h.real[w] = x[w];
            h.imag[w] = 0.0;
            ++w;
        }
        w = xlen;
        while (w < fftSize) {
            h.real[w] = 0.0;
            h.imag[w] = 0.0;
            ++w;
        }
        FFTMixedRadix.mixedRadixFFTBase(h.real, h.imag, fftSize, fftSize, fftSize, 1);
        w = 0;
        while (w < fftSize) {
            h.imag[w] = -h.imag[w];
            ++w;
        }
        w = 0;
        while (w < fftSize) {
            Ps[w] = Math.sqrt(h.real[w] * h.real[w] + h.imag[w] * h.imag[w]);
            ++w;
        }
        return Ps;
    }

    public static ComplexArray fftReal(double[] x, int xlen) {
        ComplexArray h = new ComplexArray(xlen);
        int w = 0;
        while (w < xlen) {
            h.real[w] = x[w];
            h.imag[w] = 0.0;
            ++w;
        }
        FFTMixedRadix.mixedRadixFFTBase(h.real, h.imag, xlen, xlen, xlen, 1);
        w = 0;
        while (w < xlen) {
            h.imag[w] = -h.imag[w];
            ++w;
        }
        return h;
    }

    public static ComplexArray fftReal(double[] x, int xlen, int fftSize) {
        if (xlen > fftSize) {
            xlen = fftSize;
        }
        double[] x2 = new double[fftSize];
        int w = 0;
        while (w < xlen) {
            x2[w] = x[w];
            ++w;
        }
        w = xlen;
        while (w < fftSize) {
            x2[w] = 0.0;
            ++w;
        }
        ComplexArray h = FFTMixedRadix.fftReal(x2, fftSize);
        return h;
    }

    public static ComplexArray fftComplex(ComplexArray x, int fftSize) {
        ComplexArray h = new ComplexArray(fftSize);
        int w = 0;
        while (w < Math.min(x.real.length, fftSize)) {
            h.real[w] = x.real[w];
            h.imag[w] = x.imag[w];
            ++w;
        }
        w = x.real.length;
        while (w < fftSize) {
            h.real[w] = 0.0;
            h.imag[w] = 0.0;
            ++w;
        }
        FFTMixedRadix.mixedRadixFFTBase(h.real, h.imag, fftSize, fftSize, fftSize, 1);
        int midVal = (int)(Math.floor(fftSize / 2) + 1.0);
        w = 1;
        while (w < midVal) {
            double tmp = h.real[w];
            h.real[w] = h.real[fftSize - w];
            h.real[fftSize - w] = tmp;
            tmp = h.imag[w];
            h.imag[w] = h.imag[fftSize - w];
            h.imag[fftSize - w] = tmp;
            ++w;
        }
        return h;
    }

    public static void fftComplexInPlace(double[] real, double[] imag) {
        ComplexArray c = FFTMixedRadix.fftComplex(real, imag, Math.min(real.length, imag.length));
        System.arraycopy(c.real, 0, real, 0, c.real.length);
        System.arraycopy(c.imag, 0, imag, 0, c.imag.length);
    }

    public static ComplexArray fftComplex(double[] real, double[] imag) {
        return FFTMixedRadix.fftComplex(new ComplexArray(real, imag));
    }

    public static ComplexArray fftComplex(double[] real, double[] imag, int ifftSize) {
        return FFTMixedRadix.fftComplex(new ComplexArray(real, imag), ifftSize);
    }

    public static ComplexArray fftComplex(ComplexArray x) {
        return FFTMixedRadix.fftComplex(x, x.real.length);
    }

    public static ComplexArray ifft(ComplexArray x, int ifftSize) {
        ComplexArray h = null;
        if (x.real.length > ifftSize) {
            ComplexArray h2 = FFTMixedRadix.ifft(x);
            h = new ComplexArray(ifftSize);
            int w = 0;
            while (w < ifftSize) {
                h.real[w] = h2.real[w];
                h.imag[w] = h2.imag[w];
                ++w;
            }
        } else if (x.real.length == ifftSize) {
            h = FFTMixedRadix.ifft(x);
        } else {
            ComplexArray h2 = FFTMixedRadix.ifft(x);
            h = new ComplexArray(ifftSize);
            int w = 0;
            while (w < h2.real.length) {
                h.real[w] = h2.real[w];
                h.imag[w] = h2.imag[w];
                ++w;
            }
            w = h2.real.length;
            while (w < ifftSize) {
                h.real[w] = 0.0;
                h.imag[w] = 0.0;
                ++w;
            }
        }
        return h;
    }

    public static ComplexArray ifft(double[] real, double[] imag) {
        return FFTMixedRadix.ifft(new ComplexArray(real, imag));
    }

    public static ComplexArray ifft(double[] real, double[] imag, int ifftSize) {
        return FFTMixedRadix.ifft(new ComplexArray(real, imag), ifftSize);
    }

    public static ComplexArray ifft(ComplexArray x) {
        ComplexArray h = new ComplexArray(x.real.length);
        int w = 0;
        while (w < x.real.length) {
            h.real[w] = x.real[w] / (double)x.real.length;
            h.imag[w] = x.imag[w] / (double)x.real.length;
            ++w;
        }
        FFTMixedRadix.mixedRadixFFTBase(h.real, h.imag, x.real.length, x.real.length, x.real.length, -1);
        int midVal = (int)(Math.floor(x.real.length / 2) + 1.0);
        w = 1;
        while (w < midVal) {
            double tmp = h.real[w];
            h.real[w] = h.real[x.real.length - w];
            h.real[x.real.length - w] = tmp;
            tmp = h.imag[w];
            h.imag[w] = h.imag[x.real.length - w];
            h.imag[x.real.length - w] = tmp;
            ++w;
        }
        return h;
    }

    public static double[] ifftReal(ComplexArray x, int ifftSize) {
        ComplexArray h = FFTMixedRadix.ifft(x);
        double[] y = new double[ifftSize];
        int w = 0;
        while (w < Math.min(h.real.length, ifftSize)) {
            y[w] = h.real[w];
            ++w;
        }
        w = Math.min(h.real.length, ifftSize);
        while (w < ifftSize) {
            y[w] = 0.0;
            ++w;
        }
        return y;
    }

    /*
     * Unable to fully structure code
     */
    private static void mixedRadixFFTBase(double[] a, double[] b, int ntot, int fftSize, int nspan, int isn) {
        block174: {
            bLoopLine924 = false;
            bJumpToLine924 = false;
            bJumpToLine950 = true;
            bLoopLine730 = false;
            bJumpToLine730 = false;
            bLoopLine640 = false;
            bJumpToLine640 = false;
            bJumpToLine640_0 = true;
            bLoopLine520 = false;
            bJumpToLine520 = false;
            bLoopLine230 = false;
            bJumpToLine230 = false;
            bLoopLine210 = false;
            bJumpToLine210 = false;
            bLoopLine820 = false;
            bJumpToLine820 = false;
            bLoopLine830 = false;
            bJumpToLine830 = false;
            bLoopLine840 = false;
            bJumpToLine840 = false;
            bLoopLine850 = false;
            bJumpToLine850 = false;
            bLoopLine870 = false;
            bJumpToLine870 = false;
            bLoopLine880 = false;
            bJumpToLine880 = false;
            bLoopLine910 = false;
            bJumpToLine910 = false;
            bJumpToLine914_0 = true;
            bLoopLine914 = false;
            bJumpToLine914 = false;
            bLoopLine420 = false;
            bJumpToLine420 = false;
            bLoopLine440 = false;
            bJumpToLine460 = false;
            bJumpToLine450 = false;
            bLoopLine430 = false;
            bJumpToLine430 = false;
            bLoopLine410 = false;
            bJumpToLine410 = false;
            bLoopLine320 = false;
            bJumpToLine320 = false;
            bLoopLine320Prev = false;
            bJumpToLine320Prev = false;
            bLoopLine320Prev_2 = false;
            bJumpToLine320Prev_2 = false;
            bLoopLine320Prev_3 = false;
            bJumpToLine320Prev_3 = false;
            bLoopLine100 = false;
            bJumpToLine100 = false;
            bJumpToLine100_2 = false;
            bJumpToLine100_3 = false;
            bJumpToLine400 = false;
            bLoopLine510 = false;
            bJumpToLine510 = false;
            bLoopLine510Prev_2 = false;
            bJumpToLine510Prev_2 = false;
            bLoopLine510Prev_3 = false;
            bJumpToLine510Prev_3 = false;
            bLoopLine902 = false;
            bJumpToLine902 = false;
            bLoopLine904 = false;
            bJumpToLine904 = false;
            bJumpToLine906 = false;
            bJumpToLine890 = false;
            bJumpToLine800 = false;
            bJumpToLine800_1 = false;
            bLoopLine410Prev_2 = false;
            bLoopLine420Prev_2 = false;
            bLoopLine430Prev_2 = false;
            bLoopLine440Prev_2 = false;
            bJumpToLine410Prev_2 = false;
            bJumpToLine420Prev_2 = false;
            bJumpToLine430Prev_2 = false;
            bJumpToLine700 = false;
            FFTMixedRadix.nfac = new int[200];
            FFTMixedRadix.np = new int[FFTMixedRadix.maxp];
            FFTMixedRadix.at = new double[FFTMixedRadix.maxf];
            FFTMixedRadix.ck = new double[FFTMixedRadix.maxf];
            FFTMixedRadix.bt = new double[FFTMixedRadix.maxf];
            FFTMixedRadix.sk = new double[FFTMixedRadix.maxf];
            FFTMixedRadix.inc = isn;
            FFTMixedRadix.c72 = 0.3090169943749474;
            FFTMixedRadix.s72 = 0.9510565162951535;
            FFTMixedRadix.s120 = 0.8660254037844386;
            FFTMixedRadix.rad = 6.2831853071796;
            if (fftSize < 2) {
                return;
            }
            if (isn < 0) {
                FFTMixedRadix.s72 = -FFTMixedRadix.s72;
                FFTMixedRadix.s120 = -FFTMixedRadix.s120;
                FFTMixedRadix.rad = -FFTMixedRadix.rad;
                FFTMixedRadix.inc = -FFTMixedRadix.inc;
            }
            FFTMixedRadix.nt = FFTMixedRadix.inc * ntot;
            FFTMixedRadix.kspan = FFTMixedRadix.ks = FFTMixedRadix.inc * nspan;
            FFTMixedRadix.nn = FFTMixedRadix.nt - FFTMixedRadix.inc;
            FFTMixedRadix.jc = FFTMixedRadix.ks / fftSize;
            FFTMixedRadix.radf = FFTMixedRadix.rad * (double)FFTMixedRadix.jc * 0.5;
            FFTMixedRadix.factInd = 0;
            FFTMixedRadix.jf = 0;
            FFTMixedRadix.mCount = 0;
            FFTMixedRadix.currentFactor = fftSize;
            if (fftSize >= 2) ** GOTO lbl108
            FFTMixedRadix.nfac[0] = fftSize;
            break block174;
lbl-1000:
            // 1 sources

            {
                FFTMixedRadix.nfac[++FFTMixedRadix.mCount - 1] = 4;
                FFTMixedRadix.currentFactor /= 16;
lbl108:
                // 2 sources

                ** while (FFTMixedRadix.currentFactor % 16 == 0)
            }
lbl109:
            // 1 sources

            FFTMixedRadix.jn = 3;
            FFTMixedRadix.jj = 9;
            while (FFTMixedRadix.currentFactor % FFTMixedRadix.jj == 0) {
                FFTMixedRadix.nfac[++FFTMixedRadix.mCount - 1] = FFTMixedRadix.jn;
                FFTMixedRadix.currentFactor /= FFTMixedRadix.jj;
            }
            FFTMixedRadix.jj = (FFTMixedRadix.jn += 2) * FFTMixedRadix.jn;
            ** GOTO lbl122
            {
                FFTMixedRadix.nfac[++FFTMixedRadix.mCount - 1] = FFTMixedRadix.jn;
                FFTMixedRadix.currentFactor /= FFTMixedRadix.jj;
                do {
                    if (FFTMixedRadix.currentFactor % FFTMixedRadix.jj == 0) continue block2;
                    FFTMixedRadix.jj = (FFTMixedRadix.jn += 2) * FFTMixedRadix.jn;
lbl122:
                    // 2 sources

                } while (FFTMixedRadix.jj <= FFTMixedRadix.currentFactor);
            }
            bGoto80 = false;
            if (FFTMixedRadix.currentFactor <= 4) {
                FFTMixedRadix.kt = FFTMixedRadix.mCount;
                FFTMixedRadix.nfac[FFTMixedRadix.mCount] = FFTMixedRadix.currentFactor;
                if (FFTMixedRadix.currentFactor != 1) {
                    ++FFTMixedRadix.mCount;
                }
                bGoto80 = true;
                if (FFTMixedRadix.kt != 0) {
                    FFTMixedRadix.jn = FFTMixedRadix.kt;
                    bGoto90 = true;
                    while (FFTMixedRadix.jn != 0 || bGoto90) {
                        bGoto90 = false;
                        FFTMixedRadix.nfac[++FFTMixedRadix.mCount - 1] = FFTMixedRadix.nfac[FFTMixedRadix.jn - 1];
                        --FFTMixedRadix.jn;
                    }
                }
            }
            if (!bGoto80) {
                if ((double)FFTMixedRadix.currentFactor - Math.floor((double)FFTMixedRadix.currentFactor / 4.0) * 4.0 == 0.0) {
                    FFTMixedRadix.nfac[++FFTMixedRadix.mCount - 1] = 2;
                    FFTMixedRadix.currentFactor /= 4;
                }
                FFTMixedRadix.kt = FFTMixedRadix.mCount;
                FFTMixedRadix.jn = 2;
                bGoto60 = true;
                while (FFTMixedRadix.jn <= FFTMixedRadix.currentFactor || bGoto60) {
                    bGoto60 = false;
                    if (FFTMixedRadix.currentFactor % FFTMixedRadix.jn == 0) {
                        FFTMixedRadix.nfac[++FFTMixedRadix.mCount - 1] = FFTMixedRadix.jn;
                        FFTMixedRadix.currentFactor /= FFTMixedRadix.jn;
                    }
                    FFTMixedRadix.jn = (int)(Math.floor(((double)FFTMixedRadix.jn + 1.0) / 2.0) * 2.0 + 1.0);
                }
                if (FFTMixedRadix.kt != 0) {
                    FFTMixedRadix.jn = FFTMixedRadix.kt;
                    bGoto90 = true;
                    while (FFTMixedRadix.jn != 0 || bGoto90) {
                        bGoto90 = false;
                        FFTMixedRadix.nfac[++FFTMixedRadix.mCount - 1] = FFTMixedRadix.nfac[FFTMixedRadix.jn - 1];
                        --FFTMixedRadix.jn;
                    }
                }
            }
        }
        do {
            bLoopLine100 = false;
            if (bJumpToLine100_2) {
                bJumpToLine100_2 = false;
                bLoopLine440 = bLoopLine440Prev_2;
                bLoopLine430 = bLoopLine430Prev_2;
                bLoopLine420 = bLoopLine420Prev_2;
                bLoopLine410 = bLoopLine410Prev_2;
                bLoopLine510 = bLoopLine510Prev_2;
                bLoopLine320 = bLoopLine320Prev_2;
                bJumpToLine410 = bJumpToLine410Prev_2;
                bJumpToLine420 = bJumpToLine420Prev_2;
                bJumpToLine430 = bJumpToLine430Prev_2;
                bJumpToLine510 = bJumpToLine510Prev_2;
                bJumpToLine320 = bJumpToLine320Prev_2;
            }
            if (bJumpToLine100_3) {
                bJumpToLine100_3 = false;
                bLoopLine510 = bLoopLine510Prev_3;
                bLoopLine320 = bLoopLine320Prev_3;
                bJumpToLine510 = bJumpToLine510Prev_3;
                bJumpToLine320 = bJumpToLine320Prev_3;
            }
            if (bJumpToLine100) {
                bJumpToLine100 = false;
            }
            FFTMixedRadix.sd = FFTMixedRadix.radf / (double)FFTMixedRadix.kspan;
            FFTMixedRadix.cd = 2.0 * Math.sin(FFTMixedRadix.sd) * Math.sin(FFTMixedRadix.sd);
            FFTMixedRadix.sd = Math.sin(FFTMixedRadix.sd + FFTMixedRadix.sd);
            FFTMixedRadix.kk = 1;
            if (!(bJumpToLine400 = FFTMixedRadix.nfac[++FFTMixedRadix.factInd - 1] != 2)) {
                FFTMixedRadix.k1 = (FFTMixedRadix.kspan /= 2) + 2;
                do {
                    bLoopLine210 = false;
                    bJumpToLine210 = false;
                    FFTMixedRadix.k2 = FFTMixedRadix.kk + FFTMixedRadix.kspan;
                    FFTMixedRadix.ak = a[FFTMixedRadix.k2 - 1];
                    FFTMixedRadix.bk = b[FFTMixedRadix.k2 - 1];
                    a[FFTMixedRadix.k2 - 1] = a[FFTMixedRadix.kk - 1] - FFTMixedRadix.ak;
                    b[FFTMixedRadix.k2 - 1] = b[FFTMixedRadix.kk - 1] - FFTMixedRadix.bk;
                    a[FFTMixedRadix.kk - 1] = a[FFTMixedRadix.kk - 1] + FFTMixedRadix.ak;
                    b[FFTMixedRadix.kk - 1] = b[FFTMixedRadix.kk - 1] + FFTMixedRadix.bk;
                    FFTMixedRadix.kk = FFTMixedRadix.k2 + FFTMixedRadix.kspan;
                    if (FFTMixedRadix.kk <= FFTMixedRadix.nn) {
                        bLoopLine210 = true;
                        bJumpToLine210 = true;
                    } else {
                        bLoopLine210 = false;
                        bJumpToLine210 = false;
                    }
                    if (bJumpToLine210) continue;
                    if ((FFTMixedRadix.kk -= FFTMixedRadix.nn) <= FFTMixedRadix.jc) {
                        bLoopLine210 = true;
                        bJumpToLine210 = true;
                        continue;
                    }
                    bLoopLine210 = false;
                    bJumpToLine210 = false;
                } while (bLoopLine210);
                bJumpToLine800 = FFTMixedRadix.kk > FFTMixedRadix.kspan;
                if (!bJumpToLine800) {
                    do {
                        FFTMixedRadix.c1 = 1.0 - FFTMixedRadix.cd;
                        FFTMixedRadix.s1 = FFTMixedRadix.sd;
                        do {
                            bLoopLine230 = false;
                            bJumpToLine230 = false;
                            FFTMixedRadix.k2 = FFTMixedRadix.kk + FFTMixedRadix.kspan;
                            FFTMixedRadix.ak = a[FFTMixedRadix.kk - 1] - a[FFTMixedRadix.k2 - 1];
                            FFTMixedRadix.bk = b[FFTMixedRadix.kk - 1] - b[FFTMixedRadix.k2 - 1];
                            a[FFTMixedRadix.kk - 1] = a[FFTMixedRadix.kk - 1] + a[FFTMixedRadix.k2 - 1];
                            b[FFTMixedRadix.kk - 1] = b[FFTMixedRadix.kk - 1] + b[FFTMixedRadix.k2 - 1];
                            a[FFTMixedRadix.k2 - 1] = FFTMixedRadix.c1 * FFTMixedRadix.ak - FFTMixedRadix.s1 * FFTMixedRadix.bk;
                            b[FFTMixedRadix.k2 - 1] = FFTMixedRadix.s1 * FFTMixedRadix.ak + FFTMixedRadix.c1 * FFTMixedRadix.bk;
                            FFTMixedRadix.kk = FFTMixedRadix.k2 + FFTMixedRadix.kspan;
                            if (FFTMixedRadix.kk < FFTMixedRadix.nt) {
                                bLoopLine230 = true;
                                bJumpToLine230 = true;
                            } else {
                                bLoopLine230 = false;
                                bJumpToLine230 = false;
                            }
                            if (bJumpToLine230) continue;
                            FFTMixedRadix.k2 = FFTMixedRadix.kk - FFTMixedRadix.nt;
                            FFTMixedRadix.c1 = -FFTMixedRadix.c1;
                            FFTMixedRadix.kk = FFTMixedRadix.k1 - FFTMixedRadix.k2;
                            if (FFTMixedRadix.kk > FFTMixedRadix.k2) {
                                bLoopLine230 = true;
                                bJumpToLine230 = true;
                            } else {
                                bLoopLine230 = false;
                                bJumpToLine230 = false;
                            }
                            if (bJumpToLine230) continue;
                            FFTMixedRadix.ak = FFTMixedRadix.c1 - (FFTMixedRadix.cd * FFTMixedRadix.c1 + FFTMixedRadix.sd * FFTMixedRadix.s1);
                            FFTMixedRadix.s1 = FFTMixedRadix.sd * FFTMixedRadix.c1 - FFTMixedRadix.cd * FFTMixedRadix.s1 + FFTMixedRadix.s1;
                            FFTMixedRadix.c1 = 2.0 - (FFTMixedRadix.ak * FFTMixedRadix.ak + FFTMixedRadix.s1 * FFTMixedRadix.s1);
                            FFTMixedRadix.s1 = FFTMixedRadix.c1 * FFTMixedRadix.s1;
                            FFTMixedRadix.c1 *= FFTMixedRadix.ak;
                            if ((FFTMixedRadix.kk += FFTMixedRadix.jc) < FFTMixedRadix.k2) {
                                bLoopLine230 = true;
                                bJumpToLine230 = true;
                                continue;
                            }
                            bLoopLine230 = false;
                            bJumpToLine230 = false;
                        } while (bLoopLine230);
                    } while ((FFTMixedRadix.kk = ((FFTMixedRadix.k1 = FFTMixedRadix.k1 + FFTMixedRadix.inc + FFTMixedRadix.inc) - FFTMixedRadix.kspan) / 2 + FFTMixedRadix.jc) <= FFTMixedRadix.jc + FFTMixedRadix.jc);
                    bLoopLine100 = true;
                    bJumpToLine100 = true;
                }
            }
            if (bJumpToLine100 && !bJumpToLine400 && !bJumpToLine800) continue;
            do {
                if (!bJumpToLine800 && !bJumpToLine400) {
                    bLoopLine320 = false;
                    bJumpToLine320 = false;
                    FFTMixedRadix.k1 = FFTMixedRadix.kk + FFTMixedRadix.kspan;
                    FFTMixedRadix.k2 = FFTMixedRadix.k1 + FFTMixedRadix.kspan;
                    FFTMixedRadix.ak = a[FFTMixedRadix.kk - 1];
                    FFTMixedRadix.bk = b[FFTMixedRadix.kk - 1];
                    FFTMixedRadix.aj = a[FFTMixedRadix.k1 - 1] + a[FFTMixedRadix.k2 - 1];
                    FFTMixedRadix.bj = b[FFTMixedRadix.k1 - 1] + b[FFTMixedRadix.k2 - 1];
                    a[FFTMixedRadix.kk - 1] = FFTMixedRadix.ak + FFTMixedRadix.aj;
                    b[FFTMixedRadix.kk - 1] = FFTMixedRadix.bk + FFTMixedRadix.bj;
                    FFTMixedRadix.ak = -0.5 * FFTMixedRadix.aj + FFTMixedRadix.ak;
                    FFTMixedRadix.bk = -0.5 * FFTMixedRadix.bj + FFTMixedRadix.bk;
                    FFTMixedRadix.aj = (a[FFTMixedRadix.k1 - 1] - a[FFTMixedRadix.k2 - 1]) * FFTMixedRadix.s120;
                    FFTMixedRadix.bj = (b[FFTMixedRadix.k1 - 1] - b[FFTMixedRadix.k2 - 1]) * FFTMixedRadix.s120;
                    a[FFTMixedRadix.k1 - 1] = FFTMixedRadix.ak - FFTMixedRadix.bj;
                    b[FFTMixedRadix.k1 - 1] = FFTMixedRadix.bk + FFTMixedRadix.aj;
                    a[FFTMixedRadix.k2 - 1] = FFTMixedRadix.ak + FFTMixedRadix.bj;
                    b[FFTMixedRadix.k2 - 1] = FFTMixedRadix.bk - FFTMixedRadix.aj;
                    FFTMixedRadix.kk = FFTMixedRadix.k2 + FFTMixedRadix.kspan;
                    if (FFTMixedRadix.kk < FFTMixedRadix.nn) {
                        bLoopLine320 = true;
                        bJumpToLine320 = true;
                    } else {
                        bLoopLine320 = false;
                        bJumpToLine320 = false;
                    }
                }
                if (bJumpToLine320 && !bJumpToLine400 && !bJumpToLine800) continue;
                if (!bJumpToLine800 && !bJumpToLine400) {
                    if ((FFTMixedRadix.kk -= FFTMixedRadix.nn) <= FFTMixedRadix.kspan) {
                        bLoopLine320 = true;
                        bJumpToLine320 = true;
                    } else {
                        bLoopLine320 = false;
                        bJumpToLine320 = false;
                    }
                }
                if (bJumpToLine320 && !bJumpToLine400 && !bJumpToLine800) continue;
                if (!bJumpToLine800 && !bJumpToLine700) {
                    bJumpToLine700 = bJumpToLine400 == false;
                }
                do {
                    if (!(bJumpToLine700 && !bJumpToLine400 || bJumpToLine800 && !bJumpToLine400)) {
                        bJumpToLine400 = false;
                        if (FFTMixedRadix.nfac[FFTMixedRadix.factInd - 1] == 4 || bJumpToLine510) {
                            if (!bJumpToLine510) {
                                FFTMixedRadix.kspnn = FFTMixedRadix.kspan;
                                FFTMixedRadix.kspan /= 4;
                                do {
                                    bLoopLine410 = false;
                                    bJumpToLine410 = false;
                                    FFTMixedRadix.c1 = 1.0;
                                    FFTMixedRadix.s1 = 0.0;
                                    do {
                                        bLoopLine420 = false;
                                        bJumpToLine420 = false;
                                        FFTMixedRadix.k1 = FFTMixedRadix.kk + FFTMixedRadix.kspan;
                                        FFTMixedRadix.k2 = FFTMixedRadix.k1 + FFTMixedRadix.kspan;
                                        FFTMixedRadix.k3 = FFTMixedRadix.k2 + FFTMixedRadix.kspan;
                                        FFTMixedRadix.akp = a[FFTMixedRadix.kk - 1] + a[FFTMixedRadix.k2 - 1];
                                        FFTMixedRadix.akm = a[FFTMixedRadix.kk - 1] - a[FFTMixedRadix.k2 - 1];
                                        FFTMixedRadix.ajp = a[FFTMixedRadix.k1 - 1] + a[FFTMixedRadix.k3 - 1];
                                        FFTMixedRadix.ajm = a[FFTMixedRadix.k1 - 1] - a[FFTMixedRadix.k3 - 1];
                                        a[FFTMixedRadix.kk - 1] = FFTMixedRadix.akp + FFTMixedRadix.ajp;
                                        FFTMixedRadix.ajp = FFTMixedRadix.akp - FFTMixedRadix.ajp;
                                        FFTMixedRadix.bkp = b[FFTMixedRadix.kk - 1] + b[FFTMixedRadix.k2 - 1];
                                        FFTMixedRadix.bkm = b[FFTMixedRadix.kk - 1] - b[FFTMixedRadix.k2 - 1];
                                        FFTMixedRadix.bjp = b[FFTMixedRadix.k1 - 1] + b[FFTMixedRadix.k3 - 1];
                                        FFTMixedRadix.bjm = b[FFTMixedRadix.k1 - 1] - b[FFTMixedRadix.k3 - 1];
                                        b[FFTMixedRadix.kk - 1] = FFTMixedRadix.bkp + FFTMixedRadix.bjp;
                                        FFTMixedRadix.bjp = FFTMixedRadix.bkp - FFTMixedRadix.bjp;
                                        bJumpToLine450 = isn < 0;
                                        if (!bJumpToLine450) {
                                            FFTMixedRadix.akp = FFTMixedRadix.akm - FFTMixedRadix.bjm;
                                            FFTMixedRadix.akm += FFTMixedRadix.bjm;
                                            FFTMixedRadix.bkp = FFTMixedRadix.bkm + FFTMixedRadix.ajm;
                                            FFTMixedRadix.bkm -= FFTMixedRadix.ajm;
                                            bJumpToLine460 = FFTMixedRadix.s1 == 0.0;
                                        }
                                        do {
                                            bLoopLine430 = false;
                                            bJumpToLine430 = false;
                                            if (!bJumpToLine460 && !bJumpToLine450) {
                                                a[FFTMixedRadix.k1 - 1] = FFTMixedRadix.akp * FFTMixedRadix.c1 - FFTMixedRadix.bkp * FFTMixedRadix.s1;
                                                b[FFTMixedRadix.k1 - 1] = FFTMixedRadix.akp * FFTMixedRadix.s1 + FFTMixedRadix.bkp * FFTMixedRadix.c1;
                                                a[FFTMixedRadix.k2 - 1] = FFTMixedRadix.ajp * FFTMixedRadix.c2 - FFTMixedRadix.bjp * FFTMixedRadix.s2;
                                                b[FFTMixedRadix.k2 - 1] = FFTMixedRadix.ajp * FFTMixedRadix.s2 + FFTMixedRadix.bjp * FFTMixedRadix.c2;
                                                a[FFTMixedRadix.k3 - 1] = FFTMixedRadix.akm * FFTMixedRadix.c3 - FFTMixedRadix.bkm * FFTMixedRadix.s3;
                                                b[FFTMixedRadix.k3 - 1] = FFTMixedRadix.akm * FFTMixedRadix.s3 + FFTMixedRadix.bkm * FFTMixedRadix.c3;
                                                FFTMixedRadix.kk = FFTMixedRadix.k3 + FFTMixedRadix.kspan;
                                                if (FFTMixedRadix.kk <= FFTMixedRadix.nt) {
                                                    bLoopLine420 = true;
                                                    bJumpToLine420 = true;
                                                } else {
                                                    bLoopLine420 = false;
                                                    bJumpToLine420 = false;
                                                }
                                            }
                                            if (bJumpToLine420 && !bJumpToLine460 && !bJumpToLine450) continue;
                                            do {
                                                if (!bJumpToLine460 && !bJumpToLine450) {
                                                    bLoopLine440 = false;
                                                    FFTMixedRadix.c2 = FFTMixedRadix.c1 - (FFTMixedRadix.cd * FFTMixedRadix.c1 + FFTMixedRadix.sd * FFTMixedRadix.s1);
                                                    FFTMixedRadix.s1 = FFTMixedRadix.sd * FFTMixedRadix.c1 - FFTMixedRadix.cd * FFTMixedRadix.s1 + FFTMixedRadix.s1;
                                                    FFTMixedRadix.c1 = 2.0 - (FFTMixedRadix.c2 * FFTMixedRadix.c2 + FFTMixedRadix.s1 * FFTMixedRadix.s1);
                                                    FFTMixedRadix.s1 = FFTMixedRadix.c1 * FFTMixedRadix.s1;
                                                    FFTMixedRadix.c1 *= FFTMixedRadix.c2;
                                                    FFTMixedRadix.c2 = FFTMixedRadix.c1 * FFTMixedRadix.c1 - FFTMixedRadix.s1 * FFTMixedRadix.s1;
                                                    FFTMixedRadix.s2 = 2.0 * FFTMixedRadix.c1 * FFTMixedRadix.s1;
                                                    FFTMixedRadix.c3 = FFTMixedRadix.c2 * FFTMixedRadix.c1 - FFTMixedRadix.s2 * FFTMixedRadix.s1;
                                                    FFTMixedRadix.s3 = FFTMixedRadix.c2 * FFTMixedRadix.s1 + FFTMixedRadix.s2 * FFTMixedRadix.c1;
                                                    if ((FFTMixedRadix.kk = FFTMixedRadix.kk - FFTMixedRadix.nt + FFTMixedRadix.jc) <= FFTMixedRadix.kspan) {
                                                        bLoopLine420 = true;
                                                        bJumpToLine420 = true;
                                                    } else {
                                                        bLoopLine420 = false;
                                                        bJumpToLine420 = false;
                                                    }
                                                }
                                                if (bJumpToLine420 && !bJumpToLine460 && !bJumpToLine450) continue;
                                                if (!bJumpToLine460) {
                                                    if (!bJumpToLine450) {
                                                        if ((FFTMixedRadix.kk = FFTMixedRadix.kk - FFTMixedRadix.kspan + FFTMixedRadix.inc) <= FFTMixedRadix.jc) {
                                                            bLoopLine410 = true;
                                                            bJumpToLine410 = true;
                                                            bLoopLine440 = false;
                                                            bLoopLine430 = false;
                                                            bJumpToLine430 = false;
                                                            bLoopLine420 = false;
                                                            bJumpToLine420 = false;
                                                        } else {
                                                            bLoopLine410 = false;
                                                            bJumpToLine410 = false;
                                                        }
                                                        if (!bJumpToLine410) {
                                                            if (FFTMixedRadix.kspan == FFTMixedRadix.jc) {
                                                                bJumpToLine800_1 = true;
                                                                bLoopLine410 = false;
                                                                bLoopLine420 = false;
                                                                bLoopLine430 = false;
                                                                bLoopLine440 = false;
                                                                bJumpToLine410 = false;
                                                                bJumpToLine420 = false;
                                                                bJumpToLine430 = false;
                                                            } else {
                                                                bJumpToLine800_1 = false;
                                                            }
                                                            if (!bJumpToLine800_1) {
                                                                bLoopLine100 = true;
                                                                bJumpToLine100_2 = true;
                                                                bLoopLine410Prev_2 = bLoopLine410;
                                                                bLoopLine420Prev_2 = bLoopLine420;
                                                                bLoopLine430Prev_2 = bLoopLine430;
                                                                bLoopLine440Prev_2 = bLoopLine440;
                                                                bLoopLine510Prev_2 = bLoopLine510;
                                                                bLoopLine320Prev_2 = bLoopLine320;
                                                                bJumpToLine410Prev_2 = bJumpToLine410;
                                                                bJumpToLine420Prev_2 = bJumpToLine420;
                                                                bJumpToLine430Prev_2 = bJumpToLine430;
                                                                bJumpToLine510Prev_2 = bJumpToLine510;
                                                                bJumpToLine320Prev_2 = bJumpToLine320;
                                                                bLoopLine440 = false;
                                                                bLoopLine430 = false;
                                                                bLoopLine420 = false;
                                                                bLoopLine410 = false;
                                                                bLoopLine510 = false;
                                                                bLoopLine320 = false;
                                                                bJumpToLine410 = false;
                                                                bJumpToLine420 = false;
                                                                bJumpToLine430 = false;
                                                                bJumpToLine510 = false;
                                                                bJumpToLine320 = false;
                                                            }
                                                        }
                                                    }
                                                    if (!(bJumpToLine100_2 || bJumpToLine800_1 || bJumpToLine410)) {
                                                        bJumpToLine450 = false;
                                                        FFTMixedRadix.akp = FFTMixedRadix.akm + FFTMixedRadix.bjm;
                                                        FFTMixedRadix.akm -= FFTMixedRadix.bjm;
                                                        FFTMixedRadix.bkp = FFTMixedRadix.bkm - FFTMixedRadix.ajm;
                                                        FFTMixedRadix.bkm += FFTMixedRadix.ajm;
                                                        if (FFTMixedRadix.s1 != 0.0) {
                                                            bLoopLine430 = true;
                                                            bJumpToLine430 = true;
                                                            bLoopLine440 = false;
                                                        } else {
                                                            bLoopLine430 = false;
                                                            bJumpToLine430 = false;
                                                        }
                                                    }
                                                }
                                                if (bJumpToLine100_2 || bJumpToLine800_1 || bJumpToLine430 || bJumpToLine410) continue;
                                                bJumpToLine460 = false;
                                                a[FFTMixedRadix.k1 - 1] = FFTMixedRadix.akp;
                                                b[FFTMixedRadix.k1 - 1] = FFTMixedRadix.bkp;
                                                a[FFTMixedRadix.k2 - 1] = FFTMixedRadix.ajp;
                                                b[FFTMixedRadix.k2 - 1] = FFTMixedRadix.bjp;
                                                a[FFTMixedRadix.k3 - 1] = FFTMixedRadix.akm;
                                                b[FFTMixedRadix.k3 - 1] = FFTMixedRadix.bkm;
                                                FFTMixedRadix.kk = FFTMixedRadix.k3 + FFTMixedRadix.kspan;
                                                if (FFTMixedRadix.kk <= FFTMixedRadix.nt) {
                                                    bLoopLine420 = true;
                                                    bJumpToLine420 = true;
                                                } else {
                                                    bLoopLine420 = false;
                                                    bJumpToLine420 = false;
                                                }
                                                bLoopLine440 = bJumpToLine420 == false;
                                            } while (bLoopLine440);
                                        } while (bLoopLine430);
                                    } while (bLoopLine420);
                                } while (bLoopLine410);
                            }
                            if (!bJumpToLine100_2 && !bJumpToLine800_1) {
                                if (bJumpToLine510) {
                                    bJumpToLine510 = false;
                                    bLoopLine510 = false;
                                    bJumpToLine320 = bJumpToLine320Prev;
                                    bLoopLine320 = bLoopLine320Prev;
                                }
                                FFTMixedRadix.c2 = FFTMixedRadix.c72 * FFTMixedRadix.c72 - FFTMixedRadix.s72 * FFTMixedRadix.s72;
                                FFTMixedRadix.s2 = 2.0 * FFTMixedRadix.c72 * FFTMixedRadix.s72;
                                do {
                                    bLoopLine520 = false;
                                    bJumpToLine520 = false;
                                    FFTMixedRadix.k1 = FFTMixedRadix.kk + FFTMixedRadix.kspan;
                                    FFTMixedRadix.k2 = FFTMixedRadix.k1 + FFTMixedRadix.kspan;
                                    FFTMixedRadix.k3 = FFTMixedRadix.k2 + FFTMixedRadix.kspan;
                                    FFTMixedRadix.k4 = FFTMixedRadix.k3 + FFTMixedRadix.kspan;
                                    FFTMixedRadix.akp = a[FFTMixedRadix.k1 - 1] + a[FFTMixedRadix.k4 - 1];
                                    FFTMixedRadix.akm = a[FFTMixedRadix.k1 - 1] - a[FFTMixedRadix.k4 - 1];
                                    FFTMixedRadix.bkp = b[FFTMixedRadix.k1 - 1] + b[FFTMixedRadix.k4 - 1];
                                    FFTMixedRadix.bkm = b[FFTMixedRadix.k1 - 1] - b[FFTMixedRadix.k4 - 1];
                                    FFTMixedRadix.ajp = a[FFTMixedRadix.k2 - 1] + a[FFTMixedRadix.k3 - 1];
                                    FFTMixedRadix.ajm = a[FFTMixedRadix.k2 - 1] - a[FFTMixedRadix.k3 - 1];
                                    FFTMixedRadix.bjp = b[FFTMixedRadix.k2 - 1] + b[FFTMixedRadix.k3 - 1];
                                    FFTMixedRadix.bjm = b[FFTMixedRadix.k2 - 1] - b[FFTMixedRadix.k3 - 1];
                                    FFTMixedRadix.aa = a[FFTMixedRadix.kk - 1];
                                    FFTMixedRadix.bb = b[FFTMixedRadix.kk - 1];
                                    a[FFTMixedRadix.kk - 1] = FFTMixedRadix.aa + FFTMixedRadix.akp + FFTMixedRadix.ajp;
                                    b[FFTMixedRadix.kk - 1] = FFTMixedRadix.bb + FFTMixedRadix.bkp + FFTMixedRadix.bjp;
                                    FFTMixedRadix.ak = FFTMixedRadix.akp * FFTMixedRadix.c72 + FFTMixedRadix.ajp * FFTMixedRadix.c2 + FFTMixedRadix.aa;
                                    FFTMixedRadix.bk = FFTMixedRadix.bkp * FFTMixedRadix.c72 + FFTMixedRadix.bjp * FFTMixedRadix.c2 + FFTMixedRadix.bb;
                                    FFTMixedRadix.aj = FFTMixedRadix.akm * FFTMixedRadix.s72 + FFTMixedRadix.ajm * FFTMixedRadix.s2;
                                    FFTMixedRadix.bj = FFTMixedRadix.bkm * FFTMixedRadix.s72 + FFTMixedRadix.bjm * FFTMixedRadix.s2;
                                    a[FFTMixedRadix.k1 - 1] = FFTMixedRadix.ak - FFTMixedRadix.bj;
                                    a[FFTMixedRadix.k4 - 1] = FFTMixedRadix.ak + FFTMixedRadix.bj;
                                    b[FFTMixedRadix.k1 - 1] = FFTMixedRadix.bk + FFTMixedRadix.aj;
                                    b[FFTMixedRadix.k4 - 1] = FFTMixedRadix.bk - FFTMixedRadix.aj;
                                    FFTMixedRadix.ak = FFTMixedRadix.akp * FFTMixedRadix.c2 + FFTMixedRadix.ajp * FFTMixedRadix.c72 + FFTMixedRadix.aa;
                                    FFTMixedRadix.bk = FFTMixedRadix.bkp * FFTMixedRadix.c2 + FFTMixedRadix.bjp * FFTMixedRadix.c72 + FFTMixedRadix.bb;
                                    FFTMixedRadix.aj = FFTMixedRadix.akm * FFTMixedRadix.s2 - FFTMixedRadix.ajm * FFTMixedRadix.s72;
                                    FFTMixedRadix.bj = FFTMixedRadix.bkm * FFTMixedRadix.s2 - FFTMixedRadix.bjm * FFTMixedRadix.s72;
                                    a[FFTMixedRadix.k2 - 1] = FFTMixedRadix.ak - FFTMixedRadix.bj;
                                    a[FFTMixedRadix.k3 - 1] = FFTMixedRadix.ak + FFTMixedRadix.bj;
                                    b[FFTMixedRadix.k2 - 1] = FFTMixedRadix.bk + FFTMixedRadix.aj;
                                    b[FFTMixedRadix.k3 - 1] = FFTMixedRadix.bk - FFTMixedRadix.aj;
                                    FFTMixedRadix.kk = FFTMixedRadix.k4 + FFTMixedRadix.kspan;
                                    if (FFTMixedRadix.kk < FFTMixedRadix.nn) {
                                        bLoopLine520 = true;
                                        bJumpToLine520 = true;
                                    } else {
                                        bLoopLine520 = false;
                                        bJumpToLine520 = false;
                                    }
                                    if (bJumpToLine520) continue;
                                    if ((FFTMixedRadix.kk -= FFTMixedRadix.nn) <= FFTMixedRadix.kspan) {
                                        bLoopLine520 = true;
                                        bJumpToLine520 = true;
                                        continue;
                                    }
                                    bLoopLine520 = false;
                                    bJumpToLine520 = false;
                                } while (bLoopLine520);
                                bJumpToLine700 = true;
                            }
                        }
                        if (!(bJumpToLine100_2 || bJumpToLine800_1 || bJumpToLine700)) {
                            FFTMixedRadix.currentFactor = FFTMixedRadix.nfac[FFTMixedRadix.factInd - 1];
                            FFTMixedRadix.kspnn = FFTMixedRadix.kspan;
                            FFTMixedRadix.kspan /= FFTMixedRadix.currentFactor;
                            if (FFTMixedRadix.currentFactor == 3) {
                                bLoopLine320 = true;
                                bJumpToLine320 = true;
                            } else {
                                bLoopLine320 = false;
                                bJumpToLine320 = false;
                            }
                        }
                    }
                    if (bJumpToLine100_2 || bJumpToLine320 && !bJumpToLine800 && !bJumpToLine800_1 && !bJumpToLine700) continue;
                    if (!(bJumpToLine800 || bJumpToLine800_1 || bJumpToLine700)) {
                        if (FFTMixedRadix.currentFactor == 5) {
                            bLoopLine510 = true;
                            bJumpToLine510 = true;
                            bJumpToLine320Prev = bJumpToLine320;
                            bLoopLine320Prev = bLoopLine320;
                            bLoopLine320 = false;
                            bJumpToLine320 = false;
                        } else {
                            bLoopLine510 = false;
                            bJumpToLine510 = false;
                        }
                    }
                    if (bJumpToLine510 && !bJumpToLine800 && !bJumpToLine800_1 && !bJumpToLine700) continue;
                    if (!bJumpToLine800 && !bJumpToLine800_1) {
                        if (!bJumpToLine700) {
                            bJumpToLine640_0 = FFTMixedRadix.currentFactor == FFTMixedRadix.jf;
                            if (!bJumpToLine640_0) {
                                FFTMixedRadix.jf = FFTMixedRadix.currentFactor;
                                FFTMixedRadix.s1 = FFTMixedRadix.rad / (double)FFTMixedRadix.currentFactor;
                                FFTMixedRadix.c1 = Math.cos(FFTMixedRadix.s1);
                                FFTMixedRadix.s1 = Math.sin(FFTMixedRadix.s1);
                                if (FFTMixedRadix.jf > FFTMixedRadix.maxf) {
                                    isn = 0;
                                    System.out.println("Array bounds exceeded within subroutine fft\fftSize");
                                    return;
                                }
                                FFTMixedRadix.ck[FFTMixedRadix.jf - 1] = 1.0;
                                FFTMixedRadix.sk[FFTMixedRadix.jf - 1] = 0.0;
                                FFTMixedRadix.jCount = 1;
                                do {
                                    FFTMixedRadix.ck[FFTMixedRadix.jCount - 1] = FFTMixedRadix.ck[FFTMixedRadix.currentFactor - 1] * FFTMixedRadix.c1 + FFTMixedRadix.sk[FFTMixedRadix.currentFactor - 1] * FFTMixedRadix.s1;
                                    FFTMixedRadix.sk[FFTMixedRadix.jCount - 1] = FFTMixedRadix.ck[FFTMixedRadix.currentFactor - 1] * FFTMixedRadix.s1 - FFTMixedRadix.sk[FFTMixedRadix.currentFactor - 1] * FFTMixedRadix.c1;
                                    FFTMixedRadix.ck[--FFTMixedRadix.currentFactor - 1] = FFTMixedRadix.ck[FFTMixedRadix.jCount - 1];
                                    FFTMixedRadix.sk[FFTMixedRadix.currentFactor - 1] = -FFTMixedRadix.sk[FFTMixedRadix.jCount - 1];
                                } while (++FFTMixedRadix.jCount < FFTMixedRadix.currentFactor);
                            }
                            do {
                                bLoopLine640 = false;
                                bJumpToLine640 = false;
                                FFTMixedRadix.k1 = FFTMixedRadix.kk;
                                FFTMixedRadix.k2 = FFTMixedRadix.kk + FFTMixedRadix.kspnn;
                                FFTMixedRadix.aa = a[FFTMixedRadix.kk - 1];
                                FFTMixedRadix.bb = b[FFTMixedRadix.kk - 1];
                                FFTMixedRadix.ak = FFTMixedRadix.aa;
                                FFTMixedRadix.bk = FFTMixedRadix.bb;
                                FFTMixedRadix.jCount = 1;
                                FFTMixedRadix.k1 += FFTMixedRadix.kspan;
                                do {
                                    FFTMixedRadix.at[++FFTMixedRadix.jCount - 1] = a[FFTMixedRadix.k1 - 1] + a[(FFTMixedRadix.k2 -= FFTMixedRadix.kspan) - 1];
                                    FFTMixedRadix.ak = FFTMixedRadix.at[FFTMixedRadix.jCount - 1] + FFTMixedRadix.ak;
                                    FFTMixedRadix.bt[FFTMixedRadix.jCount - 1] = b[FFTMixedRadix.k1 - 1] + b[FFTMixedRadix.k2 - 1];
                                    FFTMixedRadix.bk = FFTMixedRadix.bt[FFTMixedRadix.jCount - 1] + FFTMixedRadix.bk;
                                    FFTMixedRadix.at[++FFTMixedRadix.jCount - 1] = a[FFTMixedRadix.k1 - 1] - a[FFTMixedRadix.k2 - 1];
                                    FFTMixedRadix.bt[FFTMixedRadix.jCount - 1] = b[FFTMixedRadix.k1 - 1] - b[FFTMixedRadix.k2 - 1];
                                } while ((FFTMixedRadix.k1 += FFTMixedRadix.kspan) < FFTMixedRadix.k2);
                                a[FFTMixedRadix.kk - 1] = FFTMixedRadix.ak;
                                b[FFTMixedRadix.kk - 1] = FFTMixedRadix.bk;
                                FFTMixedRadix.k1 = FFTMixedRadix.kk;
                                FFTMixedRadix.k2 = FFTMixedRadix.kk + FFTMixedRadix.kspnn;
                                FFTMixedRadix.jCount = 1;
                                do {
                                    FFTMixedRadix.k1 += FFTMixedRadix.kspan;
                                    FFTMixedRadix.k2 -= FFTMixedRadix.kspan;
                                    FFTMixedRadix.jj = FFTMixedRadix.jCount;
                                    FFTMixedRadix.ak = FFTMixedRadix.aa;
                                    FFTMixedRadix.bk = FFTMixedRadix.bb;
                                    FFTMixedRadix.aj = 0.0;
                                    FFTMixedRadix.bj = 0.0;
                                    FFTMixedRadix.currentFactor = 1;
                                    do {
                                        FFTMixedRadix.ak = FFTMixedRadix.at[++FFTMixedRadix.currentFactor - 1] * FFTMixedRadix.ck[FFTMixedRadix.jj - 1] + FFTMixedRadix.ak;
                                        FFTMixedRadix.bk = FFTMixedRadix.bt[FFTMixedRadix.currentFactor - 1] * FFTMixedRadix.ck[FFTMixedRadix.jj - 1] + FFTMixedRadix.bk;
                                        FFTMixedRadix.aj = FFTMixedRadix.at[++FFTMixedRadix.currentFactor - 1] * FFTMixedRadix.sk[FFTMixedRadix.jj - 1] + FFTMixedRadix.aj;
                                        FFTMixedRadix.bj = FFTMixedRadix.bt[FFTMixedRadix.currentFactor - 1] * FFTMixedRadix.sk[FFTMixedRadix.jj - 1] + FFTMixedRadix.bj;
                                        if ((FFTMixedRadix.jj += FFTMixedRadix.jCount) <= FFTMixedRadix.jf) continue;
                                        FFTMixedRadix.jj -= FFTMixedRadix.jf;
                                    } while (FFTMixedRadix.currentFactor < FFTMixedRadix.jf);
                                    FFTMixedRadix.currentFactor = FFTMixedRadix.jf - FFTMixedRadix.jCount;
                                    a[FFTMixedRadix.k1 - 1] = FFTMixedRadix.ak - FFTMixedRadix.bj;
                                    b[FFTMixedRadix.k1 - 1] = FFTMixedRadix.bk + FFTMixedRadix.aj;
                                    a[FFTMixedRadix.k2 - 1] = FFTMixedRadix.ak + FFTMixedRadix.bj;
                                    b[FFTMixedRadix.k2 - 1] = FFTMixedRadix.bk - FFTMixedRadix.aj;
                                } while (++FFTMixedRadix.jCount < FFTMixedRadix.currentFactor);
                                if ((FFTMixedRadix.kk += FFTMixedRadix.kspnn) <= FFTMixedRadix.nn) {
                                    bLoopLine640 = true;
                                    bJumpToLine640 = true;
                                } else {
                                    bLoopLine640 = false;
                                    bJumpToLine640 = false;
                                }
                                if (bJumpToLine640) continue;
                                if ((FFTMixedRadix.kk -= FFTMixedRadix.nn) <= FFTMixedRadix.kspan) {
                                    bLoopLine640 = true;
                                    bJumpToLine640 = true;
                                    continue;
                                }
                                bLoopLine640 = false;
                                bJumpToLine640 = false;
                            } while (bLoopLine640);
                        }
                        bJumpToLine700 = false;
                        bJumpToLine800 = FFTMixedRadix.factInd == FFTMixedRadix.mCount;
                        if (!bJumpToLine800) {
                            FFTMixedRadix.kk = FFTMixedRadix.jc + 1;
                            do {
                                FFTMixedRadix.c2 = 1.0 - FFTMixedRadix.cd;
                                FFTMixedRadix.s1 = FFTMixedRadix.sd;
                                do {
                                    FFTMixedRadix.c1 = FFTMixedRadix.c2;
                                    FFTMixedRadix.s2 = FFTMixedRadix.s1;
                                    FFTMixedRadix.kk += FFTMixedRadix.kspan;
                                    do {
                                        bJumpToLine730 = false;
                                        bLoopLine730 = false;
                                        FFTMixedRadix.ak = a[FFTMixedRadix.kk - 1];
                                        a[FFTMixedRadix.kk - 1] = FFTMixedRadix.c2 * FFTMixedRadix.ak - FFTMixedRadix.s2 * b[FFTMixedRadix.kk - 1];
                                        b[FFTMixedRadix.kk - 1] = FFTMixedRadix.s2 * FFTMixedRadix.ak + FFTMixedRadix.c2 * b[FFTMixedRadix.kk - 1];
                                        if ((FFTMixedRadix.kk += FFTMixedRadix.kspnn) <= FFTMixedRadix.nt) {
                                            bJumpToLine730 = true;
                                            bLoopLine730 = true;
                                        } else {
                                            bJumpToLine730 = false;
                                            bLoopLine730 = false;
                                        }
                                        if (bJumpToLine730) continue;
                                        FFTMixedRadix.ak = FFTMixedRadix.s1 * FFTMixedRadix.s2;
                                        FFTMixedRadix.s2 = FFTMixedRadix.s1 * FFTMixedRadix.c2 + FFTMixedRadix.c1 * FFTMixedRadix.s2;
                                        FFTMixedRadix.c2 = FFTMixedRadix.c1 * FFTMixedRadix.c2 - FFTMixedRadix.ak;
                                        if ((FFTMixedRadix.kk = FFTMixedRadix.kk - FFTMixedRadix.nt + FFTMixedRadix.kspan) <= FFTMixedRadix.kspnn) {
                                            bJumpToLine730 = true;
                                            bLoopLine730 = true;
                                            continue;
                                        }
                                        bJumpToLine730 = false;
                                        bLoopLine730 = false;
                                    } while (bLoopLine730);
                                    FFTMixedRadix.c2 = FFTMixedRadix.c1 - (FFTMixedRadix.cd * FFTMixedRadix.c1 + FFTMixedRadix.sd * FFTMixedRadix.s1);
                                    FFTMixedRadix.s1 += FFTMixedRadix.sd * FFTMixedRadix.c1 - FFTMixedRadix.cd * FFTMixedRadix.s1;
                                    FFTMixedRadix.c1 = 2.0 - (FFTMixedRadix.c2 * FFTMixedRadix.c2 + FFTMixedRadix.s1 * FFTMixedRadix.s1);
                                    FFTMixedRadix.s1 = FFTMixedRadix.c1 * FFTMixedRadix.s1;
                                    FFTMixedRadix.c2 = FFTMixedRadix.c1 * FFTMixedRadix.c2;
                                } while ((FFTMixedRadix.kk = FFTMixedRadix.kk - FFTMixedRadix.kspnn + FFTMixedRadix.jc) <= FFTMixedRadix.kspan);
                            } while ((FFTMixedRadix.kk = FFTMixedRadix.kk - FFTMixedRadix.kspan + FFTMixedRadix.jc + FFTMixedRadix.inc) <= FFTMixedRadix.jc + FFTMixedRadix.jc);
                            bLoopLine100 = true;
                            bJumpToLine100_3 = true;
                            bLoopLine510Prev_3 = bLoopLine510;
                            bLoopLine320Prev_3 = bLoopLine320;
                            bJumpToLine510Prev_3 = bJumpToLine510;
                            bJumpToLine320Prev_3 = bJumpToLine320;
                            bLoopLine510 = false;
                            bLoopLine320 = false;
                            bJumpToLine510 = false;
                            bJumpToLine320 = false;
                        }
                    }
                    if (bJumpToLine100_3) continue;
                    bJumpToLine800 = false;
                    bJumpToLine800_1 = false;
                    FFTMixedRadix.np[0] = FFTMixedRadix.ks;
                    if (FFTMixedRadix.kt == 0) {
                        bJumpToLine890 = true;
                    }
                    if (!bJumpToLine890) {
                        FFTMixedRadix.currentFactor = FFTMixedRadix.kt + FFTMixedRadix.kt + 1;
                        if (FFTMixedRadix.mCount < FFTMixedRadix.currentFactor) {
                            --FFTMixedRadix.currentFactor;
                        }
                        FFTMixedRadix.jCount = 1;
                        FFTMixedRadix.np[FFTMixedRadix.currentFactor + 1 - 1] = FFTMixedRadix.jc;
                        do {
                            FFTMixedRadix.np[FFTMixedRadix.jCount + 1 - 1] = FFTMixedRadix.np[FFTMixedRadix.jCount - 1] / FFTMixedRadix.nfac[FFTMixedRadix.jCount - 1];
                            FFTMixedRadix.np[FFTMixedRadix.currentFactor - 1] = FFTMixedRadix.np[FFTMixedRadix.currentFactor + 1 - 1] * FFTMixedRadix.nfac[FFTMixedRadix.jCount - 1];
                        } while (++FFTMixedRadix.jCount < --FFTMixedRadix.currentFactor);
                        FFTMixedRadix.k3 = FFTMixedRadix.np[FFTMixedRadix.currentFactor + 1 - 1];
                        FFTMixedRadix.kspan = FFTMixedRadix.np[1];
                        FFTMixedRadix.kk = FFTMixedRadix.jc + 1;
                        FFTMixedRadix.k2 = FFTMixedRadix.kspan + 1;
                        FFTMixedRadix.jCount = 1;
                    }
                    if (fftSize == ntot || !bJumpToLine890) {
                        if (!bJumpToLine890) {
                            do {
                                bLoopLine820 = false;
                                bJumpToLine820 = false;
                                FFTMixedRadix.ak = a[FFTMixedRadix.kk - 1];
                                a[FFTMixedRadix.kk - 1] = a[FFTMixedRadix.k2 - 1];
                                a[FFTMixedRadix.k2 - 1] = FFTMixedRadix.ak;
                                FFTMixedRadix.bk = b[FFTMixedRadix.kk - 1];
                                b[FFTMixedRadix.kk - 1] = b[FFTMixedRadix.k2 - 1];
                                b[FFTMixedRadix.k2 - 1] = FFTMixedRadix.bk;
                                FFTMixedRadix.kk += FFTMixedRadix.inc;
                                if ((FFTMixedRadix.k2 = FFTMixedRadix.kspan + FFTMixedRadix.k2) < FFTMixedRadix.ks) {
                                    bLoopLine820 = true;
                                    bJumpToLine820 = true;
                                } else {
                                    bLoopLine820 = false;
                                    bJumpToLine820 = false;
                                }
                                if (bJumpToLine820) continue;
                                do {
                                    bLoopLine830 = false;
                                    bJumpToLine830 = false;
                                    FFTMixedRadix.k2 -= FFTMixedRadix.np[FFTMixedRadix.jCount - 1];
                                    if ((FFTMixedRadix.k2 = FFTMixedRadix.np[++FFTMixedRadix.jCount + 1 - 1] + FFTMixedRadix.k2) > FFTMixedRadix.np[FFTMixedRadix.jCount - 1]) {
                                        bLoopLine830 = true;
                                        bJumpToLine830 = true;
                                    } else {
                                        bLoopLine830 = false;
                                        bJumpToLine830 = false;
                                    }
                                    if (bJumpToLine830) continue;
                                    FFTMixedRadix.jCount = 1;
                                    do {
                                        bLoopLine840 = false;
                                        bJumpToLine840 = false;
                                        if (FFTMixedRadix.kk < FFTMixedRadix.k2) {
                                            bLoopLine820 = true;
                                            bJumpToLine820 = true;
                                            bLoopLine830 = false;
                                            bJumpToLine830 = false;
                                        } else {
                                            bLoopLine820 = false;
                                            bJumpToLine820 = false;
                                        }
                                        if (bJumpToLine820) continue;
                                        FFTMixedRadix.kk += FFTMixedRadix.inc;
                                        if ((FFTMixedRadix.k2 = FFTMixedRadix.kspan + FFTMixedRadix.k2) < FFTMixedRadix.ks) {
                                            bLoopLine840 = true;
                                            bJumpToLine840 = true;
                                        } else {
                                            bLoopLine840 = false;
                                            bJumpToLine840 = false;
                                        }
                                        if (bJumpToLine840) continue;
                                        if (FFTMixedRadix.kk < FFTMixedRadix.ks) {
                                            bLoopLine830 = true;
                                            bJumpToLine830 = true;
                                        } else {
                                            bLoopLine830 = false;
                                            bJumpToLine830 = false;
                                        }
                                        if (bJumpToLine830) continue;
                                        FFTMixedRadix.jc = FFTMixedRadix.k3;
                                    } while (bLoopLine840);
                                } while (bLoopLine830);
                            } while (bLoopLine820);
                        }
                        bJumpToLine890 = true;
                    }
                    if (!bJumpToLine890) {
                        do {
                            bLoopLine850 = false;
                            bJumpToLine850 = false;
                            FFTMixedRadix.currentFactor = FFTMixedRadix.kk + FFTMixedRadix.jc;
                            do {
                                FFTMixedRadix.ak = a[FFTMixedRadix.kk - 1];
                                a[FFTMixedRadix.kk - 1] = a[FFTMixedRadix.k2 - 1];
                                a[FFTMixedRadix.k2 - 1] = FFTMixedRadix.ak;
                                FFTMixedRadix.bk = b[FFTMixedRadix.kk - 1];
                                b[FFTMixedRadix.kk - 1] = b[FFTMixedRadix.k2 - 1];
                                b[FFTMixedRadix.k2 - 1] = FFTMixedRadix.bk;
                                FFTMixedRadix.k2 += FFTMixedRadix.inc;
                            } while ((FFTMixedRadix.kk += FFTMixedRadix.inc) < FFTMixedRadix.currentFactor);
                            FFTMixedRadix.kk = FFTMixedRadix.kk + FFTMixedRadix.ks - FFTMixedRadix.jc;
                            FFTMixedRadix.k2 = FFTMixedRadix.k2 + FFTMixedRadix.ks - FFTMixedRadix.jc;
                            if (FFTMixedRadix.kk < FFTMixedRadix.nt) {
                                bLoopLine850 = true;
                                bJumpToLine850 = true;
                            } else {
                                bLoopLine850 = false;
                                bJumpToLine850 = false;
                            }
                            if (bJumpToLine850) continue;
                            FFTMixedRadix.k2 = FFTMixedRadix.k2 - FFTMixedRadix.nt + FFTMixedRadix.kspan;
                            FFTMixedRadix.kk = FFTMixedRadix.kk - FFTMixedRadix.nt + FFTMixedRadix.jc;
                            if (FFTMixedRadix.k2 < FFTMixedRadix.ks) {
                                bLoopLine850 = true;
                                bJumpToLine850 = true;
                            } else {
                                bLoopLine850 = false;
                                bJumpToLine850 = false;
                            }
                            if (bJumpToLine850) continue;
                            do {
                                bLoopLine870 = false;
                                bJumpToLine870 = false;
                                FFTMixedRadix.k2 -= FFTMixedRadix.np[FFTMixedRadix.jCount - 1];
                                if ((FFTMixedRadix.k2 = FFTMixedRadix.np[++FFTMixedRadix.jCount + 1 - 1] + FFTMixedRadix.k2) > FFTMixedRadix.np[FFTMixedRadix.jCount - 1]) {
                                    bLoopLine870 = true;
                                    bJumpToLine870 = true;
                                } else {
                                    bLoopLine870 = false;
                                    bJumpToLine870 = false;
                                }
                                if (bJumpToLine870) continue;
                                FFTMixedRadix.jCount = 1;
                                do {
                                    bLoopLine880 = false;
                                    bJumpToLine880 = false;
                                    if (FFTMixedRadix.kk < FFTMixedRadix.k2) {
                                        bLoopLine850 = true;
                                        bJumpToLine850 = true;
                                    } else {
                                        bLoopLine850 = false;
                                        bJumpToLine850 = false;
                                    }
                                    if (bJumpToLine850) continue;
                                    FFTMixedRadix.kk += FFTMixedRadix.jc;
                                    if ((FFTMixedRadix.k2 = FFTMixedRadix.kspan + FFTMixedRadix.k2) < FFTMixedRadix.ks) {
                                        bLoopLine880 = true;
                                        bJumpToLine880 = true;
                                    } else {
                                        bLoopLine880 = false;
                                        bJumpToLine880 = false;
                                    }
                                    if (bJumpToLine880) continue;
                                    if (FFTMixedRadix.kk < FFTMixedRadix.ks) {
                                        bLoopLine870 = true;
                                        bJumpToLine870 = true;
                                    } else {
                                        bLoopLine870 = false;
                                        bJumpToLine870 = false;
                                    }
                                    if (bJumpToLine870) continue;
                                    FFTMixedRadix.jc = FFTMixedRadix.k3;
                                } while (bLoopLine880);
                            } while (bLoopLine870);
                        } while (bLoopLine850);
                    }
                    bJumpToLine890 = false;
                    if (2 * FFTMixedRadix.kt + 1 >= FFTMixedRadix.mCount) {
                        return;
                    }
                    FFTMixedRadix.kspnn = FFTMixedRadix.np[FFTMixedRadix.kt + 1 - 1];
                    FFTMixedRadix.jCount = FFTMixedRadix.mCount - FFTMixedRadix.kt;
                    FFTMixedRadix.nfac[FFTMixedRadix.jCount + 1 - 1] = 1;
                    do {
                        FFTMixedRadix.nfac[FFTMixedRadix.jCount - 1] = FFTMixedRadix.nfac[FFTMixedRadix.jCount - 1] * FFTMixedRadix.nfac[FFTMixedRadix.jCount + 1 - 1];
                    } while (--FFTMixedRadix.jCount != FFTMixedRadix.kt);
                    if ((FFTMixedRadix.nn = FFTMixedRadix.nfac[++FFTMixedRadix.kt - 1] - 1) > FFTMixedRadix.maxp) {
                        isn = 0;
                        System.out.println("Array bounds exceeded within subroutine fft\fftSize");
                        return;
                    }
                    FFTMixedRadix.jj = 0;
                    FFTMixedRadix.jCount = 0;
                    bJumpToLine906 = true;
                    do {
                        if (!bJumpToLine906) {
                            bLoopLine902 = false;
                            bJumpToLine902 = false;
                            FFTMixedRadix.jj -= FFTMixedRadix.k2;
                            FFTMixedRadix.k2 = FFTMixedRadix.kk;
                            FFTMixedRadix.kk = FFTMixedRadix.nfac[++FFTMixedRadix.currentFactor - 1];
                        }
                        do {
                            if (!bJumpToLine906) {
                                bLoopLine904 = false;
                                bJumpToLine904 = false;
                                if ((FFTMixedRadix.jj = FFTMixedRadix.kk + FFTMixedRadix.jj) >= FFTMixedRadix.k2) {
                                    bLoopLine902 = true;
                                    bJumpToLine902 = true;
                                } else {
                                    bLoopLine902 = false;
                                    bJumpToLine902 = false;
                                }
                            }
                            if (bJumpToLine902 && !bJumpToLine906) continue;
                            if (!bJumpToLine906) {
                                FFTMixedRadix.np[FFTMixedRadix.jCount - 1] = FFTMixedRadix.jj;
                            }
                            bJumpToLine906 = false;
                            FFTMixedRadix.k2 = FFTMixedRadix.nfac[FFTMixedRadix.kt - 1];
                            FFTMixedRadix.currentFactor = FFTMixedRadix.kt + 1;
                            FFTMixedRadix.kk = FFTMixedRadix.nfac[FFTMixedRadix.currentFactor - 1];
                            if (++FFTMixedRadix.jCount <= FFTMixedRadix.nn) {
                                bLoopLine904 = true;
                                bJumpToLine904 = true;
                            } else {
                                bLoopLine904 = false;
                                bJumpToLine904 = false;
                            }
                            if (bJumpToLine904) continue;
                            FFTMixedRadix.jCount = 0;
                            bJumpToLine914_0 = true;
                            do {
                                if (!bJumpToLine914_0) {
                                    bLoopLine910 = false;
                                    bJumpToLine910 = false;
                                    FFTMixedRadix.currentFactor = FFTMixedRadix.kk;
                                    FFTMixedRadix.kk = FFTMixedRadix.np[FFTMixedRadix.currentFactor - 1];
                                    FFTMixedRadix.np[FFTMixedRadix.currentFactor - 1] = -FFTMixedRadix.kk;
                                    if (FFTMixedRadix.kk != FFTMixedRadix.jCount) {
                                        bLoopLine910 = true;
                                        bJumpToLine910 = true;
                                    } else {
                                        bLoopLine910 = false;
                                        bJumpToLine910 = false;
                                    }
                                }
                                if (bJumpToLine910 && !bJumpToLine914_0) continue;
                                if (!bJumpToLine914_0) {
                                    FFTMixedRadix.k3 = FFTMixedRadix.kk;
                                }
                                do {
                                    bLoopLine914 = false;
                                    bJumpToLine914 = false;
                                    bJumpToLine914_0 = false;
                                    if ((FFTMixedRadix.kk = FFTMixedRadix.np[++FFTMixedRadix.jCount - 1]) < 0) {
                                        bLoopLine914 = true;
                                        bJumpToLine914 = true;
                                    } else {
                                        bLoopLine914 = false;
                                        bJumpToLine914 = false;
                                    }
                                    if (bJumpToLine914) continue;
                                    if (FFTMixedRadix.kk != FFTMixedRadix.jCount) {
                                        bLoopLine910 = true;
                                        bJumpToLine910 = true;
                                    } else {
                                        bLoopLine910 = false;
                                        bJumpToLine910 = false;
                                    }
                                    if (bJumpToLine910) continue;
                                    FFTMixedRadix.np[FFTMixedRadix.jCount - 1] = -FFTMixedRadix.jCount;
                                    if (FFTMixedRadix.jCount != FFTMixedRadix.nn) {
                                        bLoopLine914 = true;
                                        bJumpToLine914 = true;
                                    } else {
                                        bLoopLine914 = false;
                                        bJumpToLine914 = false;
                                    }
                                    if (bJumpToLine914) continue;
                                    FFTMixedRadix.maxf = FFTMixedRadix.inc * FFTMixedRadix.maxf;
                                    bJumpToLine950 = true;
                                } while (bLoopLine914);
                            } while (bLoopLine910);
                            do {
                                bLoopLine924 = false;
                                bJumpToLine924 = false;
                                if (!bJumpToLine950) {
                                    if (FFTMixedRadix.np[--FFTMixedRadix.jCount - 1] < 0) {
                                        bLoopLine924 = true;
                                        bJumpToLine924 = true;
                                    } else {
                                        bLoopLine924 = false;
                                        bJumpToLine924 = false;
                                    }
                                    if (!bJumpToLine924) {
                                        FFTMixedRadix.jj = FFTMixedRadix.jc;
                                        do {
                                            FFTMixedRadix.kspan = FFTMixedRadix.jj;
                                            if (FFTMixedRadix.jj > FFTMixedRadix.maxf) {
                                                FFTMixedRadix.kspan = FFTMixedRadix.maxf;
                                            }
                                            FFTMixedRadix.currentFactor = FFTMixedRadix.np[FFTMixedRadix.jCount - 1];
                                            FFTMixedRadix.kk = FFTMixedRadix.jc * FFTMixedRadix.currentFactor + FFTMixedRadix.factInd + (FFTMixedRadix.jj -= FFTMixedRadix.kspan);
                                            FFTMixedRadix.k1 = FFTMixedRadix.kk + FFTMixedRadix.kspan;
                                            FFTMixedRadix.k2 = 0;
                                            do {
                                                FFTMixedRadix.at[++FFTMixedRadix.k2 - 1] = a[FFTMixedRadix.k1 - 1];
                                                FFTMixedRadix.bt[FFTMixedRadix.k2 - 1] = b[FFTMixedRadix.k1 - 1];
                                            } while ((FFTMixedRadix.k1 -= FFTMixedRadix.inc) != FFTMixedRadix.kk);
                                            do {
                                                FFTMixedRadix.k1 = FFTMixedRadix.kk + FFTMixedRadix.kspan;
                                                FFTMixedRadix.k2 = FFTMixedRadix.k1 - FFTMixedRadix.jc * (FFTMixedRadix.currentFactor + FFTMixedRadix.np[FFTMixedRadix.currentFactor - 1]);
                                                FFTMixedRadix.currentFactor = -FFTMixedRadix.np[FFTMixedRadix.currentFactor - 1];
                                                do {
                                                    a[FFTMixedRadix.k1 - 1] = a[FFTMixedRadix.k2 - 1];
                                                    b[FFTMixedRadix.k1 - 1] = b[FFTMixedRadix.k2 - 1];
                                                    FFTMixedRadix.k2 -= FFTMixedRadix.inc;
                                                } while ((FFTMixedRadix.k1 -= FFTMixedRadix.inc) != FFTMixedRadix.kk);
                                                FFTMixedRadix.kk = FFTMixedRadix.k2;
                                            } while (FFTMixedRadix.currentFactor != FFTMixedRadix.jCount);
                                            FFTMixedRadix.k1 = FFTMixedRadix.kk + FFTMixedRadix.kspan;
                                            FFTMixedRadix.k2 = 0;
                                            do {
                                                a[FFTMixedRadix.k1 - 1] = FFTMixedRadix.at[++FFTMixedRadix.k2 - 1];
                                                b[FFTMixedRadix.k1 - 1] = FFTMixedRadix.bt[FFTMixedRadix.k2 - 1];
                                            } while ((FFTMixedRadix.k1 -= FFTMixedRadix.inc) != FFTMixedRadix.kk);
                                        } while (FFTMixedRadix.jj != 0);
                                        if (FFTMixedRadix.jCount != 1) {
                                            bLoopLine924 = true;
                                            bJumpToLine924 = true;
                                        } else {
                                            bLoopLine924 = false;
                                            bJumpToLine924 = false;
                                        }
                                    }
                                }
                                if (!bJumpToLine950 && bJumpToLine924) continue;
                                bJumpToLine950 = false;
                                FFTMixedRadix.jCount = FFTMixedRadix.k3 + 1;
                                FFTMixedRadix.factInd = (FFTMixedRadix.nt -= FFTMixedRadix.kspnn) - FFTMixedRadix.inc + 1;
                                if (FFTMixedRadix.nt >= 0) {
                                    bLoopLine924 = true;
                                    bJumpToLine924 = true;
                                    continue;
                                }
                                bLoopLine924 = false;
                                bJumpToLine924 = false;
                            } while (bLoopLine924);
                        } while (bLoopLine904);
                    } while (bLoopLine902);
                } while (bLoopLine510);
            } while (bLoopLine320);
        } while (bLoopLine100);
    }

    public static void test_fft_ifft_real_random() {
        int totalPoints = (int)(10.0 * Math.random() + 50.0);
        int[] numPoints = new int[totalPoints];
        int i = 0;
        while (i < totalPoints) {
            numPoints[i] = (int)(6000.0 * Math.random() + 23.0);
            ++i;
        }
        i = 0;
        while (i < totalPoints) {
            int fftSize = numPoints[i] + (int)(100.0 * Math.random());
            int ifftSize = numPoints[i] + (int)(100.0 * Math.random());
            double[] x = new double[numPoints[i]];
            int j = 0;
            while (j < numPoints[i]) {
                x[j] = 40000.0 * (Math.random() - 0.5);
                ++j;
            }
            ComplexArray h = FFTMixedRadix.fftReal(x, numPoints[i], fftSize);
            String strMessage = String.valueOf(fftSize) + "-point FFT computed from " + numPoints[i] + " random real values...";
            System.out.println(strMessage);
            double[] y = FFTMixedRadix.ifftReal(h, ifftSize);
            strMessage = String.valueOf(ifftSize) + "-point IFFT computed...";
            System.out.println(strMessage);
            int j2 = 0;
            while (j2 < numPoints[i]) {
                if (Math.abs(x[j2] - y[j2]) > 1.0E-4) {
                    System.out.println("Detected difference...");
                }
                ++j2;
            }
            strMessage = "Test #" + (i + 1) + " of " + totalPoints + " complete for " + numPoints[i] + " random values...\n";
            System.out.println(strMessage);
            ++i;
        }
    }

    public static void main(String[] args) {
        FFTMixedRadix.test_fft_ifft_real_random();
    }
}

