/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.math;

import marytts.util.math.ComplexArray;
import marytts.util.math.FFTMixedRadix;

public class Hilbert {
    public static ComplexArray transform(double[] x) {
        return Hilbert.transform(x, x.length);
    }

    public static ComplexArray transform(double[] x, int N) {
        ComplexArray X = FFTMixedRadix.fftReal(x, N);
        double[] H2 = new double[N];
        int NOver2 = (int)Math.floor((double)(N / 2) + 0.5);
        H2[0] = 1.0;
        H2[NOver2] = 1.0;
        int w = 1;
        while (w <= NOver2 - 1) {
            H2[w] = 2.0;
            ++w;
        }
        w = NOver2 + 1;
        while (w <= N - 1) {
            H2[w] = 0.0;
            ++w;
        }
        w = 0;
        while (w < N) {
            int n = w;
            X.real[n] = X.real[n] * H2[w];
            int n2 = w;
            X.imag[n2] = X.imag[n2] * H2[w];
            ++w;
        }
        return FFTMixedRadix.ifft(X);
    }
}

