/*
 * Decompiled with CFR 0.152.
 */
package pcl.OpenFM;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pcl.OpenFM.CommonProxy;
import pcl.OpenFM.ContentRegistry;
import pcl.OpenFM.GUI.OFMGuiHandler;
import pcl.OpenFM.Handler.ClientEvent;
import pcl.OpenFM.Handler.ServerEvent;
import pcl.OpenFM.OFMConfiguration;
import pcl.OpenFM.network.PacketHandler;
import pcl.OpenFM.player.PlayerDispatcher;

@Mod(modid="openfm", name="OpenFM", version="0.1.0.13", dependencies="", guiFactory="pcl.OpenFM.GUI.OFMGuiFactory", acceptedMinecraftVersions="1.12.2")
public class OpenFM {
    public static final String MODID = "openfm";
    @Mod.Instance(value="openfm")
    public static OpenFM instance;
    @SidedProxy(clientSide="pcl.OpenFM.ClientProxy", serverSide="pcl.OpenFM.CommonProxy")
    public static CommonProxy proxy;
    public static List<PlayerDispatcher> playerList;
    public static final Logger logger;
    public static File configFile;
    private static ContentRegistry contentRegistry;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        PacketHandler.init();
        MinecraftForge.EVENT_BUS.register((Object)contentRegistry);
        configFile = new File(event.getModConfigurationDirectory() + "/openfm/openfm.cfg");
        OFMConfiguration.init(configFile);
        ContentRegistry.preInit();
        proxy.initTileEntities();
        FMLCommonHandler.instance().bus().register((Object)instance);
        MinecraftForge.EVENT_BUS.register((Object)instance);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRegisterModels(ModelRegistryEvent event) {
        proxy.registerItemRenderers();
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new OFMGuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvent());
        FMLCommonHandler.instance().bus().register((Object)new ClientEvent());
        MinecraftForge.EVENT_BUS.register((Object)new ServerEvent());
        FMLCommonHandler.instance().bus().register((Object)new ServerEvent());
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals(MODID)) {
            OFMConfiguration.sync();
        }
    }

    public static void killAllStreams() {
        if (playerList != null) {
            for (PlayerDispatcher p : playerList) {
                if (p == null || !p.isPlaying()) continue;
                p.stop();
            }
        }
    }

    static {
        playerList = new ArrayList<PlayerDispatcher>();
        logger = LogManager.getFormatterLogger((String)MODID);
        contentRegistry = new ContentRegistry();
    }
}

